/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.validator.password;

import com.openkm.core.Config;
import com.openkm.validator.ValidatorException;
import com.openkm.validator.password.PasswordValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompletePasswordValidator
implements PasswordValidator {
    private static Logger log = LoggerFactory.getLogger(CompletePasswordValidator.class);

    @Override
    public void Validate(String password) throws ValidatorException {
        this.validateLength(password);
        this.checkLowerCase(password);
        this.checkUpperCase(password);
        this.checkDigits(password);
        this.checkSpecial(password);
    }

    private void validateLength(String password) throws ValidatorException {
        if (Config.VALIDATOR_PASSWORD_MIN_LENGTH > 0 && password.length() < Config.VALIDATOR_PASSWORD_MIN_LENGTH) {
            throw new ValidatorException(Config.VALIDATOR_PASSWORD_ERROR_MIN_LENGTH);
        }
        if (Config.VALIDATOR_PASSWORD_MAX_LENGTH > 0 && password.length() > Config.VALIDATOR_PASSWORD_MAX_LENGTH) {
            throw new ValidatorException(Config.VALIDATOR_PASSWORD_ERROR_MAX_LENGTH);
        }
    }

    private void checkLowerCase(String password) throws ValidatorException {
        int count = 0;
        if (Config.VALIDATOR_PASSWORD_MIN_LOWERCASE > 0) {
            for (int i = 0; i < password.length(); ++i) {
                if (!Character.isLowerCase(password.charAt(i))) continue;
                ++count;
            }
            if (Config.VALIDATOR_PASSWORD_MIN_LOWERCASE > count) {
                throw new ValidatorException(Config.VALIDATOR_PASSWORD_ERROR_MIN_LOWERCASE);
            }
        }
    }

    private void checkUpperCase(String password) throws ValidatorException {
        int count = 0;
        if (Config.VALIDATOR_PASSWORD_MIN_UPPERCASE > 0) {
            for (int i = 0; i < password.length(); ++i) {
                if (!Character.isUpperCase(password.charAt(i))) continue;
                ++count;
            }
            if (Config.VALIDATOR_PASSWORD_MIN_UPPERCASE > count) {
                throw new ValidatorException(Config.VALIDATOR_PASSWORD_ERROR_MIN_UPPERCASE);
            }
        }
    }

    private void checkDigits(String password) throws ValidatorException {
        int count = 0;
        if (Config.VALIDATOR_PASSWORD_MIN_DIGITS > 0) {
            for (int i = 0; i < password.length(); ++i) {
                if (!Character.isDigit(password.charAt(i))) continue;
                ++count;
            }
            if (Config.VALIDATOR_PASSWORD_MIN_DIGITS > count) {
                throw new ValidatorException(Config.VALIDATOR_PASSWORD_ERROR_MIN_DIGITS);
            }
        }
    }

    private void checkSpecial(String password) throws ValidatorException {
        int count = 0;
        if (Config.VALIDATOR_PASSWORD_MIN_SPECIAL > 0) {
            for (int i = 0; i < password.length(); ++i) {
                if (Character.isLetterOrDigit(password.charAt(i)) || Character.isWhitespace(password.charAt(i))) continue;
                ++count;
            }
            if (Config.VALIDATOR_PASSWORD_MIN_SPECIAL > count) {
                throw new ValidatorException(Config.VALIDATOR_PASSWORD_ERROR_MIN_SPECIAL);
            }
        }
    }
}

