/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.webdav;

import com.openkm.cache.UserItemsManager;
import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.dao.MimeTypeDAO;
import com.openkm.extractor.RegisteredExtractors;
import com.openkm.jcr.JCRUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.Version;
import org.apache.jackrabbit.server.io.ExportContext;
import org.apache.jackrabbit.server.io.IOHandler;
import org.apache.jackrabbit.server.io.IOManager;
import org.apache.jackrabbit.server.io.IOUtil;
import org.apache.jackrabbit.server.io.ImportContext;
import org.apache.jackrabbit.server.io.PropertyExportContext;
import org.apache.jackrabbit.server.io.PropertyHandler;
import org.apache.jackrabbit.server.io.PropertyImportContext;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHandler
implements IOHandler,
PropertyHandler {
    private static Logger log = LoggerFactory.getLogger(DefaultHandler.class);
    private String collectionNodetype = "okm:folder";
    private String defaultNodetype = "okm:document";
    private String contentNodetype = "okm:resource";
    private IOManager ioManager;

    public DefaultHandler() {
        log.debug("DefaultHandler()");
    }

    public DefaultHandler(IOManager ioManager) {
        log.debug("DefaultHandler({})", (Object)ioManager);
        this.ioManager = ioManager;
    }

    public DefaultHandler(IOManager ioManager, String collectionNodetype, String defaultNodetype, String contentNodetype) {
        log.debug("DefaultHandler({}, {}, {}, {})", new Object[]{ioManager, collectionNodetype, defaultNodetype, contentNodetype});
        this.ioManager = ioManager;
        this.collectionNodetype = collectionNodetype;
        this.defaultNodetype = defaultNodetype;
        this.contentNodetype = contentNodetype;
    }

    public IOManager getIOManager() {
        return this.ioManager;
    }

    public void setIOManager(IOManager ioManager) {
        this.ioManager = ioManager;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public boolean canImport(ImportContext context, boolean isCollection) {
        log.debug("canImport({}, {})", (Object)context, (Object)isCollection);
        if (context == null || context.isCompleted()) {
            return false;
        }
        Item contextItem = context.getImportRoot();
        if (!isCollection) {
            String mimeType = Config.mimeTypes.getContentType(context.getSystemId().toLowerCase());
            log.debug("File: {}", (Object)context.getSystemId());
            log.debug("MimeType: {}", (Object)mimeType);
            log.debug("Size: {}", (Object)context.getContentLength());
            try {
                if (Config.RESTRICT_FILE_MIME && MimeTypeDAO.findByName(mimeType) == null) {
                    return false;
                }
            }
            catch (DatabaseException e) {
                log.error(e.getMessage(), (Throwable)e);
                return false;
            }
            StringTokenizer st = new StringTokenizer(Config.RESTRICT_FILE_EXTENSION, ",");
            while (st.hasMoreTokens()) {
                String wc = st.nextToken();
                String re = this.wildcard2regexp(wc);
                if (Pattern.matches(re, context.getSystemId())) {
                    log.debug("Filename BAD -> {} ({})", (Object)re, (Object)wc);
                    return false;
                }
                log.debug("Filename GOOD -> {} ({})", (Object)re, (Object)wc);
            }
            if (context.getContentLength() > Config.MAX_FILE_SIZE) {
                return false;
            }
        }
        return contextItem != null && contextItem.isNode() && context.getSystemId() != null;
    }

    private String wildcard2regexp(String wildcard) {
        StringBuffer sb = new StringBuffer("^");
        block5: for (int i = 0; i < wildcard.length(); ++i) {
            char c = wildcard.charAt(i);
            switch (c) {
                case '.': {
                    sb.append("\\.");
                    continue block5;
                }
                case '*': {
                    sb.append(".*");
                    continue block5;
                }
                case '?': {
                    sb.append(".");
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public boolean canImport(ImportContext context, DavResource resource) {
        if (resource == null) {
            return false;
        }
        return this.canImport(context, resource.isCollection());
    }

    public boolean importContent(ImportContext context, boolean isCollection) throws IOException {
        log.debug("importContent({}, {})", (Object)context, (Object)isCollection);
        if (!this.canImport(context, isCollection)) {
            throw new IOException(this.getName() + ": Cannot import " + context.getSystemId());
        }
        boolean success = false;
        try {
            Node contentNode = this.getContentNode(context, isCollection);
            log.info("contentNode: {}", (Object)contentNode.getPath());
            if (contentNode.isNodeType("mix:versionable")) {
                log.debug("CHECKOUT");
                contentNode.checkout();
            }
            if (success = this.importProperties(context, isCollection, contentNode)) {
                success = this.importData(context, isCollection, contentNode);
            }
            if (contentNode.isNodeType("okm:resource")) {
                contentNode.getParent().getParent().save();
            }
            if (contentNode.isNodeType("mix:versionable")) {
                log.debug("CHECKIN");
                Version ver = contentNode.checkin();
                if (Config.USER_ITEM_CACHE) {
                    String user = contentNode.getSession().getUserID();
                    long size = contentNode.getProperty("okm:size").getLong();
                    UserItemsManager.incSize(user, size);
                    if (ver.getName().equals("1.0")) {
                        UserItemsManager.incDocuments(user, 1);
                    }
                }
            }
            Node documentNode = contentNode.getParent();
            log.info("Delete: {}", (Object)(Config.CACHE_DXF + File.separator + documentNode.getUUID() + ".dxf"));
            new File(Config.CACHE_DXF + File.separator + documentNode.getUUID() + ".dxf").delete();
            log.info("Delete: {}", (Object)(Config.CACHE_PDF + File.separator + documentNode.getUUID() + ".pdf"));
            new File(Config.CACHE_PDF + File.separator + documentNode.getUUID() + ".pdf").delete();
            log.info("Delete: {}", (Object)(Config.CACHE_SWF + File.separator + documentNode.getUUID() + ".swf"));
            new File(Config.CACHE_SWF + File.separator + documentNode.getUUID() + ".swf").delete();
        }
        catch (RepositoryException e) {
            success = false;
            throw new IOException(e.getMessage());
        }
        finally {
            if (!success) {
                try {
                    context.getImportRoot().refresh(false);
                }
                catch (RepositoryException e) {
                    throw new IOException(e.getMessage());
                }
            }
        }
        return success;
    }

    public boolean importContent(ImportContext context, DavResource resource) throws IOException {
        log.debug("importContent({}, {})", (Object)context, (Object)resource);
        if (!this.canImport(context, resource)) {
            throw new IOException(this.getName() + ": Cannot import " + context.getSystemId());
        }
        return this.importContent(context, resource.isCollection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean importData(ImportContext context, boolean isCollection, Node contentNode) throws IOException, RepositoryException {
        log.debug("importData({}, {}, {})", new Object[]{context, isCollection, contentNode});
        InputStream is = context.getInputStream();
        if (is != null) {
            if (isCollection) {
                return false;
            }
            try {
                contentNode.setProperty("jcr:data", is);
                if (Config.EXPERIMENTAL_TEXT_EXTRACTION) {
                    String mimeType = contentNode.getProperty("jcr:mimeType").getString();
                    RegisteredExtractors.index(contentNode.getParent(), contentNode, mimeType);
                }
            }
            finally {
                is.close();
            }
        }
        return true;
    }

    protected boolean importProperties(ImportContext context, boolean isCollection, Node contentNode) {
        log.debug("importProperties({}, {}, {})", new Object[]{context, isCollection, contentNode});
        String mimeType = null;
        try {
            if (!contentNode.hasProperty("jcr:mimeType")) {
                mimeType = Config.mimeTypes.getContentType(context.getSystemId().toLowerCase());
                contentNode.setProperty("jcr:mimeType", mimeType);
            }
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        try {
            if (!contentNode.hasProperty("jcr:encoding")) {
                contentNode.setProperty("jcr:encoding", context.getEncoding());
            }
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        this.setLastModified(contentNode, context.getModificationTime());
        try {
            Session session = contentNode.getSession();
            Node parentNode = null;
            Node mainNode = null;
            if (contentNode.isNodeType("okm:folder")) {
                log.debug("Folder node type");
                Node folderNode = contentNode;
                parentNode = folderNode.getParent();
                folderNode.setProperty("okm:author", session.getUserID());
                folderNode.setProperty("okm:name", folderNode.getName());
                mainNode = folderNode;
            } else if (contentNode.isNodeType("okm:resource")) {
                log.debug("Document node type");
                Node documentNode = contentNode.getParent();
                parentNode = documentNode.getParent();
                documentNode.setProperty("okm:keywords", new String[0]);
                documentNode.setProperty("okm:categories", new String[0], 9);
                documentNode.setProperty("okm:author", session.getUserID());
                documentNode.setProperty("okm:name", documentNode.getName());
                contentNode.setProperty("okm:size", context.getContentLength());
                contentNode.setProperty("okm:author", session.getUserID());
                contentNode.setProperty("okm:versionComment", "Edited using WebDAV");
                mainNode = documentNode;
            }
            Value[] usersReadParent = parentNode.getProperty("okm:authUsersRead").getValues();
            String[] usersRead = JCRUtils.usrValue2String(usersReadParent, session.getUserID());
            Value[] usersWriteParent = parentNode.getProperty("okm:authUsersWrite").getValues();
            String[] usersWrite = JCRUtils.usrValue2String(usersWriteParent, session.getUserID());
            Value[] usersDeleteParent = parentNode.getProperty("okm:authUsersDelete").getValues();
            String[] usersDelete = JCRUtils.usrValue2String(usersDeleteParent, session.getUserID());
            Value[] usersSecurityParent = parentNode.getProperty("okm:authUsersSecurity").getValues();
            String[] usersSecurity = JCRUtils.usrValue2String(usersSecurityParent, session.getUserID());
            Value[] rolesReadParent = parentNode.getProperty("okm:authRolesRead").getValues();
            String[] rolesRead = JCRUtils.rolValue2String(rolesReadParent);
            Value[] rolesWriteParent = parentNode.getProperty("okm:authRolesWrite").getValues();
            String[] rolesWrite = JCRUtils.rolValue2String(rolesWriteParent);
            Value[] rolesDeleteParent = parentNode.getProperty("okm:authRolesDelete").getValues();
            String[] rolesDelete = JCRUtils.rolValue2String(rolesDeleteParent);
            Value[] rolesSecurityParent = parentNode.getProperty("okm:authRolesSecurity").getValues();
            String[] rolesSecurity = JCRUtils.rolValue2String(rolesSecurityParent);
            mainNode.setProperty("okm:authUsersRead", usersRead);
            mainNode.setProperty("okm:authUsersWrite", usersWrite);
            mainNode.setProperty("okm:authUsersDelete", usersDelete);
            mainNode.setProperty("okm:authUsersSecurity", usersSecurity);
            mainNode.setProperty("okm:authRolesRead", rolesRead);
            mainNode.setProperty("okm:authRolesWrite", rolesWrite);
            mainNode.setProperty("okm:authRolesDelete", rolesDelete);
            mainNode.setProperty("okm:authRolesSecurity", rolesSecurity);
        }
        catch (ItemNotFoundException e) {
            e.printStackTrace();
        }
        catch (AccessDeniedException e) {
            e.printStackTrace();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        return true;
    }

    protected Node getContentNode(ImportContext context, boolean isCollection) throws RepositoryException {
        log.debug("getContentNode({}, {})", (Object)context, (Object)isCollection);
        Node parentNode = (Node)context.getImportRoot();
        String name = context.getSystemId();
        if (parentNode.hasNode(name)) {
            parentNode = parentNode.getNode(name);
        } else {
            String ntName = isCollection ? this.getCollectionNodeType() : this.getNodeType();
            parentNode = parentNode.addNode(name, ntName);
        }
        Node contentNode = null;
        if (isCollection) {
            contentNode = parentNode;
        } else {
            if (parentNode.hasNode("okm:content")) {
                contentNode = parentNode.getNode("okm:content");
                if (contentNode.isNodeType(this.getContentNodeType())) {
                    if (contentNode.hasNodes()) {
                        NodeIterator it = contentNode.getNodes();
                        while (it.hasNext()) {
                            it.nextNode().remove();
                        }
                    }
                } else {
                    contentNode.remove();
                    contentNode = null;
                }
            }
            if (contentNode == null) {
                contentNode = parentNode.addNode("okm:content", this.getContentNodeType());
            }
        }
        return contentNode;
    }

    public boolean canExport(ExportContext context, boolean isCollection) {
        boolean success;
        log.debug("canExport(ExportContext:{}, {})", (Object)context, (Object)isCollection);
        if (context == null || context.isCompleted()) {
            return false;
        }
        Item exportRoot = context.getExportRoot();
        boolean bl = success = exportRoot != null && exportRoot.isNode();
        if (success && !isCollection) {
            try {
                Node n = (Node)exportRoot;
                log.debug("Path: {}", (Object)n.getPath());
                success = n.hasNode("okm:content");
            }
            catch (RepositoryException e) {
                success = false;
            }
        }
        return success;
    }

    public boolean canExport(ExportContext context, DavResource resource) {
        log.debug("canExport(ExportContext:{}, DavResource:{})", (Object)context, (Object)resource);
        if (resource == null) {
            return false;
        }
        return this.canExport(context, resource.isCollection());
    }

    public boolean exportContent(ExportContext context, boolean isCollection) throws IOException {
        log.debug("exportContent({}, {})", (Object)context, (Object)isCollection);
        if (!this.canExport(context, isCollection)) {
            throw new IOException(this.getName() + ": Cannot export " + context.getExportRoot());
        }
        try {
            Node contentNode = this.getContentNode(context, isCollection);
            this.exportProperties(context, isCollection, contentNode);
            if (context.hasStream()) {
                this.exportData(context, isCollection, contentNode);
            }
            return true;
        }
        catch (RepositoryException e) {
            throw new IOException(e.getMessage());
        }
    }

    public boolean exportContent(ExportContext context, DavResource resource) throws IOException {
        log.debug("exportContent({}, {})", (Object)context, (Object)resource);
        if (!this.canExport(context, resource)) {
            throw new IOException(this.getName() + ": Cannot export " + context.getExportRoot());
        }
        return this.exportContent(context, resource.isCollection());
    }

    protected void exportData(ExportContext context, boolean isCollection, Node contentNode) throws IOException, RepositoryException {
        log.debug("exportData({}, {}, {})", new Object[]{context, isCollection, contentNode});
        if (contentNode.hasProperty("jcr:data")) {
            Property p = contentNode.getProperty("jcr:data");
            IOUtil.spool((InputStream)p.getStream(), (OutputStream)context.getOutputStream());
        }
    }

    protected void exportProperties(ExportContext context, boolean isCollection, Node contentNode) throws IOException {
        log.debug("exportProperties({}, {}, {})", new Object[]{context, isCollection, contentNode});
        try {
            if (!isCollection && contentNode.getDepth() > 0 && contentNode.getParent().hasProperty("jcr:created")) {
                long cTime = contentNode.getParent().getProperty("jcr:created").getValue().getLong();
                context.setCreationTime(cTime);
            }
            long length = -1L;
            if (contentNode.hasProperty("jcr:data")) {
                Property p = contentNode.getProperty("jcr:data");
                length = p.getLength();
                context.setContentLength(length);
            }
            String mimeType = null;
            String encoding = null;
            if (contentNode.hasProperty("jcr:mimeType")) {
                mimeType = contentNode.getProperty("jcr:mimeType").getString();
            }
            if (contentNode.hasProperty("jcr:encoding") && "".equals(encoding = contentNode.getProperty("jcr:encoding").getString())) {
                encoding = null;
            }
            context.setContentType(mimeType, encoding);
            long modTime = -1L;
            if (contentNode.hasProperty("jcr:lastModified")) {
                modTime = contentNode.getProperty("jcr:lastModified").getLong();
                context.setModificationTime(modTime);
            } else {
                context.setModificationTime(System.currentTimeMillis());
            }
            if (length > -1L && modTime > -1L) {
                String etag = "\"" + length + "-" + modTime + "\"";
                context.setETag(etag);
            }
        }
        catch (RepositoryException e) {
            log.error("Unexpected error {} while exporting properties: {}", (Object)((Object)((Object)e)).getClass().getName(), (Object)e.getMessage());
            throw new IOException(e.getMessage());
        }
    }

    protected Node getContentNode(ExportContext context, boolean isCollection) throws RepositoryException {
        log.debug("getContentNode({}, {})", (Object)context, (Object)isCollection);
        Node contentNode = (Node)context.getExportRoot();
        if (!isCollection) {
            contentNode = contentNode.getNode("okm:content");
        }
        return contentNode;
    }

    protected String getCollectionNodeType() {
        return this.collectionNodetype;
    }

    protected String getNodeType() {
        return this.defaultNodetype;
    }

    protected String getContentNodeType() {
        return this.contentNodetype;
    }

    public boolean canExport(PropertyExportContext context, boolean isCollection) {
        log.debug("canExport(PropertyExportContext:{}, {})", (Object)context, (Object)isCollection);
        return this.canExport((ExportContext)context, isCollection);
    }

    public boolean exportProperties(PropertyExportContext exportContext, boolean isCollection) throws RepositoryException {
        log.debug("exportProperties({}, {}", (Object)exportContext, (Object)isCollection);
        if (!this.canExport(exportContext, isCollection)) {
            throw new RepositoryException("PropertyHandler " + this.getName() + " failed to export properties.");
        }
        Node cn = this.getContentNode((ExportContext)exportContext, isCollection);
        try {
            this.exportProperties((ExportContext)exportContext, isCollection, cn);
            PropertyIterator it = cn.getProperties();
            while (it.hasNext()) {
                Property p = it.nextProperty();
                String name = p.getName();
                PropertyDefinition def = p.getDefinition();
                if (def.isMultiple() || DefaultHandler.isDefinedByFilteredNodeType(def)) {
                    log.debug("Skip property '{}': not added to webdav property set.", (Object)name);
                    continue;
                }
                if ("jcr:data".equals(name) || "jcr:mimeType".equals(name) || "jcr:encoding".equals(name) || "jcr:lastModified".equals(name)) continue;
                DavPropertyName davName = this.getDavName(name, p.getSession());
                exportContext.setProperty((Object)davName, (Object)p.getValue().getString());
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean canImport(PropertyImportContext context, boolean isCollection) {
        log.debug("canImport({}, {})", (Object)context, (Object)isCollection);
        if (context == null || context.isCompleted()) {
            return false;
        }
        Item contextItem = context.getImportRoot();
        try {
            return contextItem != null && contextItem.isNode() && (isCollection || ((Node)contextItem).hasNode("jcr:content"));
        }
        catch (RepositoryException e) {
            log.error("Unexpected error: {}", (Object)e.getMessage());
            return false;
        }
    }

    public Map importProperties(PropertyImportContext importContext, boolean isCollection) throws RepositoryException {
        log.debug("importProperties({}, {})", (Object)importContext, (Object)isCollection);
        if (!this.canImport(importContext, isCollection)) {
            throw new RepositoryException("PropertyHandler " + this.getName() + " failed import properties");
        }
        HashMap failures = new HashMap();
        List changeList = importContext.getChangeList();
        Node cn = (Node)importContext.getImportRoot();
        if (!isCollection && cn.hasNode("jcr:content")) {
            cn = cn.getNode("jcr:content");
        }
        if (changeList != null) {
            for (Object propEntry : changeList) {
                try {
                    if (propEntry instanceof DavPropertyName) {
                        DavPropertyName propName = (DavPropertyName)propEntry;
                        this.removeJcrProperty(propName, cn);
                        continue;
                    }
                    if (propEntry instanceof DavProperty) {
                        DavProperty prop = (DavProperty)propEntry;
                        this.setJcrProperty(prop, cn);
                        continue;
                    }
                    log.error("unknown object in change list: " + propEntry.getClass().getName());
                }
                catch (RepositoryException e) {
                    failures.put(propEntry, e);
                }
            }
        }
        if (failures.isEmpty()) {
            this.setLastModified(cn, -1L);
        }
        return failures;
    }

    private DavPropertyName getDavName(String jcrName, Session session) throws RepositoryException {
        String localName = ISO9075.encode((String)Text.getLocalName((String)jcrName));
        String prefix = Text.getNamespacePrefix((String)jcrName);
        String uri = session.getNamespaceURI(prefix);
        Namespace namespace = Namespace.getNamespace((String)prefix, (String)uri);
        DavPropertyName name = DavPropertyName.create((String)localName, (Namespace)namespace);
        return name;
    }

    private String getJcrName(DavPropertyName propName, Session session) throws RepositoryException {
        String pName = ISO9075.decode((String)propName.getName());
        Namespace propNamespace = propName.getNamespace();
        if (!Namespace.EMPTY_NAMESPACE.equals((Object)propNamespace)) {
            String prefix;
            String emptyPrefix = Namespace.EMPTY_NAMESPACE.getPrefix();
            try {
                prefix = session.getNamespacePrefix(propNamespace.getURI());
            }
            catch (NamespaceException e) {
                NamespaceRegistry nsReg = session.getWorkspace().getNamespaceRegistry();
                prefix = propNamespace.getPrefix();
                if (emptyPrefix.equals(prefix)) {
                    prefix = "_pre" + nsReg.getPrefixes().length + 1;
                }
                nsReg.registerNamespace(prefix, propNamespace.getURI());
            }
            if (prefix != null && !emptyPrefix.equals(prefix)) {
                pName = prefix + ":" + pName;
            }
        }
        return pName;
    }

    private void setJcrProperty(DavProperty property, Node contentNode) throws RepositoryException {
        DavPropertyName davName;
        String value = "";
        if (property.getValue() != null) {
            value = property.getValue().toString();
        }
        if (DavPropertyName.GETCONTENTTYPE.equals((Object)(davName = property.getName()))) {
            String mimeType = IOUtil.getMimeType((String)value);
            String encoding = IOUtil.getEncoding((String)value);
            contentNode.setProperty("jcr:mimeType", mimeType);
            contentNode.setProperty("jcr:encoding", encoding);
        } else {
            contentNode.setProperty(this.getJcrName(davName, contentNode.getSession()), value);
        }
    }

    private void removeJcrProperty(DavPropertyName propertyName, Node contentNode) throws RepositoryException {
        if (DavPropertyName.GETCONTENTTYPE.equals((Object)propertyName)) {
            if (contentNode.hasProperty("jcr:mimeType")) {
                contentNode.getProperty("jcr:mimeType").remove();
            }
            if (contentNode.hasProperty("jcr:encoding")) {
                contentNode.getProperty("jcr:encoding").remove();
            }
        } else {
            String jcrName = this.getJcrName(propertyName, contentNode.getSession());
            if (contentNode.hasProperty(jcrName)) {
                contentNode.getProperty(jcrName).remove();
            }
        }
    }

    private void setLastModified(Node contentNode, long hint) {
        try {
            Calendar lastMod = Calendar.getInstance();
            if (hint > -1L) {
                lastMod.setTimeInMillis(hint);
            } else {
                lastMod.setTime(new Date());
            }
            contentNode.setProperty("jcr:lastModified", lastMod);
        }
        catch (RepositoryException e) {
            // empty catch block
        }
    }

    private static boolean isDefinedByFilteredNodeType(PropertyDefinition def) {
        String ntName = def.getDeclaringNodeType().getName();
        return ntName.equals("nt:base") || ntName.equals("mix:referenceable") || ntName.equals("mix:versionable") || ntName.equals("mix:lockable");
    }
}

