/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.webdav;

import com.openkm.core.Config;
import org.apache.jackrabbit.webdav.AbstractLocatorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocatorFactoryImplEx
extends AbstractLocatorFactory {
    private static Logger log = LoggerFactory.getLogger(LocatorFactoryImplEx.class);

    public LocatorFactoryImplEx(String pathPrefix) {
        super(pathPrefix);
    }

    protected String getRepositoryPath(String resourcePath, String wspPath) {
        log.debug("getRepositoryPath({}, {})", (Object)resourcePath, (Object)wspPath);
        if (resourcePath == null) {
            return resourcePath;
        }
        if (resourcePath.equals(wspPath) || this.startsWithWorkspace(resourcePath, wspPath)) {
            String repositoryPath = resourcePath.substring(wspPath.length());
            if (Config.SYSTEM_WEBDAV_FIX) {
                repositoryPath = repositoryPath.replace("okm_", "okm:");
            }
            String ret = repositoryPath.length() == 0 ? "/" : repositoryPath;
            log.debug("getRepositoryPath: {}", (Object)ret);
            return ret;
        }
        throw new IllegalArgumentException("Unexpected format of resource path.");
    }

    protected String getResourcePath(String repositoryPath, String wspPath) {
        log.debug("getResourcePath({}, {})", (Object)repositoryPath, (Object)wspPath);
        if (repositoryPath == null) {
            throw new IllegalArgumentException("Cannot build resource path from 'null' repository path");
        }
        if (Config.SYSTEM_WEBDAV_FIX) {
            repositoryPath = repositoryPath.replace("okm:", "okm_");
        }
        String ret = this.startsWithWorkspace(repositoryPath, wspPath) ? repositoryPath : wspPath + repositoryPath;
        log.debug("getResourcePath: {}", (Object)ret);
        return ret;
    }

    private boolean startsWithWorkspace(String repositoryPath, String wspPath) {
        if (wspPath == null) {
            return true;
        }
        return repositoryPath.startsWith(wspPath + "/");
    }
}

