/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.webdav;

import com.openkm.core.Config;
import com.openkm.core.JcrSessionManager;
import com.openkm.jcr.JCRUtils;
import com.openkm.servlet.BasicSecuredServlet;
import com.openkm.webdav.JcrSessionTokenHolder;
import com.openkm.webdav.WebDavService;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.UUID;
import javax.jcr.LoginException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebDAVFilter
implements Filter {
    public void init(FilterConfig fConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (Config.SYSTEM_WEBDAV_SERVER) {
            response.setContentType(Config.MIME_HTML);
            this.handleRequest(request, response);
        } else {
            response.setContentType(Config.MIME_TEXT);
            PrintWriter out = response.getWriter();
            out.println("WebDAV is disabled. Contact with your administrator.");
            out.flush();
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequest(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        Session session = null;
        try {
            session = new BasicSecuredServlet().getSession((HttpServletRequest)request);
            String uid = UUID.randomUUID().toString();
            JcrSessionManager.getInstance().add(uid, session);
            JcrSessionTokenHolder.set(uid);
            WebDavService.get().handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        }
        catch (LoginException e) {
            ((HttpServletResponse)response).setHeader("WWW-Authenticate", "Basic realm=\"OpenKM WebDAV Server\"");
            ((HttpServletResponse)response).sendError(401, e.getMessage());
        }
        catch (RepositoryException e) {
            ((HttpServletResponse)response).sendError(500, e.getMessage());
        }
        finally {
            response.getOutputStream().flush();
            response.flushBuffer();
            if (session != null) {
                JcrSessionManager.getInstance().remove(JcrSessionTokenHolder.get());
                JCRUtils.logout(session);
            }
        }
    }
}

