/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.webdav;

import com.bradmcevoy.http.Auth;
import com.bradmcevoy.http.AuthenticationService;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.ResourceFactory;
import com.bradmcevoy.http.Response;
import com.bradmcevoy.http.ServletHttpManager;
import com.bradmcevoy.http.ServletRequest;
import com.bradmcevoy.http.ServletResponse;
import com.bradmcevoy.http.webdav.WebDavResponseHandler;
import com.openkm.webdav.resource.ResourceFactoryFactoryImpl;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class WebDavService {
    private static final WebDavService INSTANCE = new WebDavService();
    protected ServletHttpManager httpManager;

    public static WebDavService get() {
        return INSTANCE;
    }

    private WebDavService() {
        this.init();
    }

    public void init() {
        try {
            this.initFromFactoryFactory();
        }
        catch (ServletException e) {
            e.printStackTrace();
        }
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletRequest miltonRequest = new ServletRequest(request);
        ServletResponse miltonResponse = new ServletResponse(response);
        this.httpManager.process((Request)miltonRequest, (Response)miltonResponse);
    }

    public void handleNTLMRequest(String okmUser, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletRequest miltonRequest = new ServletRequest(request);
        Auth auth = new Auth(Auth.Scheme.NTLM, okmUser, null);
        miltonRequest.setAuthorization(auth);
        ServletResponse miltonResponse = new ServletResponse(response);
        this.httpManager.process((Request)miltonRequest, (Response)miltonResponse);
    }

    protected void initFromFactoryFactory() throws ServletException {
        ResourceFactoryFactoryImpl rff = new ResourceFactoryFactoryImpl();
        rff.init();
        ResourceFactory rf = rff.createResourceFactory();
        WebDavResponseHandler responseHandler = rff.createResponseHandler();
        this.httpManager = new ServletHttpManager(rf, responseHandler, new AuthenticationService());
        this.httpManager.setEnableExpectContinue(false);
    }
}

