/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.webdav.resource;

import com.bradmcevoy.http.Auth;
import com.bradmcevoy.http.CollectionResource;
import com.bradmcevoy.http.CopyableResource;
import com.bradmcevoy.http.DeletableResource;
import com.bradmcevoy.http.GetableResource;
import com.bradmcevoy.http.LockInfo;
import com.bradmcevoy.http.LockResult;
import com.bradmcevoy.http.LockTimeout;
import com.bradmcevoy.http.LockToken;
import com.bradmcevoy.http.LockableResource;
import com.bradmcevoy.http.MoveableResource;
import com.bradmcevoy.http.PropFindableResource;
import com.bradmcevoy.http.PropPatchableResource;
import com.bradmcevoy.http.QuotaResource;
import com.bradmcevoy.http.Range;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.exceptions.BadRequestException;
import com.bradmcevoy.http.exceptions.ConflictException;
import com.bradmcevoy.http.exceptions.LockedException;
import com.bradmcevoy.http.exceptions.NotAuthorizedException;
import com.bradmcevoy.http.exceptions.PreConditionFailedException;
import com.bradmcevoy.http.webdav.PropPatchHandler;
import com.openkm.api.OKMDocument;
import com.openkm.api.OKMFolder;
import com.openkm.bean.Document;
import com.openkm.bean.Lock;
import com.openkm.core.AccessDeniedException;
import com.openkm.core.DatabaseException;
import com.openkm.core.LockException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.jcr.JCRUtils;
import com.openkm.webdav.JcrSessionTokenHolder;
import com.openkm.webdav.resource.FolderResource;
import com.openkm.webdav.resource.ResourceUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentResource
implements CopyableResource,
DeletableResource,
GetableResource,
MoveableResource,
PropFindableResource,
PropPatchableResource,
LockableResource,
QuotaResource {
    private static final Logger log = LoggerFactory.getLogger(DocumentResource.class);
    private Document doc;
    private LockToken lt;

    public DocumentResource(Document doc) {
        this.doc = ResourceUtils.fixResourcePath(doc);
        if (doc != null && doc.getLockInfo() != null) {
            this.createLockToken(doc.getLockInfo());
        }
    }

    public String getUniqueId() {
        return this.doc.getUuid();
    }

    public String getName() {
        return JCRUtils.getName(this.doc.getPath());
    }

    public Object authenticate(String user, String password) {
        return "OpenKM";
    }

    public boolean authorise(Request request, Request.Method method, Auth auth) {
        return true;
    }

    public String getRealm() {
        return "OpenKM";
    }

    public Date getCreateDate() {
        return this.doc.getCreated().getTime();
    }

    public Date getModifiedDate() {
        return this.doc.getLastModified().getTime();
    }

    public String checkRedirect(Request request) {
        return null;
    }

    public Long getMaxAgeSeconds(Auth auth) {
        return null;
    }

    public String getContentType(String accepts) {
        return this.doc.getMimeType();
    }

    public Long getContentLength() {
        return this.doc.getActualVersion().getSize();
    }

    /*
     * Exception decompiling
     */
    public void sendContent(OutputStream out, Range range, Map<String, String> params, String contentType) throws IOException, NotAuthorizedException, BadRequestException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void delete() throws NotAuthorizedException, ConflictException, BadRequestException {
        log.debug("delete()");
        try {
            String token = JcrSessionTokenHolder.get();
            String fixedDocPath = ResourceUtils.fixRepositoryPath(this.doc.getPath());
            OKMDocument.getInstance().delete(token, fixedDocPath);
        }
        catch (Exception e) {
            throw new ConflictException((Resource)this);
        }
    }

    public void setProperties(PropPatchHandler.Fields fields) {
    }

    public void moveTo(CollectionResource newParent, String newName) throws ConflictException, NotAuthorizedException, BadRequestException {
        log.debug("moveTo({}, {})", (Object)newParent, (Object)newName);
        if (newParent instanceof FolderResource) {
            FolderResource newFldParent = (FolderResource)newParent;
            String dstParentPath = newFldParent.getFolder().getPath();
            String dstPath = dstParentPath + "/" + newName;
            String fixedDstParentPath = ResourceUtils.fixRepositoryPath(dstParentPath);
            String fixedDstPath = ResourceUtils.fixRepositoryPath(dstPath);
            try {
                String token = JcrSessionTokenHolder.get();
                String fixedDocPath = ResourceUtils.fixRepositoryPath(this.doc.getPath());
                String fixedDocParentPath = JCRUtils.getParent(fixedDocPath);
                if (fixedDocParentPath.compareTo(fixedDstParentPath) == 0) {
                    this.doc = OKMDocument.getInstance().rename(token, fixedDocPath, newName);
                }
                OKMFolder.getInstance().move(token, fixedDocPath, fixedDstParentPath);
                this.doc = OKMDocument.getInstance().getProperties(token, fixedDstPath);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to move to: " + dstPath);
            }
        } else {
            throw new RuntimeException("Destination is an unknown type. Must be a FsDirectoryResource, is a: " + newParent.getClass());
        }
    }

    public void copyTo(CollectionResource newParent, String newName) throws NotAuthorizedException, BadRequestException, ConflictException {
        log.debug("copyTo({}, {})", (Object)newParent, (Object)newName);
        if (newParent instanceof FolderResource) {
            FolderResource newFldParent = (FolderResource)newParent;
            String dstPath = newFldParent.getFolder().getPath() + "/" + newName;
            try {
                String token = JcrSessionTokenHolder.get();
                String fixedDocPath = ResourceUtils.fixRepositoryPath(this.doc.getPath());
                OKMDocument.getInstance().copy(token, fixedDocPath, dstPath);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to copy to:" + dstPath, e);
            }
        } else {
            throw new RuntimeException("Destination is an unknown type. Must be a FolderResource, is a: " + newParent.getClass());
        }
    }

    public LockResult lock(LockTimeout timeout, LockInfo lockInfo) throws NotAuthorizedException, PreConditionFailedException, LockedException {
        String fixedDocPath = ResourceUtils.fixRepositoryPath(this.doc.getPath());
        try {
            String token = JcrSessionTokenHolder.get();
            if (OKMDocument.getInstance().isLocked(token, fixedDocPath)) {
                throw new LockedException((Resource)this);
            }
            Lock lock = OKMDocument.getInstance().lock(token, fixedDocPath);
            this.createLockToken(lock);
            return LockResult.success((LockToken)this.lt);
        }
        catch (LockException e) {
            throw new RuntimeException("Failed to lock: " + fixedDocPath);
        }
        catch (PathNotFoundException e) {
            throw new RuntimeException("Failed to lock: " + fixedDocPath);
        }
        catch (AccessDeniedException e) {
            throw new RuntimeException("Failed to lock: " + fixedDocPath);
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Failed to lock: " + fixedDocPath);
        }
        catch (DatabaseException e) {
            throw new RuntimeException("Failed to lock: " + fixedDocPath);
        }
    }

    public LockResult refreshLock(String token) throws NotAuthorizedException, PreConditionFailedException {
        log.debug("refreshing lock: {}", (Object)token);
        if (this.lt == null) {
            throw new RuntimeException("Failed to refresh lock: " + token + " (Lock token not specified)");
        }
        if (!token.equals(this.lt.tokenId)) {
            throw new RuntimeException("Failed to refresh lock: " + token + " (token not equal to current lock: " + this.lt.tokenId + ")");
        }
        log.debug("lock refreshed: {}", (Object)token);
        return LockResult.success((LockToken)this.lt);
    }

    public void unlock(String tokenId) throws NotAuthorizedException, PreConditionFailedException {
        String fixedDocPath = ResourceUtils.fixRepositoryPath(this.doc.getPath());
        try {
            String token = JcrSessionTokenHolder.get();
            OKMDocument.getInstance().unlock(token, fixedDocPath);
        }
        catch (LockException e) {
            throw new PreConditionFailedException((Resource)this);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to lock: " + fixedDocPath);
        }
    }

    public LockToken getCurrentLock() {
        String fixedDocPath = ResourceUtils.fixRepositoryPath(this.doc.getPath());
        try {
            String token = JcrSessionTokenHolder.get();
            if (OKMDocument.getInstance().isLocked(token, fixedDocPath)) {
                Lock lock = OKMDocument.getInstance().getLock(token, fixedDocPath);
                this.createLockToken(lock);
                return this.lt;
            }
            return null;
        }
        catch (LockException e) {
            throw new RuntimeException("Failed to lock: " + fixedDocPath);
        }
        catch (PathNotFoundException e) {
            throw new RuntimeException("Failed to lock: " + fixedDocPath);
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Failed to lock: " + fixedDocPath);
        }
        catch (DatabaseException e) {
            throw new RuntimeException("Failed to lock: " + fixedDocPath);
        }
    }

    public Long getQuotaUsed() {
        return new Long(0L);
    }

    public Long getQuotaAvailable() {
        return Long.MAX_VALUE;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("doc=").append(this.doc);
        sb.append("}");
        return sb.toString();
    }

    private void createLockToken(Lock lock) {
        this.lt = new LockToken();
        this.lt.tokenId = lock.getToken();
        this.lt.info = new LockInfo(LockInfo.LockScope.EXCLUSIVE, LockInfo.LockType.WRITE, lock.getOwner(), LockInfo.LockDepth.INFINITY);
        this.lt.timeout = new LockTimeout(Long.valueOf(Long.MAX_VALUE));
    }
}

