/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.webdav.resource;

import com.bradmcevoy.common.Path;
import com.bradmcevoy.http.Auth;
import com.bradmcevoy.http.CollectionResource;
import com.bradmcevoy.http.CopyableResource;
import com.bradmcevoy.http.DeletableResource;
import com.bradmcevoy.http.GetableResource;
import com.bradmcevoy.http.MakeCollectionableResource;
import com.bradmcevoy.http.MoveableResource;
import com.bradmcevoy.http.PropFindableResource;
import com.bradmcevoy.http.PutableResource;
import com.bradmcevoy.http.QuotaResource;
import com.bradmcevoy.http.Range;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.exceptions.BadRequestException;
import com.bradmcevoy.http.exceptions.ConflictException;
import com.bradmcevoy.http.exceptions.NotAuthorizedException;
import com.openkm.api.OKMDocument;
import com.openkm.api.OKMFolder;
import com.openkm.api.OKMRepository;
import com.openkm.bean.Document;
import com.openkm.bean.Folder;
import com.openkm.bean.Mail;
import com.openkm.core.Config;
import com.openkm.core.PathNotFoundException;
import com.openkm.jcr.JCRUtils;
import com.openkm.webdav.JcrSessionTokenHolder;
import com.openkm.webdav.resource.DocumentResource;
import com.openkm.webdav.resource.MailResource;
import com.openkm.webdav.resource.ResourceUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderResource
implements MakeCollectionableResource,
PutableResource,
CopyableResource,
DeletableResource,
MoveableResource,
PropFindableResource,
GetableResource,
QuotaResource {
    private final Logger log = LoggerFactory.getLogger(FolderResource.class);
    private final List<Document> docChilds;
    private final List<Folder> fldChilds;
    private final List<Mail> mailChilds;
    private Folder fld;
    private final Path path;

    public FolderResource(Folder fld) {
        this.fldChilds = null;
        this.docChilds = null;
        this.mailChilds = null;
        this.path = null;
        this.fld = ResourceUtils.fixResourcePath(fld);
    }

    public FolderResource(Path path, Folder fld, List<Folder> fldChilds, List<Document> docChilds, List<Mail> mailChilds) {
        this.fldChilds = fldChilds;
        this.docChilds = docChilds;
        this.mailChilds = mailChilds;
        this.path = path;
        this.fld = ResourceUtils.fixResourcePath(fld);
    }

    public Folder getFolder() {
        return this.fld;
    }

    public String getUniqueId() {
        return this.fld.getUuid();
    }

    public String getName() {
        return JCRUtils.getName(this.fld.getPath());
    }

    public Object authenticate(String user, String password) {
        return "OpenKM";
    }

    public boolean authorise(Request request, Request.Method method, Auth auth) {
        return true;
    }

    public String getRealm() {
        return "OpenKM";
    }

    public Date getCreateDate() {
        return this.fld.getCreated().getTime();
    }

    public Date getModifiedDate() {
        return this.fld.getCreated().getTime();
    }

    public String checkRedirect(Request request) {
        return null;
    }

    public Resource child(String childName) {
        this.log.debug("child({})", (Object)childName);
        try {
            return ResourceUtils.getNode(this.path, this.fld.getPath() + "/" + childName);
        }
        catch (PathNotFoundException e) {
            this.log.error("PathNotFoundException: " + e.getMessage());
        }
        catch (Exception e) {
            this.log.error("Exception: " + e.getMessage());
        }
        return null;
    }

    public List<? extends Resource> getChildren() {
        this.log.debug("getChildren()");
        ArrayList<Object> resources = new ArrayList<Object>();
        if (this.fldChilds != null) {
            for (Folder fld : this.fldChilds) {
                resources.add(new FolderResource(fld));
            }
        }
        if (this.docChilds != null) {
            for (Document doc : this.docChilds) {
                resources.add(new DocumentResource(doc));
            }
        }
        if (this.mailChilds != null) {
            for (Mail mail : this.mailChilds) {
                resources.add(new MailResource(mail));
            }
        }
        return resources;
    }

    public Resource createNew(String newName, InputStream inputStream, Long length, String contentType) throws IOException, ConflictException, NotAuthorizedException, BadRequestException {
        this.log.info("createNew({}, {}, {})", new Object[]{newName, length, contentType});
        OKMDocument okmDocument = OKMDocument.getInstance();
        Document newDoc = new Document();
        String fixedDocPath = ResourceUtils.fixRepositoryPath(this.fld.getPath());
        newDoc.setPath(fixedDocPath + "/" + newName);
        try {
            String token = JcrSessionTokenHolder.get();
            if (OKMRepository.getInstance().hasNode(token, newDoc.getPath())) {
                boolean isLocked = okmDocument.isLocked(token, newDoc.getPath());
                okmDocument.checkout(token, newDoc.getPath(), !isLocked);
                okmDocument.setContent(token, newDoc.getPath(), inputStream, length);
                okmDocument.checkin(token, newDoc.getPath(), "Modified from WebDAV", !isLocked);
            } else {
                StringTokenizer st = new StringTokenizer(Config.RESTRICT_FILE_EXTENSION, ",");
                while (st.hasMoreTokens()) {
                    String wc = st.nextToken().trim();
                    String re = ResourceUtils.wildcard2regexp(wc);
                    if (!Pattern.matches(re, newName)) continue;
                    this.log.warn("Filename BAD -> {} ({})", (Object)re, (Object)wc);
                    return null;
                }
                newDoc = okmDocument.create(token, newDoc, inputStream);
            }
            return new DocumentResource(newDoc);
        }
        catch (PathNotFoundException e) {
            this.log.warn("PathNotFoundException: " + e.getMessage());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create: " + e.getMessage(), e);
        }
        return null;
    }

    public CollectionResource createCollection(String newName) throws NotAuthorizedException, ConflictException, BadRequestException {
        this.log.debug("createCollection({})", (Object)newName);
        Folder newFld = new Folder();
        String fixedFldPath = ResourceUtils.fixRepositoryPath(this.fld.getPath());
        newFld.setPath(fixedFldPath + "/" + newName);
        try {
            String token = JcrSessionTokenHolder.get();
            newFld = OKMFolder.getInstance().create(token, newFld);
            return new FolderResource(newFld);
        }
        catch (Exception e) {
            throw new ConflictException((Resource)this);
        }
    }

    public void sendContent(OutputStream out, Range range, Map<String, String> params, String contentType) throws IOException, NotAuthorizedException, BadRequestException {
        this.log.debug("sendContent({}, {})", params, (Object)contentType);
        ResourceUtils.createContent(out, this.path, this.fldChilds, this.docChilds, this.mailChilds);
    }

    public Long getMaxAgeSeconds(Auth auth) {
        return null;
    }

    public String getContentType(String accepts) {
        return null;
    }

    public Long getContentLength() {
        return null;
    }

    public void delete() throws NotAuthorizedException, ConflictException, BadRequestException {
        this.log.debug("delete()");
        try {
            String token = JcrSessionTokenHolder.get();
            String fixedFldPath = ResourceUtils.fixRepositoryPath(this.fld.getPath());
            OKMFolder.getInstance().delete(token, fixedFldPath);
        }
        catch (Exception e) {
            throw new ConflictException((Resource)this);
        }
    }

    public void moveTo(CollectionResource newParent, String newName) throws ConflictException, NotAuthorizedException, BadRequestException {
        this.log.debug("moveTo({}, {})", (Object)newParent, (Object)newName);
        if (newParent instanceof FolderResource) {
            FolderResource newFldParent = (FolderResource)newParent;
            String dstParentPath = newFldParent.getFolder().getPath();
            String dstPath = dstParentPath + "/" + newName;
            String fixedDstParentPath = ResourceUtils.fixRepositoryPath(dstParentPath);
            String fixedDstPath = ResourceUtils.fixRepositoryPath(dstPath);
            try {
                String token = JcrSessionTokenHolder.get();
                String fixedFldPath = ResourceUtils.fixRepositoryPath(this.fld.getPath());
                String fixedFldParentPath = JCRUtils.getParent(fixedFldPath);
                if (fixedFldParentPath.compareTo(fixedDstParentPath) == 0) {
                    this.fld = OKMFolder.getInstance().rename(token, fixedFldPath, newName);
                }
                OKMFolder.getInstance().move(token, fixedFldPath, fixedDstParentPath);
                this.fld = OKMFolder.getInstance().getProperties(token, fixedDstPath);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to move to: " + dstPath, e);
            }
        } else {
            throw new RuntimeException("Destination is an unknown type. Must be a FsDirectoryResource, is a: " + newParent.getClass());
        }
    }

    public void copyTo(CollectionResource newParent, String newName) throws NotAuthorizedException, BadRequestException, ConflictException {
        this.log.debug("copyTo({}, {})", (Object)newParent, (Object)newName);
        if (newParent instanceof FolderResource) {
            FolderResource newFldParent = (FolderResource)newParent;
            String dstPath = newFldParent.getFolder().getPath() + "/" + newName;
            try {
                String token = JcrSessionTokenHolder.get();
                String fixedFldPath = ResourceUtils.fixRepositoryPath(this.fld.getPath());
                OKMFolder.getInstance().copy(token, fixedFldPath, dstPath);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to copy to:" + dstPath, e);
            }
        } else {
            throw new RuntimeException("Destination is an unknown type. Must be a FolderResource, is a: " + newParent.getClass());
        }
    }

    public Long getQuotaUsed() {
        return new Long(0L);
    }

    public Long getQuotaAvailable() {
        return Long.MAX_VALUE;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("fld=").append(this.fld);
        sb.append("}");
        return sb.toString();
    }
}

