/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.webdav.resource;

import com.bradmcevoy.http.Auth;
import com.bradmcevoy.http.CollectionResource;
import com.bradmcevoy.http.CopyableResource;
import com.bradmcevoy.http.DeletableResource;
import com.bradmcevoy.http.GetableResource;
import com.bradmcevoy.http.MoveableResource;
import com.bradmcevoy.http.PropFindableResource;
import com.bradmcevoy.http.PropPatchableResource;
import com.bradmcevoy.http.QuotaResource;
import com.bradmcevoy.http.Range;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.exceptions.BadRequestException;
import com.bradmcevoy.http.exceptions.ConflictException;
import com.bradmcevoy.http.exceptions.NotAuthorizedException;
import com.bradmcevoy.http.webdav.PropPatchHandler;
import com.openkm.api.OKMMail;
import com.openkm.bean.Mail;
import com.openkm.core.DatabaseException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.jcr.JCRUtils;
import com.openkm.util.MailUtils;
import com.openkm.webdav.JcrSessionTokenHolder;
import com.openkm.webdav.resource.FolderResource;
import com.openkm.webdav.resource.ResourceUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailResource
implements CopyableResource,
DeletableResource,
GetableResource,
MoveableResource,
PropFindableResource,
PropPatchableResource,
QuotaResource {
    private static final Logger log = LoggerFactory.getLogger(MailResource.class);
    private Mail mail;

    public MailResource(Mail mail) {
        this.mail = ResourceUtils.fixResourcePath(mail);
    }

    public String getUniqueId() {
        return this.mail.getUuid();
    }

    public String getName() {
        return JCRUtils.getName(this.mail.getPath());
    }

    public Object authenticate(String user, String password) {
        return "OpenKM";
    }

    public boolean authorise(Request request, Request.Method method, Auth auth) {
        return true;
    }

    public String getRealm() {
        return "OpenKM";
    }

    public Date getCreateDate() {
        return this.mail.getCreated().getTime();
    }

    public Date getModifiedDate() {
        return this.mail.getCreated().getTime();
    }

    public String checkRedirect(Request request) {
        return null;
    }

    public Long getMaxAgeSeconds(Auth auth) {
        return null;
    }

    public String getContentType(String accepts) {
        if (this.mail.getAttachments().isEmpty()) {
            return this.mail.getMimeType();
        }
        return "message/rfc822";
    }

    public Long getContentLength() {
        return null;
    }

    public void sendContent(OutputStream out, Range range, Map<String, String> params, String contentType) throws IOException, NotAuthorizedException, BadRequestException {
        log.debug("sendContent({}, {})", params, (Object)contentType);
        try {
            String token = JcrSessionTokenHolder.get();
            String fixedMailPath = ResourceUtils.fixRepositoryPath(this.mail.getPath());
            Mail mail = OKMMail.getInstance().getProperties(token, fixedMailPath);
            if (mail.getAttachments().isEmpty()) {
                IOUtils.write((String)mail.getContent(), (OutputStream)out);
            } else {
                MimeMessage m = MailUtils.create(token, mail);
                m.writeTo(out);
                out.flush();
            }
        }
        catch (PathNotFoundException e) {
            log.error("PathNotFoundException: " + e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            log.error("RepositoryException: " + e.getMessage(), (Throwable)e);
        }
        catch (DatabaseException e) {
            log.error("DatabaseException: " + e.getMessage(), (Throwable)e);
        }
        catch (MessagingException e) {
            log.error("MessagingException: " + e.getMessage(), (Throwable)e);
        }
    }

    public void delete() throws NotAuthorizedException, ConflictException, BadRequestException {
        log.debug("delete()");
        try {
            String token = JcrSessionTokenHolder.get();
            String fixedMailPath = ResourceUtils.fixRepositoryPath(this.mail.getPath());
            OKMMail.getInstance().delete(token, fixedMailPath);
        }
        catch (Exception e) {
            throw new ConflictException((Resource)this);
        }
    }

    public void setProperties(PropPatchHandler.Fields fields) {
    }

    public void moveTo(CollectionResource newParent, String newName) throws ConflictException, NotAuthorizedException, BadRequestException {
        log.debug("moveTo({}, {})", (Object)newParent, (Object)newName);
        if (newParent instanceof FolderResource) {
            FolderResource newFldParent = (FolderResource)newParent;
            String dstParentPath = newFldParent.getFolder().getPath();
            String dstPath = dstParentPath + "/" + newName;
            String fixedDstParentPath = ResourceUtils.fixRepositoryPath(dstParentPath);
            String fixedDstPath = ResourceUtils.fixRepositoryPath(dstPath);
            try {
                String token = JcrSessionTokenHolder.get();
                String fixedMailPath = ResourceUtils.fixRepositoryPath(this.mail.getPath());
                String fixedMailParentPath = JCRUtils.getParent(fixedMailPath);
                if (fixedMailParentPath.compareTo(fixedDstParentPath) == 0) {
                    this.mail = OKMMail.getInstance().rename(token, fixedMailPath, newName);
                }
                OKMMail.getInstance().move(token, fixedMailPath, fixedDstParentPath);
                this.mail = OKMMail.getInstance().getProperties(token, fixedDstPath);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to move to: " + dstPath);
            }
        } else {
            throw new RuntimeException("Destination is an unknown type. Must be a FsDirectoryResource, is a: " + newParent.getClass());
        }
    }

    public void copyTo(CollectionResource newParent, String newName) throws NotAuthorizedException, BadRequestException, ConflictException {
        log.debug("copyTo({}, {})", (Object)newParent, (Object)newName);
        if (newParent instanceof FolderResource) {
            FolderResource newFldParent = (FolderResource)newParent;
            String dstPath = newFldParent.getFolder().getPath() + "/" + newName;
            try {
                String token = JcrSessionTokenHolder.get();
                String fixedMailPath = ResourceUtils.fixRepositoryPath(this.mail.getPath());
                OKMMail.getInstance().copy(token, fixedMailPath, dstPath);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to copy to:" + dstPath, e);
            }
        } else {
            throw new RuntimeException("Destination is an unknown type. Must be a FolderResource, is a: " + newParent.getClass());
        }
    }

    public Long getQuotaUsed() {
        return new Long(0L);
    }

    public Long getQuotaAvailable() {
        return Long.MAX_VALUE;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("mail=").append(this.mail);
        sb.append("}");
        return sb.toString();
    }
}

