/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.webdav.resource;

import com.bradmcevoy.common.Path;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.ResourceFactory;
import com.openkm.core.AccessDeniedException;
import com.openkm.core.DatabaseException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.webdav.resource.ResourceUtils;
import com.openkm.webdav.resource.RootResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceFactoryImpl
implements ResourceFactory {
    private static final Logger log = LoggerFactory.getLogger(ResourceFactoryImpl.class);
    public static final String REALM = "OpenKM";

    public Resource getResource(String host, String url) {
        log.debug("getResource({}, {})", (Object)host, (Object)url);
        Path srcPath = Path.path((String)url);
        Path path = srcPath.getStripFirst().getStripFirst();
        try {
            if (path.isRoot()) {
                log.debug("ROOT");
                return new RootResource(srcPath);
            }
            return ResourceUtils.getNode(srcPath, path.toPath());
        }
        catch (PathNotFoundException e) {
            log.error("PathNotFoundException: " + e.getMessage());
        }
        catch (AccessDeniedException e) {
            log.error("AccessDeniedException: " + e.getMessage());
        }
        catch (RepositoryException e) {
            log.error("RepositoryException: " + e.getMessage());
        }
        catch (DatabaseException e) {
            log.error("DatabaseException: " + e.getMessage());
        }
        return null;
    }
}

