/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.webdav.resource;

import com.bradmcevoy.common.Path;
import com.bradmcevoy.http.Resource;
import com.openkm.api.OKMDocument;
import com.openkm.api.OKMFolder;
import com.openkm.api.OKMMail;
import com.openkm.bean.Document;
import com.openkm.bean.Folder;
import com.openkm.bean.Mail;
import com.openkm.core.AccessDeniedException;
import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.webdav.JcrSessionTokenHolder;
import com.openkm.webdav.resource.DocumentResource;
import com.openkm.webdav.resource.FolderResource;
import com.openkm.webdav.resource.MailResource;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceUtils {
    private static final Logger log = LoggerFactory.getLogger(ResourceUtils.class);

    public static Resource getFolder(Path path, String fldPath) throws PathNotFoundException, RepositoryException, DatabaseException {
        String token = JcrSessionTokenHolder.get();
        String fixedFldPath = ResourceUtils.fixRepositoryPath(fldPath);
        Folder fld = OKMFolder.getInstance().getProperties(token, fixedFldPath);
        List<Folder> fldChilds = OKMFolder.getInstance().getChilds(token, fixedFldPath);
        List<Document> docChilds = OKMDocument.getInstance().getChilds(token, fixedFldPath);
        List<Mail> mailChilds = OKMMail.getInstance().getChilds(token, fixedFldPath);
        FolderResource fldResource = new FolderResource(path, fld, fldChilds, docChilds, mailChilds);
        return fldResource;
    }

    public static Resource getDocument(String docPath) throws PathNotFoundException, RepositoryException, DatabaseException {
        String token = JcrSessionTokenHolder.get();
        String fixedDocPath = ResourceUtils.fixRepositoryPath(docPath);
        Document doc = OKMDocument.getInstance().getProperties(token, fixedDocPath);
        DocumentResource docResource = new DocumentResource(doc);
        return docResource;
    }

    public static Resource getMail(String mailPath) throws PathNotFoundException, RepositoryException, DatabaseException {
        String token = JcrSessionTokenHolder.get();
        String fixedMailPath = ResourceUtils.fixRepositoryPath(mailPath);
        Mail mail = OKMMail.getInstance().getProperties(token, fixedMailPath);
        MailResource docResource = new MailResource(mail);
        return docResource;
    }

    public static Resource getNode(Path srcPath, String path) throws PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("getNode({}, {})", (Object)srcPath, (Object)path);
        String token = JcrSessionTokenHolder.get();
        String fixedPath = ResourceUtils.fixRepositoryPath(path);
        try {
            if (OKMFolder.getInstance().isValid(token, fixedPath)) {
                Resource res = ResourceUtils.getFolder(srcPath, path);
                log.debug("getNode: {}", (Object)res);
                return res;
            }
            if (OKMDocument.getInstance().isValid(token, fixedPath)) {
                Resource res = ResourceUtils.getDocument(path);
                log.debug("getNode: {}", (Object)res);
                return res;
            }
            if (OKMMail.getInstance().isValid(token, fixedPath)) {
                Resource res = ResourceUtils.getMail(path);
                log.debug("getNode: {}", (Object)res);
                return res;
            }
        }
        catch (PathNotFoundException e) {
            log.warn("PathNotFoundException: {}", (Object)e.getMessage());
        }
        log.debug("getNode: null");
        return null;
    }

    public static void createContent(OutputStream out, Path path, List<Folder> fldChilds, List<Document> docChilds, List<Mail> mailChilds) {
        String url;
        log.debug("createContent({}, {}, {}, {}, {})", new Object[]{out, path, fldChilds, docChilds, mailChilds});
        PrintWriter pw = new PrintWriter(out);
        pw.println("<html>");
        pw.println("<header>");
        pw.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />");
        pw.println("<link rel=\"Shortcut icon\" href=\"/" + path.getFirst() + "/favicon.ico\" />");
        pw.println("<link rel=\"stylesheet\" href=\"/" + path.getFirst() + "/css/style.css\" type=\"text/css\" />");
        pw.println("<title>OpenKM WebDAV</title>");
        pw.println("</header>");
        pw.println("<body>");
        pw.println("<h1>OpenKM WebDAV</h1>");
        pw.println("<table>");
        if (!path.getStripFirst().getStripFirst().isRoot()) {
            String url2 = path.getParent().toPath();
            pw.print("<tr>");
            pw.print("<td><img src='/" + path.getFirst() + "/img/webdav/folder.png'/></td>");
            pw.print("<td><a href='" + url2 + "'>..</a></td>");
            pw.println("<tr>");
        }
        if (fldChilds != null) {
            for (Folder fld : fldChilds) {
                Path fldPath = Path.path((String)fld.getPath());
                url = path.toPath().concat("/").concat(fldPath.getName());
                pw.print("<tr>");
                pw.print("<td><img src='/" + path.getFirst() + "/img/webdav/folder.png'/></td>");
                pw.print("<td><a href='" + url + "'>" + fldPath.getName() + "</a></td>");
                pw.println("<tr>");
            }
        }
        if (docChilds != null) {
            for (Document doc : docChilds) {
                Path docPath = Path.path((String)doc.getPath());
                url = path.toPath().concat("/").concat(docPath.getName());
                pw.print("<tr>");
                pw.print("<td><img src='/" + path.getFirst() + "/mime/" + doc.getMimeType() + "'/></td>");
                pw.print("<td><a href='" + url + "'>" + docPath.getName() + "</a></td>");
                pw.println("<tr>");
            }
        }
        if (mailChilds != null) {
            for (Mail mail : mailChilds) {
                Path mailPath = Path.path((String)mail.getPath());
                url = path.toPath().concat("/").concat(mailPath.getName());
                pw.print("<tr>");
                if (mail.getAttachments().isEmpty()) {
                    pw.print("<td><img src='/" + path.getFirst() + "/img/webdav/email.png'/></td>");
                } else {
                    pw.print("<td><img src='/" + path.getFirst() + "/img/webdav/email_attach.png'/></td>");
                }
                pw.print("<td><a href='" + url + "'>" + mailPath.getName() + "</a></td>");
                pw.println("<tr>");
            }
        }
        pw.println("</table>");
        pw.println("</body>");
        pw.println("</html>");
        pw.flush();
        pw.close();
    }

    public static String wildcard2regexp(String wildcard) {
        StringBuffer sb = new StringBuffer("^");
        block5: for (int i = 0; i < wildcard.length(); ++i) {
            char c = wildcard.charAt(i);
            switch (c) {
                case '.': {
                    sb.append("\\.");
                    continue block5;
                }
                case '*': {
                    sb.append(".*");
                    continue block5;
                }
                case '?': {
                    sb.append(".");
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static Folder fixResourcePath(Folder fld) {
        if (Config.SYSTEM_WEBDAV_FIX) {
            fld.setPath(ResourceUtils.fixResourcePath(fld.getPath()));
        }
        return fld;
    }

    public static Document fixResourcePath(Document doc) {
        if (Config.SYSTEM_WEBDAV_FIX) {
            doc.setPath(ResourceUtils.fixResourcePath(doc.getPath()));
        }
        return doc;
    }

    public static Mail fixResourcePath(Mail mail) {
        if (Config.SYSTEM_WEBDAV_FIX) {
            mail.setPath(ResourceUtils.fixResourcePath(mail.getPath()));
        }
        return mail;
    }

    private static String fixResourcePath(String path) {
        return path.replace("okm:", "okm_");
    }

    public static String fixRepositoryPath(String path) {
        if (Config.SYSTEM_WEBDAV_FIX) {
            return path.replace("okm_", "okm:");
        }
        return path;
    }
}

