/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.webdav.resource;

import com.bradmcevoy.common.Path;
import com.bradmcevoy.http.Auth;
import com.bradmcevoy.http.CollectionResource;
import com.bradmcevoy.http.GetableResource;
import com.bradmcevoy.http.PropFindableResource;
import com.bradmcevoy.http.QuotaResource;
import com.bradmcevoy.http.Range;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.exceptions.BadRequestException;
import com.bradmcevoy.http.exceptions.NotAuthorizedException;
import com.openkm.api.OKMRepository;
import com.openkm.bean.Folder;
import com.openkm.bean.Repository;
import com.openkm.core.PathNotFoundException;
import com.openkm.jcr.JCRUtils;
import com.openkm.webdav.JcrSessionTokenHolder;
import com.openkm.webdav.resource.FolderResource;
import com.openkm.webdav.resource.ResourceUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootResource
implements PropFindableResource,
GetableResource,
CollectionResource,
QuotaResource {
    private final Logger log = LoggerFactory.getLogger(RootResource.class);
    private final List<Folder> fldChilds = new ArrayList<Folder>();
    private Folder fld;
    private final Path path;

    public RootResource(Path path) {
        this.path = path;
        this.fld = new Folder();
        this.fld.setPath("/");
        this.fld.setUuid(Repository.getUuid());
        try {
            String token = JcrSessionTokenHolder.get();
            Folder okmRoot = OKMRepository.getInstance().getRootFolder(token);
            this.fldChilds.add(ResourceUtils.fixResourcePath(okmRoot));
            this.fld.setCreated(okmRoot.getCreated());
            Folder okmPersonal = OKMRepository.getInstance().getPersonalFolderBase(token);
            this.fldChilds.add(ResourceUtils.fixResourcePath(okmPersonal));
            Folder okmTemplates = OKMRepository.getInstance().getTemplatesFolder(token);
            this.fldChilds.add(ResourceUtils.fixResourcePath(okmTemplates));
            Folder okmMail = OKMRepository.getInstance().getMailFolderBase(token);
            this.fldChilds.add(ResourceUtils.fixResourcePath(okmMail));
        }
        catch (PathNotFoundException e) {
            this.log.error("PathNotFoundException: " + e.getMessage());
        }
        catch (Exception e) {
            this.log.error("Exception: " + e.getMessage());
        }
    }

    public Folder getFolder() {
        return this.fld;
    }

    public String getUniqueId() {
        return this.fld.getUuid();
    }

    public String getName() {
        return JCRUtils.getName(this.fld.getPath());
    }

    public Object authenticate(String user, String password) {
        return "OpenKM";
    }

    public boolean authorise(Request request, Request.Method method, Auth auth) {
        return true;
    }

    public String getRealm() {
        return "OpenKM";
    }

    public Date getCreateDate() {
        return this.fld.getCreated().getTime();
    }

    public Date getModifiedDate() {
        return this.fld.getCreated().getTime();
    }

    public String checkRedirect(Request request) {
        return null;
    }

    public Resource child(String childName) {
        this.log.debug("child({})", (Object)childName);
        try {
            return ResourceUtils.getNode(this.path, Path.path((String)this.fld.getPath()).getStripFirst() + "/" + childName);
        }
        catch (PathNotFoundException e) {
            this.log.error("PathNotFoundException: " + e.getMessage());
        }
        catch (Exception e) {
            this.log.error("Exception: " + e.getMessage());
        }
        return null;
    }

    public List<? extends Resource> getChildren() {
        this.log.debug("getChildren()");
        ArrayList<FolderResource> resources = new ArrayList<FolderResource>();
        if (this.fldChilds != null) {
            for (Folder fld : this.fldChilds) {
                resources.add(new FolderResource(fld));
            }
        }
        return resources;
    }

    public void sendContent(OutputStream out, Range range, Map<String, String> params, String contentType) throws IOException, NotAuthorizedException, BadRequestException {
        this.log.debug("sendContent({}, {})", params, (Object)contentType);
        ResourceUtils.createContent(out, this.path, this.fldChilds, null, null);
    }

    public Long getMaxAgeSeconds(Auth auth) {
        return null;
    }

    public String getContentType(String accepts) {
        return null;
    }

    public Long getContentLength() {
        return null;
    }

    public Long getQuotaUsed() {
        return new Long(0L);
    }

    public Long getQuotaAvailable() {
        return Long.MAX_VALUE;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("fld=").append(this.fld);
        sb.append("}");
        return sb.toString();
    }
}

