/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.ws.endpoint;

import com.openkm.core.AccessDeniedException;
import com.openkm.core.DatabaseException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.module.AuthModule;
import com.openkm.module.ModuleManager;
import com.openkm.principal.PrincipalAdapterException;
import com.openkm.ws.util.BytePair;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import org.jboss.annotation.security.SecurityDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService
@SOAPBinding(style=SOAPBinding.Style.RPC)
@SecurityDomain(value="OpenKM")
public class OKMAuth {
    private static Logger log = LoggerFactory.getLogger(OKMAuth.class);

    @WebMethod
    public String login(@WebParam(name="user") String user, @WebParam(name="password") String password) throws AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("login({}, {})", (Object)user, (Object)password);
        AuthModule am = ModuleManager.getAuthModule();
        String token = am.login(user, password);
        log.debug("login: {}", (Object)token);
        return token;
    }

    @WebMethod
    public void logout(@WebParam(name="token") String token) throws RepositoryException, DatabaseException {
        log.debug("logout({})", (Object)token);
        AuthModule am = ModuleManager.getAuthModule();
        am.logout(token);
        log.debug("logout: void");
    }

    @WebMethod
    public BytePair[] getGrantedRoles(@WebParam(name="token") String token, @WebParam(name="nodePath") String nodePath) throws PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("getGrantedRoles({}, {})", (Object)token, (Object)nodePath);
        AuthModule am = ModuleManager.getAuthModule();
        Map<String, Byte> hm = am.getGrantedRoles(token, nodePath);
        Set<String> keys = hm.keySet();
        Object[] result = new BytePair[keys.size()];
        int i = 0;
        for (String key : keys) {
            BytePair p = new BytePair();
            p.setKey(key);
            p.setValue(hm.get(key));
            result[i++] = p;
        }
        log.debug("getGrantedRoles: {}", result);
        return result;
    }

    @WebMethod
    public BytePair[] getGrantedUsers(@WebParam(name="token") String token, @WebParam(name="nodePath") String nodePath) throws PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("getGrantedUsers({}, {})", (Object)token, (Object)nodePath);
        AuthModule am = ModuleManager.getAuthModule();
        Map<String, Byte> hm = am.getGrantedUsers(token, nodePath);
        Set<String> keys = hm.keySet();
        Object[] result = new BytePair[keys.size()];
        int i = 0;
        for (String key : keys) {
            BytePair p = new BytePair();
            p.setKey(key);
            p.setValue(hm.get(key));
            result[i++] = p;
        }
        log.debug("getGrantedUsers: {}", result);
        return result;
    }

    @WebMethod
    public String[] getRoles(@WebParam(name="token") String token) throws PrincipalAdapterException {
        log.debug("getRoles({})", (Object)token);
        AuthModule am = ModuleManager.getAuthModule();
        List<String> col = am.getRoles(token);
        Object[] result = col.toArray(new String[col.size()]);
        log.debug("getRoles: {}", result);
        return result;
    }

    @WebMethod
    public String[] getUsers(@WebParam(name="token") String token) throws PrincipalAdapterException {
        log.debug("getUsers({})", (Object)token);
        AuthModule am = ModuleManager.getAuthModule();
        List<String> col = am.getUsers(token);
        Object[] result = col.toArray(new String[col.size()]);
        log.debug("getUsers: {]", result);
        return result;
    }

    @WebMethod
    public void grantRole(@WebParam(name="token") String token, @WebParam(name="nodePath") String nodePath, @WebParam(name="role") String role, @WebParam(name="permissions") int permissions, @WebParam(name="recursive") boolean recursive) throws PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("grantRole({}, {}, {}, {}, {})", new Object[]{token, nodePath, role, permissions, recursive});
        AuthModule am = ModuleManager.getAuthModule();
        am.grantRole(token, nodePath, role, permissions, recursive);
        log.debug("grantRole: void");
    }

    @WebMethod
    public void grantUser(@WebParam(name="token") String token, @WebParam(name="nodePath") String nodePath, @WebParam(name="user") String user, @WebParam(name="permissions") int permissions, @WebParam(name="recursive") boolean recursive) throws PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("grantUser({}, {}, {}, {}, {})", new Object[]{token, nodePath, user, permissions, recursive});
        AuthModule am = ModuleManager.getAuthModule();
        am.grantUser(token, nodePath, user, permissions, recursive);
        log.debug("grantUser: void");
    }

    @WebMethod
    public void revokeRole(@WebParam(name="token") String token, @WebParam(name="nodePath") String nodePath, @WebParam(name="user") String user, @WebParam(name="permissions") int permissions, @WebParam(name="recursive") boolean recursive) throws PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("revokeRole({}, {}, {}, {}, {})", new Object[]{token, nodePath, user, permissions, recursive});
        AuthModule am = ModuleManager.getAuthModule();
        am.revokeRole(token, nodePath, user, permissions, recursive);
        log.debug("revokeRole: void");
    }

    @WebMethod
    public void revokeUser(@WebParam(name="token") String token, @WebParam(name="nodePath") String nodePath, @WebParam(name="user") String user, @WebParam(name="permissions") int permissions, @WebParam(name="recursive") boolean recursive) throws PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("revokeUser({}, {}, {}, {}, {})", new Object[]{token, nodePath, user, permissions, recursive});
        AuthModule am = ModuleManager.getAuthModule();
        am.revokeUser(token, nodePath, user, permissions, recursive);
        log.debug("revokeUser: void");
    }

    @WebMethod
    public String[] getUsersByRole(@WebParam(name="token") String token, @WebParam(name="role") String role) throws PrincipalAdapterException {
        log.debug("getUsersByRole({}, {})", (Object)token, (Object)role);
        AuthModule am = ModuleManager.getAuthModule();
        List<String> col = am.getUsersByRole(token, role);
        Object[] result = col.toArray(new String[col.size()]);
        log.debug("getUsersByRole: {}", result);
        return result;
    }

    @WebMethod
    public String[] getRolesByUser(@WebParam(name="token") String token, @WebParam(name="user") String user) throws PrincipalAdapterException {
        log.debug("getRolesByUser({}, {})", (Object)token, (Object)user);
        AuthModule am = ModuleManager.getAuthModule();
        List<String> col = am.getRolesByUser(token, user);
        Object[] result = col.toArray(new String[col.size()]);
        log.debug("getRolesByUser: {}", result);
        return result;
    }

    @WebMethod
    public String getMail(@WebParam(name="token") String token, @WebParam(name="user") String user) throws PrincipalAdapterException {
        log.debug("getMail({}, {})", (Object)token, (Object)user);
        AuthModule am = ModuleManager.getAuthModule();
        String ret = am.getMail(token, user);
        log.debug("getMail: {}", (Object)ret);
        return ret;
    }

    @WebMethod
    public String getName(@WebParam(name="token") String token, @WebParam(name="user") String user) throws PrincipalAdapterException {
        log.debug("getName({}, {})", (Object)token, (Object)user);
        AuthModule am = ModuleManager.getAuthModule();
        String ret = am.getName(token, user);
        log.debug("getName: {}", (Object)ret);
        return ret;
    }
}

