/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.ws.endpoint;

import com.openkm.bean.Document;
import com.openkm.bean.Document2;
import com.openkm.bean.DocumentHash;
import com.openkm.bean.Lock;
import com.openkm.bean.Version;
import com.openkm.core.AccessDeniedException;
import com.openkm.core.DatabaseException;
import com.openkm.core.FileSizeExceededException;
import com.openkm.core.ItemExistsException;
import com.openkm.core.LockException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.core.UnsupportedMimeTypeException;
import com.openkm.core.UserQuotaExceededException;
import com.openkm.core.VersionException;
import com.openkm.core.VirusDetectedException;
import com.openkm.extension.core.ExtensionException;
import com.openkm.module.DocumentModule;
import com.openkm.module.ModuleManager;
import com.openkm.principal.PrincipalAdapterException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.annotation.XmlMimeType;
import javax.xml.ws.BindingType;
import org.jboss.annotation.security.SecurityDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService
@SOAPBinding(style=SOAPBinding.Style.RPC)
@BindingType(value="http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true")
@SecurityDomain(value="OpenKM")
public class OKMDocument {
    private static Logger log = LoggerFactory.getLogger(OKMDocument.class);

    @WebMethod
    public Document create(@WebParam(name="token") String token, @WebParam(name="doc") Document doc, @WebParam(name="content") @XmlMimeType(value="application/octet-stream") DataHandler content) throws IOException, UnsupportedMimeTypeException, FileSizeExceededException, UserQuotaExceededException, VirusDetectedException, ItemExistsException, PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException, ExtensionException {
        log.debug("create({})", (Object)doc);
        DocumentModule dm = ModuleManager.getDocumentModule();
        InputStream bais = content.getInputStream();
        Document newDocument = dm.create(token, doc, bais);
        bais.close();
        log.debug("create: {}", (Object)newDocument);
        return newDocument;
    }

    @WebMethod
    public Document createSimple(@WebParam(name="token") String token, @WebParam(name="docPath") String docPath, @WebParam(name="content") @XmlMimeType(value="application/octet-stream") DataHandler content) throws IOException, UnsupportedMimeTypeException, FileSizeExceededException, UserQuotaExceededException, VirusDetectedException, ItemExistsException, PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException, ExtensionException {
        log.debug("createSimple({})", (Object)docPath);
        DocumentModule dm = ModuleManager.getDocumentModule();
        InputStream bais = content.getInputStream();
        Document doc = new Document();
        doc.setPath(docPath);
        Document newDocument = dm.create(token, doc, bais);
        bais.close();
        log.debug("createSimple: {}", (Object)newDocument);
        return newDocument;
    }

    @WebMethod
    public void delete(@WebParam(name="token") String token, @WebParam(name="docPath") String docPath) throws AccessDeniedException, RepositoryException, PathNotFoundException, LockException, DatabaseException, ExtensionException {
        log.debug("delete({}, {})", (Object)token, (Object)docPath);
        DocumentModule dm = ModuleManager.getDocumentModule();
        dm.delete(token, docPath);
        log.debug("delete: void");
    }

    @WebMethod
    public Document getProperties(@WebParam(name="token") String token, @WebParam(name="docPath") String docPath) throws RepositoryException, PathNotFoundException, DatabaseException {
        log.debug("getProperties({}, {})", (Object)token, (Object)docPath);
        DocumentModule dm = ModuleManager.getDocumentModule();
        Document doc = dm.getProperties(token, docPath);
        log.debug("getProperties: {}", (Object)doc);
        return doc;
    }

    @WebMethod
    @XmlMimeType(value="application/octet-stream")
    public DataHandler getContent(@WebParam(name="token") String token, @WebParam(name="docPath") String docPath, @WebParam(name="checkout") boolean checkout) throws RepositoryException, IOException, PathNotFoundException, DatabaseException {
        log.debug("getContent({}, {}, {})", new Object[]{token, docPath, checkout});
        DocumentModule dm = ModuleManager.getDocumentModule();
        InputStream is = dm.getContent(token, docPath, checkout);
        DataHandler data = new DataHandler((DataSource)new DhDatasource(is, null, docPath));
        log.debug("getContent: {}", (Object)data);
        return data;
    }

    @WebMethod
    @XmlMimeType(value="application/octet-stream")
    public DataHandler getContentByVersion(@WebParam(name="token") String token, @WebParam(name="docPath") String docPath, @WebParam(name="versionId") String versionId) throws RepositoryException, IOException, PathNotFoundException, DatabaseException {
        log.debug("getContentByVersion({}, {}, {})", new Object[]{token, docPath, versionId});
        DocumentModule dm = ModuleManager.getDocumentModule();
        InputStream is = dm.getContentByVersion(token, docPath, versionId);
        DataHandler data = new DataHandler((DataSource)new DhDatasource(is, null, docPath));
        log.debug("getContentByVersion: {}", (Object)data);
        return data;
    }

    @WebMethod
    public Document[] getChilds(@WebParam(name="token") String token, @WebParam(name="fldPath") String fldPath) throws RepositoryException, PathNotFoundException, DatabaseException {
        log.debug("getChilds({}, {})", (Object)token, (Object)fldPath);
        DocumentModule dm = ModuleManager.getDocumentModule();
        List<Document> col = dm.getChilds(token, fldPath);
        Object[] result = col.toArray(new Document[col.size()]);
        log.debug("getChilds: {}", result);
        return result;
    }

    @WebMethod
    public Document2[] getChilds2(@WebParam(name="token") String token, @WebParam(name="fldPath") String fldPath) throws RepositoryException, PathNotFoundException, DatabaseException {
        log.debug("getChilds2({}, {})", (Object)token, (Object)fldPath);
        DocumentModule dm = ModuleManager.getDocumentModule();
        List<Document2> col = dm.getChilds2(token, fldPath);
        Object[] result = col.toArray(new Document2[col.size()]);
        log.debug("getChilds2: {}", result);
        return result;
    }

    @WebMethod
    public Document rename(@WebParam(name="token") String token, @WebParam(name="docPath") String docPath, @WebParam(name="newName") String newName) throws AccessDeniedException, RepositoryException, PathNotFoundException, ItemExistsException, DatabaseException, ExtensionException {
        log.debug("rename({}, {}, {})", new Object[]{token, docPath, newName});
        DocumentModule dm = ModuleManager.getDocumentModule();
        Document renamedDocument = dm.rename(token, docPath, newName);
        log.debug("rename: {}", (Object)renamedDocument);
        return renamedDocument;
    }

    @WebMethod
    public void setProperties(@WebParam(name="token") String token, @WebParam(name="doc") Document doc) throws AccessDeniedException, RepositoryException, PathNotFoundException, VersionException, LockException, DatabaseException {
        log.debug("setProperties({}, {})", (Object)token, (Object)doc);
        DocumentModule dm = ModuleManager.getDocumentModule();
        dm.setProperties(token, doc);
        log.debug("setProperties: void");
    }

    @WebMethod
    public void checkout(@WebParam(name="token") String token, @WebParam(name="docPath") String docPath) throws AccessDeniedException, RepositoryException, PathNotFoundException, LockException, DatabaseException {
        log.debug("checkout({}, {})", (Object)token, (Object)docPath);
        DocumentModule dm = ModuleManager.getDocumentModule();
        dm.checkout(token, docPath, new Boolean[0]);
        log.debug("checkout: void");
    }

    @WebMethod
    public void cancelCheckout(@WebParam(name="token") String token, @WebParam(name="docPath") String docPath) throws AccessDeniedException, RepositoryException, PathNotFoundException, LockException, DatabaseException {
        log.debug("cancelCheckout({}, {})", (Object)token, (Object)docPath);
        DocumentModule dm = ModuleManager.getDocumentModule();
        dm.cancelCheckout(token, docPath);
        log.debug("cancelCheckout: void");
    }

    @WebMethod
    public void forceCancelCheckout(@WebParam(name="token") String token, @WebParam(name="docPath") String docPath) throws AccessDeniedException, RepositoryException, PathNotFoundException, LockException, DatabaseException, PrincipalAdapterException {
        log.debug("forceCancelCheckout({}, {})", (Object)token, (Object)docPath);
        DocumentModule dm = ModuleManager.getDocumentModule();
        dm.forceCancelCheckout(token, docPath);
        log.debug("forceCancelCheckout: void");
    }

    @WebMethod
    public Version checkin(@WebParam(name="token") String token, @WebParam(name="docPath") String docPath, @WebParam(name="comment") String comment) throws LockException, VersionException, PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException, ExtensionException {
        log.debug("checkin({}, {} ,{})", new Object[]{token, docPath, comment});
        DocumentModule dm = ModuleManager.getDocumentModule();
        Version version = dm.checkin(token, docPath, comment, new Boolean[0]);
        log.debug("checkin: {}", (Object)version);
        return version;
    }

    @WebMethod
    public Version[] getVersionHistory(@WebParam(name="token") String token, @WebParam(name="docPath") String docPath) throws PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("getVersionHistory({}, {})", (Object)token, (Object)docPath);
        DocumentModule dm = ModuleManager.getDocumentModule();
        List<Version> col = dm.getVersionHistory(token, docPath);
        Object[] result = col.toArray(new Version[col.size()]);
        log.debug("getVersionHistory: {}", result);
        return result;
    }

    @WebMethod
    public void setContent(@WebParam(name="token") String token, @WebParam(name="docPath") String docPath, @WebParam(name="content") @XmlMimeType(value="application/octet-stream") DataHandler content) throws FileSizeExceededException, UserQuotaExceededException, VirusDetectedException, VersionException, LockException, PathNotFoundException, AccessDeniedException, RepositoryException, IOException, DatabaseException, ExtensionException {
        log.debug("setContent({}, {}, {})", new Object[]{token, docPath, content});
        DocumentModule dm = ModuleManager.getDocumentModule();
        InputStream bais = content.getInputStream();
        dm.setContent(token, docPath, bais, null);
        bais.close();
        log.debug("setContent: void");
    }

    @WebMethod
    public Lock lock(@WebParam(name="token") String token, @WebParam(name="docPath") String docPath) throws LockException, PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("lock({}, {})", new Object[]{token, docPath});
        DocumentModule dm = ModuleManager.getDocumentModule();
        Lock lock = dm.lock(token, docPath);
        log.debug("lock: {}", (Object)lock);
        return lock;
    }

    @WebMethod
    public void unlock(@WebParam(name="token") String token, @WebParam(name="docPath") String docPath) throws LockException, PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("unlock({}, {})", new Object[]{token, docPath});
        DocumentModule dm = ModuleManager.getDocumentModule();
        dm.unlock(token, docPath);
        log.debug("unlock: void");
    }

    @WebMethod
    public void forceUnlock(@WebParam(name="token") String token, @WebParam(name="docPath") String docPath) throws LockException, PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException, PrincipalAdapterException {
        log.debug("forceUnlock({}, {})", (Object)token, (Object)docPath);
        DocumentModule dm = ModuleManager.getDocumentModule();
        dm.forceUnlock(token, docPath);
        log.debug("forceUnlock: void");
    }

    @WebMethod
    public void purge(@WebParam(name="token") String token, @WebParam(name="docPath") String docPath) throws AccessDeniedException, RepositoryException, PathNotFoundException, DatabaseException, ExtensionException {
        log.debug("purge({}, {})", (Object)token, (Object)docPath);
        DocumentModule dm = ModuleManager.getDocumentModule();
        dm.purge(token, docPath);
        log.debug("purge: void");
    }

    @WebMethod
    public void move(@WebParam(name="token") String token, @WebParam(name="docPath") String docPath, @WebParam(name="fldPath") String fldPath) throws LockException, PathNotFoundException, ItemExistsException, AccessDeniedException, RepositoryException, DatabaseException, ExtensionException {
        log.debug("move({}, {}, {})", new Object[]{token, docPath, fldPath});
        DocumentModule dm = ModuleManager.getDocumentModule();
        dm.move(token, docPath, fldPath);
        log.debug("move: void");
    }

    @WebMethod
    public void restoreVersion(@WebParam(name="token") String token, @WebParam(name="docPath") String docPath, @WebParam(name="versionId") String versionId) throws AccessDeniedException, RepositoryException, PathNotFoundException, DatabaseException, ExtensionException {
        log.debug("restoreVersion({}, {}, {})", new Object[]{token, docPath, versionId});
        DocumentModule dm = ModuleManager.getDocumentModule();
        dm.restoreVersion(token, docPath, versionId);
        log.debug("restoreVersion: void");
    }

    @WebMethod
    public void purgeVersionHistory(@WebParam(name="token") String token, @WebParam(name="docPath") String docPath) throws AccessDeniedException, RepositoryException, PathNotFoundException, DatabaseException {
        log.debug("purgeVersionHistory({}, {})", (Object)token, (Object)docPath);
        DocumentModule dm = ModuleManager.getDocumentModule();
        dm.purgeVersionHistory(token, docPath);
        log.debug("purgeVersionHistory: void");
    }

    @WebMethod
    public long getVersionHistorySize(@WebParam(name="token") String token, @WebParam(name="docPath") String docPath) throws RepositoryException, PathNotFoundException, DatabaseException {
        log.debug("getVersionHistorySize({}, {})", (Object)token, (Object)docPath);
        DocumentModule dm = ModuleManager.getDocumentModule();
        long size = dm.getVersionHistorySize(token, docPath);
        log.debug("getVersionHistorySize: {}", (Object)size);
        return size;
    }

    @WebMethod
    public boolean isValid(@WebParam(name="token") String token, @WebParam(name="docPath") String docPath) throws PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("isValid({}, {})", (Object)token, (Object)docPath);
        DocumentModule dm = ModuleManager.getDocumentModule();
        boolean valid = dm.isValid(token, docPath);
        log.debug("isValid: {}", (Object)valid);
        return valid;
    }

    @WebMethod
    public String getPath(@WebParam(name="token") String token, @WebParam(name="uuid") String uuid) throws AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("getPath({}, {})", (Object)token, (Object)uuid);
        DocumentModule dm = ModuleManager.getDocumentModule();
        String path = dm.getPath(token, uuid);
        log.debug("getPath: {}", (Object)path);
        return path;
    }

    @WebMethod
    public Document2[] getDocuments(@WebParam(name="token") String token, @WebParam(name="docs") DocumentHash[] docs, @WebParam(name="fldPath") String fldPath) throws RepositoryException, PathNotFoundException, DatabaseException {
        log.debug("getDocuments({}, {}, {})", new Object[]{token, docs, fldPath});
        DocumentModule dm = ModuleManager.getDocumentModule();
        List<Document2> col = dm.getDocuments(token, Arrays.asList(docs), fldPath);
        Object[] result = col.toArray(new Document2[col.size()]);
        log.debug("getDocuments: {}", result);
        return result;
    }

    @WebMethod
    public Document2[] getDocumentsModified(@WebParam(name="token") String token, @WebParam(name="docs") String docHash, @WebParam(name="fldPath") String fldPath) throws PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("getDocumentsModified({}, {}, {})", new Object[]{token, docHash, fldPath});
        DocumentModule dm = ModuleManager.getDocumentModule();
        List<Document2> col = dm.getDocuments(token, docHash, fldPath);
        Object[] result = col.toArray(new Document2[col.size()]);
        log.debug("getDocumentsModified: {}", result);
        return result;
    }

    class DhDatasource
    implements DataSource {
        private InputStream is;
        private OutputStream os;
        private String docPath;

        public DhDatasource(InputStream is, OutputStream os, String docPath) {
            this.is = is;
            this.os = os;
            this.docPath = docPath;
        }

        public String getContentType() {
            return "application/octet-stream";
        }

        public InputStream getInputStream() throws IOException {
            return this.is;
        }

        public String getName() {
            return this.docPath;
        }

        public OutputStream getOutputStream() throws IOException {
            return this.os;
        }
    }
}

