/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.ws.endpoint;

import com.openkm.bean.Folder;
import com.openkm.bean.Folder2;
import com.openkm.core.AccessDeniedException;
import com.openkm.core.DatabaseException;
import com.openkm.core.ItemExistsException;
import com.openkm.core.LockException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.extension.core.ExtensionException;
import com.openkm.module.FolderModule;
import com.openkm.module.ModuleManager;
import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import org.jboss.annotation.security.SecurityDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService
@SOAPBinding(style=SOAPBinding.Style.RPC)
@SecurityDomain(value="OpenKM")
public class OKMFolder {
    private static Logger log = LoggerFactory.getLogger(OKMFolder.class);

    @WebMethod
    public Folder create(@WebParam(name="token") String token, @WebParam(name="fld") Folder fld) throws AccessDeniedException, RepositoryException, PathNotFoundException, ItemExistsException, DatabaseException, ExtensionException {
        log.debug("create({}, {})", (Object)token, (Object)fld);
        FolderModule fm = ModuleManager.getFolderModule();
        Folder newFolder = fm.create(token, fld);
        log.debug("create: {}", (Object)newFolder);
        return newFolder;
    }

    @WebMethod
    public Folder createSimple(@WebParam(name="token") String token, @WebParam(name="fldPath") String fldPath) throws AccessDeniedException, RepositoryException, PathNotFoundException, ItemExistsException, DatabaseException, ExtensionException {
        log.debug("createSimple({}, {})", (Object)token, (Object)fldPath);
        FolderModule fm = ModuleManager.getFolderModule();
        Folder fld = new Folder();
        fld.setPath(fldPath);
        Folder newFolder = fm.create(token, fld);
        log.debug("createSimple: {}", (Object)newFolder);
        return newFolder;
    }

    @WebMethod
    public Folder getProperties(@WebParam(name="token") String token, @WebParam(name="fldPath") String fldPath) throws AccessDeniedException, RepositoryException, PathNotFoundException, DatabaseException {
        log.debug("getProperties({}, {})", (Object)token, (Object)fldPath);
        FolderModule fm = ModuleManager.getFolderModule();
        Folder fld = fm.getProperties(token, fldPath);
        log.debug("getProperties: {}", (Object)fld);
        return fld;
    }

    @WebMethod
    public void delete(@WebParam(name="token") String token, @WebParam(name="fldPath") String fldPath) throws LockException, PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("delete({}, {})", (Object)token, (Object)fldPath);
        FolderModule fm = ModuleManager.getFolderModule();
        fm.delete(token, fldPath);
        log.debug("delete: void");
    }

    @WebMethod
    public Folder rename(@WebParam(name="token") String token, @WebParam(name="fldPath") String fldPath, @WebParam(name="newName") String newName) throws PathNotFoundException, ItemExistsException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("rename({}, {}, {})", new Object[]{token, fldPath, newName});
        FolderModule fm = ModuleManager.getFolderModule();
        Folder renamedFolder = fm.rename(token, fldPath, newName);
        log.debug("rename: {}", (Object)renamedFolder);
        return renamedFolder;
    }

    @WebMethod
    public void move(@WebParam(name="token") String token, @WebParam(name="fldPath") String fldPath, @WebParam(name="dstPath") String dstPath) throws PathNotFoundException, ItemExistsException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("move({}, {}, {})", new Object[]{token, fldPath, dstPath});
        FolderModule fm = ModuleManager.getFolderModule();
        fm.move(token, fldPath, dstPath);
        log.debug("move: void");
    }

    @WebMethod
    public Folder[] getChilds(@WebParam(name="token") String token, @WebParam(name="fldPath") String fldPath) throws PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("getChilds({}, {})", (Object)token, (Object)fldPath);
        FolderModule fm = ModuleManager.getFolderModule();
        List<Folder> col = fm.getChilds(token, fldPath);
        Object[] result = col.toArray(new Folder[col.size()]);
        log.debug("getChilds: {}", result);
        return result;
    }

    @WebMethod
    public Folder2[] getChilds2(@WebParam(name="token") String token, @WebParam(name="fldPath") String fldPath) throws PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("getChild2({}, {})", (Object)token, (Object)fldPath);
        FolderModule fm = ModuleManager.getFolderModule();
        List<Folder2> col = fm.getChilds2(token, fldPath);
        Object[] result = col.toArray(new Folder2[col.size()]);
        log.debug("getChilds2: {}", result);
        return result;
    }

    @WebMethod
    public boolean isValid(@WebParam(name="token") String token, @WebParam(name="fldPath") String fldPath) throws PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("isValid({}, {})", (Object)token, (Object)fldPath);
        FolderModule fm = ModuleManager.getFolderModule();
        boolean valid = fm.isValid(token, fldPath);
        log.debug("isValid: {}", (Object)valid);
        return valid;
    }

    @WebMethod
    public String getPath(@WebParam(name="token") String token, @WebParam(name="uuid") String uuid) throws AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("getPath({}, {})", (Object)token, (Object)uuid);
        FolderModule fm = ModuleManager.getFolderModule();
        String path = fm.getPath(token, uuid);
        log.debug("getPath: {}", (Object)path);
        return path;
    }

    @WebMethod
    public void purge(@WebParam(name="token") String token, @WebParam(name="fldPath") String fldPath) throws PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("purge({}, {})", (Object)token, (Object)fldPath);
        FolderModule fm = ModuleManager.getFolderModule();
        fm.purge(token, fldPath);
        log.debug("purge: void");
    }
}

