/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.ws.endpoint;

import com.openkm.bean.Note;
import com.openkm.core.AccessDeniedException;
import com.openkm.core.DatabaseException;
import com.openkm.core.LockException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.module.ModuleManager;
import com.openkm.module.NoteModule;
import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import org.jboss.annotation.security.SecurityDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService
@SOAPBinding(style=SOAPBinding.Style.RPC)
@SecurityDomain(value="OpenKM")
public class OKMNote {
    private static Logger log = LoggerFactory.getLogger(OKMNote.class);

    @WebMethod
    public Note add(@WebParam(name="token") String token, @WebParam(name="nodePath") String nodePath, @WebParam(name="text") String text) throws LockException, PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("add({}, {}, {})", new Object[]{token, nodePath, text});
        NoteModule nm = ModuleManager.getNoteModule();
        Note ret = nm.add(token, nodePath, text);
        log.debug("addNote: {}", (Object)ret);
        return ret;
    }

    @WebMethod
    public Note get(@WebParam(name="token") String token, @WebParam(name="notePath") String notePath) throws LockException, PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("get({}, {})", (Object)token, (Object)notePath);
        NoteModule nm = ModuleManager.getNoteModule();
        Note ret = nm.get(token, notePath);
        log.debug("get: {}", (Object)ret);
        return ret;
    }

    @WebMethod
    public void remove(@WebParam(name="token") String token, @WebParam(name="notePath") String notePath) throws LockException, PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("remove({}, {})", (Object)token, (Object)notePath);
        NoteModule nm = ModuleManager.getNoteModule();
        nm.remove(token, notePath);
        log.debug("remove: void");
    }

    @WebMethod
    public void set(@WebParam(name="token") String token, @WebParam(name="notePath") String notePath, @WebParam(name="text") String text) throws LockException, PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("set({}, {}, {})", new Object[]{token, notePath, text});
        NoteModule nm = ModuleManager.getNoteModule();
        nm.set(token, notePath, text);
        log.debug("set: void");
    }

    @WebMethod
    public Note[] list(@WebParam(name="token") String token, @WebParam(name="nodePath") String nodePath) throws LockException, PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("list({}, {})", (Object)token, (Object)nodePath);
        NoteModule nm = ModuleManager.getNoteModule();
        List<Note> col = nm.list(token, nodePath);
        Object[] result = col.toArray(new Note[col.size()]);
        log.debug("list: {}", result);
        return result;
    }
}

