/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.ws.endpoint;

import com.openkm.core.AccessDeniedException;
import com.openkm.core.DatabaseException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.module.ModuleManager;
import com.openkm.module.NotificationModule;
import java.util.Arrays;
import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import org.jboss.annotation.security.SecurityDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService
@SOAPBinding(style=SOAPBinding.Style.RPC)
@SecurityDomain(value="OpenKM")
public class OKMNotification {
    private static Logger log = LoggerFactory.getLogger(OKMNotification.class);

    @WebMethod
    public void subscribe(@WebParam(name="token") String token, @WebParam(name="nodePath") String nodePath) throws PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("subscribe({}, {})", (Object)token, (Object)nodePath);
        NotificationModule nm = ModuleManager.getNotificationModule();
        nm.subscribe(token, nodePath);
        log.debug("subscribe: void");
    }

    @WebMethod
    public void unsubscribe(@WebParam(name="token") String token, @WebParam(name="nodePath") String nodePath) throws PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("unsubscribe({}, {})", (Object)token, (Object)nodePath);
        NotificationModule nm = ModuleManager.getNotificationModule();
        nm.unsubscribe(token, nodePath);
        log.debug("unsubscribe: void");
    }

    @WebMethod
    public String[] getSubscriptors(@WebParam(name="token") String token, @WebParam(name="nodePath") String nodePath) throws PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("getSubscriptors({}, {})", (Object)token, (Object)nodePath);
        NotificationModule nm = ModuleManager.getNotificationModule();
        List<String> col = nm.getSubscriptors(token, nodePath);
        Object[] result = col.toArray(new String[col.size()]);
        log.debug("getSubscriptors: {}", result);
        return result;
    }

    @WebMethod
    public void notify(@WebParam(name="token") String token, @WebParam(name="nodePath") String nodePath, @WebParam(name="users") String[] users, @WebParam(name="message") String message, @WebParam(name="attachment") boolean attachment) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        log.debug("notify({}, {}, {}, {}, {})", new Object[]{token, nodePath, users, message, attachment});
        NotificationModule nm = ModuleManager.getNotificationModule();
        nm.notify(token, nodePath, Arrays.asList(users), message, attachment);
        log.debug("notify: void");
    }
}

