/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.ws.endpoint;

import com.openkm.core.AccessDeniedException;
import com.openkm.core.DatabaseException;
import com.openkm.core.LockException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.core.VersionException;
import com.openkm.module.ModuleManager;
import com.openkm.module.PropertyModule;
import com.openkm.ws.endpoint.OKMDocument;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import org.jboss.annotation.security.SecurityDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService
@SOAPBinding(style=SOAPBinding.Style.RPC)
@SecurityDomain(value="OpenKM")
public class OKMProperty
implements PropertyModule {
    private static Logger log = LoggerFactory.getLogger(OKMDocument.class);

    @Override
    @WebMethod
    public void addCategory(@WebParam(name="token") String token, @WebParam(name="nodePath") String nodePath, @WebParam(name="catId") String catId) throws VersionException, LockException, PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("addCategory({}, {}, {})", new Object[]{token, nodePath, catId});
        PropertyModule pm = ModuleManager.getPropertyModule();
        pm.addCategory(token, nodePath, catId);
        log.debug("addCategory: void");
    }

    @Override
    @WebMethod
    public void removeCategory(@WebParam(name="token") String token, @WebParam(name="nodePath") String nodePath, @WebParam(name="catId") String catId) throws VersionException, LockException, PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("removeCategory({}, {}, {})", new Object[]{token, nodePath, catId});
        PropertyModule pm = ModuleManager.getPropertyModule();
        pm.removeCategory(token, nodePath, catId);
        log.debug("removeCategory: void");
    }

    @Override
    @WebMethod
    public String addKeyword(@WebParam(name="token") String token, @WebParam(name="nodePath") String nodePath, @WebParam(name="keyword") String keyword) throws VersionException, LockException, PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("addKeyword({}, {}, {})", new Object[]{token, nodePath, keyword});
        PropertyModule pm = ModuleManager.getPropertyModule();
        String ret = pm.addKeyword(token, nodePath, keyword);
        log.debug("addKeyword: {}", (Object)ret);
        return ret;
    }

    @Override
    @WebMethod
    public void removeKeyword(@WebParam(name="token") String token, @WebParam(name="nodePath") String nodePath, @WebParam(name="keyword") String keyword) throws VersionException, LockException, PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("removeKeyword({}, {}, {})", new Object[]{token, nodePath, keyword});
        PropertyModule pm = ModuleManager.getPropertyModule();
        pm.removeKeyword(token, nodePath, keyword);
        log.debug("removeKeyword: void");
    }

    @Override
    public void setEncryption(@WebParam(name="token") String token, @WebParam(name="nodePath") String nodePath, @WebParam(name="cipherName") String cipherName) throws VersionException, LockException, PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("setEncryption({}, {}, {})", new Object[]{token, nodePath, cipherName});
        PropertyModule pm = ModuleManager.getPropertyModule();
        pm.setEncryption(token, nodePath, cipherName);
        log.debug("setEncryption: void");
    }

    @Override
    public void unsetEncryption(@WebParam(name="token") String token, @WebParam(name="nodePath") String nodePath) throws VersionException, LockException, PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("unsetEncryption({}, {})", new Object[]{token, nodePath});
        PropertyModule pm = ModuleManager.getPropertyModule();
        pm.unsetEncryption(token, nodePath);
        log.debug("unsetEncryption: void");
    }
}

