/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.ws.endpoint;

import com.openkm.bean.PropertyGroup;
import com.openkm.bean.form.CheckBox;
import com.openkm.bean.form.FormElement;
import com.openkm.bean.form.Input;
import com.openkm.bean.form.Option;
import com.openkm.bean.form.Select;
import com.openkm.bean.form.SuggestBox;
import com.openkm.bean.form.TextArea;
import com.openkm.core.AccessDeniedException;
import com.openkm.core.DatabaseException;
import com.openkm.core.LockException;
import com.openkm.core.NoSuchGroupException;
import com.openkm.core.NoSuchPropertyException;
import com.openkm.core.ParseException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.extension.core.ExtensionException;
import com.openkm.module.ModuleManager;
import com.openkm.module.PropertyGroupModule;
import com.openkm.ws.util.FormElementComplex;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import org.jboss.annotation.security.SecurityDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService
@SOAPBinding(style=SOAPBinding.Style.RPC)
@SecurityDomain(value="OpenKM")
public class OKMPropertyGroup {
    private static Logger log = LoggerFactory.getLogger(OKMPropertyGroup.class);

    @WebMethod
    public void addGroup(@WebParam(name="token") String token, @WebParam(name="nodePath") String nodePath, @WebParam(name="grpName") String grpName) throws NoSuchGroupException, LockException, PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException, ExtensionException {
        log.debug("addGroup({}, {}, {})", new Object[]{token, nodePath, grpName});
        PropertyGroupModule cm = ModuleManager.getPropertyGroupModule();
        cm.addGroup(token, nodePath, grpName);
        log.debug("addGroup: void");
    }

    @WebMethod
    public void removeGroup(@WebParam(name="token") String token, @WebParam(name="nodePath") String nodePath, @WebParam(name="grpName") String grpName) throws AccessDeniedException, NoSuchGroupException, LockException, PathNotFoundException, RepositoryException, DatabaseException, ExtensionException {
        log.debug("removeGroup({}, {}, {})", new Object[]{token, nodePath, grpName});
        PropertyGroupModule cm = ModuleManager.getPropertyGroupModule();
        cm.removeGroup(token, nodePath, grpName);
        log.debug("removeGroup: void");
    }

    @WebMethod
    public PropertyGroup[] getGroups(@WebParam(name="token") String token, @WebParam(name="nodePath") String nodePath) throws IOException, ParseException, PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("getGroups({}, {})", (Object)token, (Object)nodePath);
        PropertyGroupModule cm = ModuleManager.getPropertyGroupModule();
        List<PropertyGroup> col = cm.getGroups(token, nodePath);
        Object[] result = col.toArray(new PropertyGroup[col.size()]);
        log.debug("getGroups: {}", result);
        return result;
    }

    @WebMethod
    public PropertyGroup[] getAllGroups(@WebParam(name="token") String token) throws IOException, ParseException, RepositoryException, DatabaseException {
        log.debug("getAllGroups({})", (Object)token);
        PropertyGroupModule cm = ModuleManager.getPropertyGroupModule();
        List<PropertyGroup> col = cm.getAllGroups(token);
        Object[] result = col.toArray(new PropertyGroup[col.size()]);
        log.debug("getAllGroups: {} ", result);
        return result;
    }

    @WebMethod
    public FormElementComplex[] getProperties(@WebParam(name="token") String token, @WebParam(name="nodePath") String nodePath, @WebParam(name="grpName") String grpName) throws IOException, ParseException, NoSuchGroupException, PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("getProperties({}, {}, {})", new Object[]{token, nodePath, grpName});
        PropertyGroupModule cm = ModuleManager.getPropertyGroupModule();
        List<FormElement> col = cm.getProperties(token, nodePath, grpName);
        Object[] result = new FormElementComplex[col.size()];
        for (int i = 0; i < col.size(); ++i) {
            result[i] = FormElementComplex.toFormElementComplex(col.get(i));
        }
        log.debug("getProperties: {}", result);
        return result;
    }

    @WebMethod
    public void setProperties(@WebParam(name="token") String token, @WebParam(name="nodePath") String nodePath, @WebParam(name="grpName") String grpName, @WebParam(name="properties") FormElementComplex[] properties) throws IOException, ParseException, NoSuchPropertyException, NoSuchGroupException, LockException, PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException, ExtensionException {
        log.debug("setProperties({}, {}, {}, {})", new Object[]{token, nodePath, grpName, properties});
        PropertyGroupModule cm = ModuleManager.getPropertyGroupModule();
        ArrayList<FormElement> al = new ArrayList<FormElement>();
        for (int i = 0; i < properties.length; ++i) {
            al.add(FormElementComplex.toFormElement(properties[i]));
        }
        cm.setProperties(token, nodePath, grpName, al);
        log.debug("setProperties: void");
    }

    @WebMethod
    public void setPropertiesSimple(@WebParam(name="token") String token, @WebParam(name="nodePath") String nodePath, @WebParam(name="grpName") String grpName, @WebParam(name="properties") HashMap<String, String> properties) throws IOException, ParseException, NoSuchPropertyException, NoSuchGroupException, LockException, PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException, ExtensionException {
        log.debug("setPropertiesSimple({}, {}, {}, {})", new Object[]{token, nodePath, grpName, properties});
        PropertyGroupModule cm = ModuleManager.getPropertyGroupModule();
        ArrayList<FormElement> al = new ArrayList<FormElement>();
        for (FormElement fe : cm.getProperties(token, nodePath, grpName)) {
            String value = properties.get(fe.getName());
            if (value == null) continue;
            if (fe instanceof Input) {
                ((Input)fe).setValue(value);
            } else if (fe instanceof SuggestBox) {
                ((SuggestBox)fe).setValue(value);
            } else if (fe instanceof TextArea) {
                ((TextArea)fe).setValue(value);
            } else if (fe instanceof CheckBox) {
                ((CheckBox)fe).setValue(Boolean.valueOf(value));
            } else if (fe instanceof Select) {
                Select sel = (Select)fe;
                for (Option opt : sel.getOptions()) {
                    if (opt.equals(value)) {
                        opt.setSelected(true);
                        continue;
                    }
                    opt.setSelected(false);
                }
            }
            al.add(fe);
        }
        cm.setProperties(token, nodePath, grpName, al);
        log.debug("setPropertiesSimple: void");
    }

    @WebMethod
    public boolean hasGroup(@WebParam(name="token") String token, @WebParam(name="nodePath") String nodePath, @WebParam(name="grpName") String grpName) throws IOException, ParseException, PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("hasGroup({}, {}, {})", new Object[]{token, nodePath, grpName});
        PropertyGroupModule cm = ModuleManager.getPropertyGroupModule();
        boolean ret = cm.hasGroup(token, nodePath, grpName);
        log.debug("hasGroup: {}", (Object)ret);
        return ret;
    }
}

