/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.ws.endpoint;

import com.openkm.bean.Folder;
import com.openkm.core.AccessDeniedException;
import com.openkm.core.DatabaseException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.module.ModuleManager;
import com.openkm.module.RepositoryModule;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import org.jboss.annotation.security.SecurityDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService
@SOAPBinding(style=SOAPBinding.Style.RPC)
@SecurityDomain(value="OpenKM")
public class OKMRepository {
    private static Logger log = LoggerFactory.getLogger(OKMRepository.class);

    @WebMethod
    public Folder getRootFolder(@WebParam(name="token") String token) throws PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("getRootFolder({})", (Object)token);
        RepositoryModule rm = ModuleManager.getRepositoryModule();
        Folder root = rm.getRootFolder(token);
        log.debug("getRootFolder: {}", (Object)root);
        return root;
    }

    @WebMethod
    public Folder getTrashFolder(@WebParam(name="token") String token) throws PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("getTrashFolder({})", (Object)token);
        RepositoryModule rm = ModuleManager.getRepositoryModule();
        Folder trash = rm.getTrashFolder(token);
        log.debug("getTrashFolder: {}", (Object)trash);
        return trash;
    }

    @WebMethod
    public Folder getTemplatesFolder(@WebParam(name="token") String token) throws PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("getTemplatesFolder({})", (Object)token);
        RepositoryModule rm = ModuleManager.getRepositoryModule();
        Folder templatesFolder = rm.getTemplatesFolder(token);
        log.debug("getTemplatesFolder: {}", (Object)templatesFolder);
        return templatesFolder;
    }

    @WebMethod
    public Folder getPersonalFolder(@WebParam(name="token") String token) throws PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("getPersonalFolder({})", (Object)token);
        RepositoryModule rm = ModuleManager.getRepositoryModule();
        Folder personalFolder = rm.getPersonalFolder(token);
        log.debug("getPersonalFolder: {}", (Object)personalFolder);
        return personalFolder;
    }

    @WebMethod
    public Folder getMailFolder(@WebParam(name="token") String token) throws PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("getMailFolder({})", (Object)token);
        RepositoryModule rm = ModuleManager.getRepositoryModule();
        Folder mailFolder = rm.getMailFolder(token);
        log.debug("getMailFolder: {}", (Object)mailFolder);
        return mailFolder;
    }

    @WebMethod
    public Folder getThesaurusFolder(@WebParam(name="token") String token) throws PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("getThesaurusFolder({})", (Object)token);
        RepositoryModule rm = ModuleManager.getRepositoryModule();
        Folder thesaurusFolder = rm.getThesaurusFolder(token);
        log.debug("getThesaurusFolder: {}", (Object)thesaurusFolder);
        return thesaurusFolder;
    }

    @WebMethod
    public Folder getCategoriesFolder(@WebParam(name="token") String token) throws PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("getCategoriesFolder({})", (Object)token);
        RepositoryModule rm = ModuleManager.getRepositoryModule();
        Folder categoriesFolder = rm.getCategoriesFolder(token);
        log.debug("getCategoriesFolder: {}", (Object)categoriesFolder);
        return categoriesFolder;
    }

    @WebMethod
    public void purgeTrash(@WebParam(name="token") String token) throws AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("purgeTrash({})", (Object)token);
        RepositoryModule rm = ModuleManager.getRepositoryModule();
        rm.purgeTrash(token);
        log.debug("purgeTrash: void");
    }

    @WebMethod
    public boolean hasNode(@WebParam(name="token") String token, @WebParam(name="path") String path) throws RepositoryException, DatabaseException {
        log.debug("hasNode({}, {})", (Object)token, (Object)path);
        RepositoryModule rm = ModuleManager.getRepositoryModule();
        boolean ret = rm.hasNode(token, path);
        log.debug("hasNode: {}", (Object)ret);
        return ret;
    }

    @WebMethod
    public String getNodePath(@WebParam(name="token") String token, @WebParam(name="uuid") String uuid) throws PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("getNodePath({}, {})", (Object)token, (Object)uuid);
        RepositoryModule rm = ModuleManager.getRepositoryModule();
        String path = rm.getNodePath(token, uuid);
        log.debug("getNodePath: {}", (Object)path);
        return path;
    }

    @WebMethod
    public String getNodeUuid(@WebParam(name="token") String token, @WebParam(name="path") String path) throws PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("getNodeUuid({}, {})", (Object)token, (Object)path);
        RepositoryModule rm = ModuleManager.getRepositoryModule();
        String uuid = rm.getNodePath(token, path);
        log.debug("getNodeUuid: {}", (Object)uuid);
        return path;
    }
}

