/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.ws.endpoint;

import com.openkm.bean.Document;
import com.openkm.bean.QueryResult;
import com.openkm.core.AccessDeniedException;
import com.openkm.core.DatabaseException;
import com.openkm.core.ParseException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.dao.bean.QueryParams;
import com.openkm.module.ModuleManager;
import com.openkm.module.SearchModule;
import com.openkm.ws.util.IntegerPair;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import org.jboss.annotation.security.SecurityDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService
@SOAPBinding(style=SOAPBinding.Style.RPC)
@SecurityDomain(value="OpenKM")
public class OKMSearch {
    private static Logger log = LoggerFactory.getLogger(OKMSearch.class);

    @WebMethod
    public QueryResult[] findByContent(@WebParam(name="token") String token, @WebParam(name="content") String content) throws IOException, ParseException, RepositoryException, DatabaseException {
        log.debug("findByContent({}, {})", (Object)token, (Object)content);
        SearchModule sm = ModuleManager.getSearchModule();
        List<QueryResult> col = sm.findByContent(token, content);
        Object[] result = col.toArray(new QueryResult[col.size()]);
        log.debug("findByContent: {}", result);
        return result;
    }

    @WebMethod
    public QueryResult[] findByName(@WebParam(name="token") String token, @WebParam(name="name") String name) throws IOException, ParseException, RepositoryException, DatabaseException {
        log.debug("findByName({}, {})", (Object)token, (Object)name);
        SearchModule sm = ModuleManager.getSearchModule();
        List<QueryResult> col = sm.findByName(token, name);
        Object[] result = col.toArray(new QueryResult[col.size()]);
        log.debug("findByName: {}", result);
        return result;
    }

    @WebMethod
    public QueryResult[] findByKeywords(@WebParam(name="token") String token, @WebParam(name="keywords") String[] keywords) throws IOException, ParseException, RepositoryException, DatabaseException {
        log.debug("findByKeywords({}, {})", (Object)token, (Object)keywords);
        SearchModule sm = ModuleManager.getSearchModule();
        HashSet<String> set = new HashSet<String>(Arrays.asList(keywords));
        List<QueryResult> col = sm.findByKeywords(token, set);
        Object[] result = col.toArray(new QueryResult[col.size()]);
        log.debug("findByKeywords: {}", result);
        return result;
    }

    @WebMethod
    public QueryResult[] findByStatement(@WebParam(name="token") String token, @WebParam(name="statement") String statement, @WebParam(name="type") String type) throws RepositoryException, DatabaseException {
        log.debug("findByStatement({}, {}, {})", new Object[]{token, statement, type});
        SearchModule sm = ModuleManager.getSearchModule();
        List<QueryResult> col = sm.findByStatement(token, statement, type);
        Object[] result = col.toArray(new QueryResult[col.size()]);
        log.debug("findByStatement: {}", result);
        return result;
    }

    @WebMethod
    public QueryResult[] find(@WebParam(name="token") String token, @WebParam(name="params") QueryParams params) throws IOException, ParseException, RepositoryException, DatabaseException {
        log.debug("find({}, {})", (Object)token, (Object)params);
        SearchModule sm = ModuleManager.getSearchModule();
        List<QueryResult> col = sm.find(token, params);
        Object[] result = col.toArray(new QueryResult[col.size()]);
        log.debug("find: {}", result);
        return result;
    }

    @WebMethod
    public long findCount(@WebParam(name="token") String token, @WebParam(name="params") QueryParams params) throws IOException, ParseException, RepositoryException, DatabaseException {
        log.debug("findCount({}, {})", (Object)token, (Object)params);
        SearchModule sm = ModuleManager.getSearchModule();
        long count = sm.findCount(token, params);
        log.debug("findCount: {}", (Object)count);
        return count;
    }

    @WebMethod
    public IntegerPair[] getKeywordMap(@WebParam(name="token") String token, @WebParam(name="filter") String[] filter) throws RepositoryException, DatabaseException {
        log.debug("getKeywordMap({}, {})", (Object)token, (Object)filter);
        SearchModule sm = ModuleManager.getSearchModule();
        List<String> alFilter = Arrays.asList(filter);
        Map<String, Integer> map = sm.getKeywordMap(token, alFilter);
        Set<String> keys = map.keySet();
        Object[] result = new IntegerPair[keys.size()];
        int i = 0;
        for (String key : keys) {
            IntegerPair p = new IntegerPair();
            p.setKey(key);
            p.setValue(map.get(key));
            result[i++] = p;
        }
        log.debug("getKeywordMap: {}", result);
        return result;
    }

    @WebMethod
    public Document[] getCategorizedDocuments(@WebParam(name="token") String token, @WebParam(name="categoryId") String categoryId) throws RepositoryException, DatabaseException {
        log.debug("getCategorizedDocuments({}, {})", (Object)token, (Object)categoryId);
        SearchModule sm = ModuleManager.getSearchModule();
        List<Document> col = sm.getCategorizedDocuments(token, categoryId);
        Object[] result = col.toArray(new Document[col.size()]);
        log.debug("getCategorizedDocuments: {}", result);
        return result;
    }

    @WebMethod
    public int saveSearch(@WebParam(name="token") String token, @WebParam(name="params") QueryParams params) throws AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("saveSearch({}, {})", (Object)token, (Object)params);
        SearchModule sm = ModuleManager.getSearchModule();
        int id = sm.saveSearch(token, params);
        log.debug("saveSearch: {}", (Object)id);
        return id;
    }

    @WebMethod
    public void updateSearch(@WebParam(name="token") String token, @WebParam(name="params") QueryParams params) throws AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("updateSearch({}, {})", (Object)token, (Object)params);
        SearchModule sm = ModuleManager.getSearchModule();
        sm.saveSearch(token, params);
        log.debug("updateSearch: void");
    }

    @WebMethod
    public QueryParams getSearch(@WebParam(name="token") String token, @WebParam(name="qpId") int qpId) throws PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("getSearch({}, {})", (Object)token, (Object)qpId);
        SearchModule sm = ModuleManager.getSearchModule();
        QueryParams qp = sm.getSearch(token, qpId);
        log.debug("getSearch: {}", (Object)qp);
        return qp;
    }

    @WebMethod
    public QueryParams[] getAllSearchs(@WebParam(name="token") String token) throws RepositoryException, DatabaseException {
        log.debug("getAllSearchs({})", (Object)token);
        SearchModule sm = ModuleManager.getSearchModule();
        List<QueryParams> col = sm.getAllSearchs(token);
        QueryParams[] result = col.toArray(new QueryParams[col.size()]);
        log.debug("getAllSearchs: {}", col);
        return result;
    }

    @WebMethod
    public void deleteSearch(@WebParam(name="token") String token, @WebParam(name="qpId") int qpId) throws AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("deleteSearch({}, {})", (Object)token, (Object)qpId);
        SearchModule sm = ModuleManager.getSearchModule();
        sm.deleteSearch(token, qpId);
        log.debug("deleteSearch: void");
    }
}

