/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.ws.endpoint;

import com.openkm.bean.form.FormElement;
import com.openkm.bean.workflow.ProcessDefinition;
import com.openkm.bean.workflow.ProcessInstance;
import com.openkm.bean.workflow.TaskInstance;
import com.openkm.bean.workflow.Token;
import com.openkm.core.DatabaseException;
import com.openkm.core.ParseException;
import com.openkm.core.RepositoryException;
import com.openkm.core.WorkflowException;
import com.openkm.module.ModuleManager;
import com.openkm.module.WorkflowModule;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import org.apache.commons.io.IOUtils;
import org.jboss.annotation.security.SecurityDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService
@SOAPBinding(style=SOAPBinding.Style.RPC)
@SecurityDomain(value="OpenKM")
public class OKMWorkflow {
    private static Logger log = LoggerFactory.getLogger(OKMWorkflow.class);

    @WebMethod
    public void registerProcessDefinition(@WebParam(name="token") String token, @WebParam(name="pda") byte[] pda) throws ParseException, RepositoryException, DatabaseException, WorkflowException, IOException {
        log.debug("registerProcessDefinition({}, {})", (Object)token, (Object)pda);
        ByteArrayInputStream bais = new ByteArrayInputStream(pda);
        WorkflowModule wm = ModuleManager.getWorkflowModule();
        wm.registerProcessDefinition(token, bais);
        IOUtils.closeQuietly((InputStream)bais);
        log.debug("registerProcessDefinition: void");
    }

    @WebMethod
    public void deleteProcessDefinition(@WebParam(name="token") String token, @WebParam(name="pdId") long pdId) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("deleteProcessDefinition({}, {})", (Object)token, (Object)pdId);
        WorkflowModule wm = ModuleManager.getWorkflowModule();
        wm.deleteProcessDefinition(token, pdId);
        log.debug("deleteProcessDefinition: void");
    }

    @WebMethod
    public ProcessDefinition getProcessDefinition(@WebParam(name="token") String token, @WebParam(name="pdId") long pdId) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("getProcessDefinition({}, {})", (Object)token, (Object)pdId);
        WorkflowModule wm = ModuleManager.getWorkflowModule();
        ProcessDefinition result = wm.getProcessDefinition(token, pdId);
        log.debug("getProcessDefinition: {}", (Object)result);
        return result;
    }

    @WebMethod
    public byte[] getProcessDefinitionImage(@WebParam(name="token") String token, @WebParam(name="pdId") long pdId, @WebParam(name="node") String node) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("getProcessDefinitionImage({}, {}, {})", new Object[]{token, pdId, node});
        WorkflowModule wm = ModuleManager.getWorkflowModule();
        byte[] result = wm.getProcessDefinitionImage(token, pdId, node);
        log.debug("getProcessDefinitionImage: {}", (Object)result);
        return result;
    }

    private void repaireProcessInstance(ProcessInstance result) {
        if (result == null) {
            return;
        }
        if (result.getVariables() == null) {
            return;
        }
        HashMap<String, Object> r = new HashMap<String, Object>();
        for (Map.Entry<String, Object> e : result.getVariables().entrySet()) {
            r.put(e.getKey(), e.getValue() != null ? e.getValue().toString() : null);
        }
        result.setVariables(r);
    }

    @WebMethod
    public ProcessInstance runProcessDefinition(@WebParam(name="token") String token, @WebParam(name="pdId") long pdId, @WebParam(name="uuid") String uuid, @WebParam(name="vars") FormElement[] vars) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("runProcessDefinition({}, {}, {}, {})", new Object[]{token, pdId, uuid, vars});
        WorkflowModule wm = ModuleManager.getWorkflowModule();
        List<FormElement> col = Arrays.asList(vars);
        ProcessInstance result = wm.runProcessDefinition(token, pdId, uuid, col);
        this.repaireProcessInstance(result);
        log.debug("runProcessDefinition: {}", (Object)result);
        return result;
    }

    @WebMethod
    public ProcessInstance sendProcessInstanceSignal(@WebParam(name="token") String token, @WebParam(name="piId") long piId, @WebParam(name="transName") String transName) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("sendProcessInstanceSignal({}, {}, {})", new Object[]{token, piId, transName});
        WorkflowModule wm = ModuleManager.getWorkflowModule();
        ProcessInstance result = wm.sendProcessInstanceSignal(token, piId, transName);
        this.repaireProcessInstance(result);
        log.debug("sendProcessInstanceSignal: {}", (Object)result);
        return result;
    }

    @WebMethod
    public void endProcessInstance(@WebParam(name="token") String token, @WebParam(name="piId") long piId) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("endProcessInstance({}, {})", (Object)token, (Object)piId);
        WorkflowModule wm = ModuleManager.getWorkflowModule();
        wm.endProcessInstance(token, piId);
        log.debug("endProcessInstance: void");
    }

    @WebMethod
    public void deleteProcessInstance(@WebParam(name="token") String token, @WebParam(name="piId") long piId) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("deleteProcessInstance({}, {})", (Object)token, (Object)piId);
        WorkflowModule wm = ModuleManager.getWorkflowModule();
        wm.deleteProcessInstance(token, piId);
        log.debug("deleteProcessInstance: void");
    }

    @WebMethod
    public ProcessInstance[] findProcessInstances(@WebParam(name="token") String token, @WebParam(name="pdId") long pdId) throws RepositoryException, DatabaseException, WorkflowException {
        Object[] result;
        log.debug("findProcessInstances({}, {})", (Object)token, (Object)pdId);
        WorkflowModule wm = ModuleManager.getWorkflowModule();
        List<ProcessInstance> col = wm.findProcessInstances(token, pdId);
        for (ProcessInstance processInstance : result = col.toArray(new ProcessInstance[col.size()])) {
            this.repaireProcessInstance(processInstance);
        }
        log.debug("findProcessInstances: {}", result);
        return result;
    }

    @WebMethod
    public ProcessDefinition[] findAllProcessDefinitions(@WebParam(name="token") String token) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("findAllProcessDefinitions({})", (Object)token);
        WorkflowModule wm = ModuleManager.getWorkflowModule();
        List<ProcessDefinition> col = wm.findAllProcessDefinitions(token);
        Object[] result = col.toArray(new ProcessDefinition[col.size()]);
        log.debug("findAllProcessDefinitions: {}", result);
        return result;
    }

    @WebMethod
    public ProcessDefinition[] findLatestProcessDefinitions(@WebParam(name="token") String token) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("findLatestProcessDefinitions({})", (Object)token);
        WorkflowModule wm = ModuleManager.getWorkflowModule();
        List<ProcessDefinition> col = wm.findLatestProcessDefinitions(token);
        Object[] result = col.toArray(new ProcessDefinition[col.size()]);
        log.debug("findLatestProcessDefinitions: {}", result);
        return result;
    }

    @WebMethod
    public ProcessDefinition[] findAllProcessDefinitionVersions(@WebParam(name="token") String token, @WebParam(name="name") String name) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("findAllProcessDefinitionVersions({}, {})", (Object)token, (Object)name);
        WorkflowModule wm = ModuleManager.getWorkflowModule();
        List<ProcessDefinition> col = wm.findAllProcessDefinitionVersions(token, name);
        Object[] result = col.toArray(new ProcessDefinition[col.size()]);
        log.debug("findAllProcessDefinitionVersions: {}", result);
        return result;
    }

    @WebMethod
    public ProcessInstance getProcessInstance(@WebParam(name="token") String token, @WebParam(name="piId") long piId) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("getProcessInstance({}, {})", (Object)token, (Object)piId);
        WorkflowModule wm = ModuleManager.getWorkflowModule();
        ProcessInstance result = wm.getProcessInstance(token, piId);
        this.repaireProcessInstance(result);
        log.debug("getProcessInstance: {}", (Object)result);
        return result;
    }

    @WebMethod
    public void suspendProcessInstance(@WebParam(name="token") String token, @WebParam(name="piId") long piId) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("suspendProcessInstance({}, {})", (Object)token, (Object)piId);
        WorkflowModule wm = ModuleManager.getWorkflowModule();
        wm.suspendProcessInstance(token, piId);
        log.debug("suspendProcessInstance: void");
    }

    @WebMethod
    public void resumeProcessInstance(@WebParam(name="token") String token, @WebParam(name="piId") long piId) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("resumeProcessInstance({}, {})", (Object)token, (Object)piId);
        WorkflowModule wm = ModuleManager.getWorkflowModule();
        wm.resumeProcessInstance(token, piId);
        log.debug("resumeProcessInstance: void");
    }

    @WebMethod
    public void addProcessInstanceVariable(@WebParam(name="token") String token, @WebParam(name="piId") long piId, @WebParam(name="name") String name, @WebParam(name="value") Object value) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("addProcessInstanceVariable({}, {}, {}, {})", new Object[]{token, piId, name, value});
        WorkflowModule wm = ModuleManager.getWorkflowModule();
        wm.addProcessInstanceVariable(token, piId, name, value);
        log.debug("addProcessInstanceVariable: void");
    }

    @WebMethod
    public void deleteProcessInstanceVariable(@WebParam(name="token") String token, @WebParam(name="piId") long piId, @WebParam(name="name") String name) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("deleteProcessInstanceVariable({}, {}, {})", new Object[]{token, piId, name});
        WorkflowModule wm = ModuleManager.getWorkflowModule();
        wm.deleteProcessInstanceVariable(token, piId, name);
        log.debug("deleteProcessInstanceVariable: void");
    }

    @WebMethod
    public TaskInstance[] findUserTaskInstances(@WebParam(name="token") String token) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("findUserTaskInstances({})", (Object)token);
        WorkflowModule wm = ModuleManager.getWorkflowModule();
        List<TaskInstance> col = wm.findUserTaskInstances(token);
        Object[] result = col.toArray(new TaskInstance[col.size()]);
        log.debug("findUserTaskInstances: {}", result);
        return result;
    }

    @WebMethod
    public TaskInstance[] findPooledTaskInstances(@WebParam(name="token") String token) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("findPooledTaskInstances({})", (Object)token);
        WorkflowModule wm = ModuleManager.getWorkflowModule();
        List<TaskInstance> col = wm.findPooledTaskInstances(token);
        Object[] result = col.toArray(new TaskInstance[col.size()]);
        log.debug("findPooledTaskInstances: {}", result);
        return result;
    }

    @WebMethod
    public TaskInstance[] findTaskInstances(@WebParam(name="token") String token, @WebParam(name="piId") long piId) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("findTaskInstances({}, {})", (Object)token, (Object)piId);
        WorkflowModule wm = ModuleManager.getWorkflowModule();
        List<TaskInstance> col = wm.findTaskInstances(token, piId);
        Object[] result = col.toArray(new TaskInstance[col.size()]);
        log.debug("findTaskInstances: {}", result);
        return result;
    }

    @WebMethod
    public void setTaskInstanceValues(@WebParam(name="token") String token, @WebParam(name="tiId") long tiId, @WebParam(name="transName") String transName, @WebParam(name="values") FormElement[] values) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("setTaskInstanceValues({}, {}, {}, {})", new Object[]{token, tiId, transName, values});
        WorkflowModule wm = ModuleManager.getWorkflowModule();
        List<FormElement> col = Arrays.asList(values);
        wm.setTaskInstanceValues(token, tiId, transName, col);
        log.debug("setTaskInstanceValues: void");
    }

    @WebMethod
    public void addTaskInstanceComment(@WebParam(name="token") String token, @WebParam(name="tiId") long tiId, @WebParam(name="message") String message) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("addTaskInstanceComment({}, {}, {})", new Object[]{token, tiId, message});
        WorkflowModule wm = ModuleManager.getWorkflowModule();
        wm.addTaskInstanceComment(token, tiId, message);
        log.debug("addTaskInstanceComment: void");
    }

    @WebMethod
    public TaskInstance getTaskInstance(@WebParam(name="token") String token, @WebParam(name="tiId") long tiId) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("getTaskInstance({}, {})", (Object)token, (Object)tiId);
        WorkflowModule wm = ModuleManager.getWorkflowModule();
        TaskInstance result = wm.getTaskInstance(token, tiId);
        log.debug("getTaskInstance: {}", (Object)result);
        return result;
    }

    @WebMethod
    public void setTaskInstanceActorId(@WebParam(name="token") String token, @WebParam(name="tiId") long tiId, @WebParam(name="actorId") String actorId) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("setTaskInstanceActorId({}, {}, {})", new Object[]{token, tiId, actorId});
        WorkflowModule wm = ModuleManager.getWorkflowModule();
        wm.setTaskInstanceActorId(token, tiId, actorId);
        log.debug("setTaskInstanceActorId: void");
    }

    @WebMethod
    public void addTaskInstanceVariable(@WebParam(name="token") String token, @WebParam(name="tiId") long tiId, @WebParam(name="name") String name, @WebParam(name="value") Object value) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("addTaskInstanceVariable({}, {}, {}, {})", new Object[]{token, tiId, name, value});
        WorkflowModule wm = ModuleManager.getWorkflowModule();
        wm.addTaskInstanceVariable(token, tiId, name, value);
        log.debug("addTaskInstanceVariable: void");
    }

    @WebMethod
    public void deleteTaskInstanceVariable(@WebParam(name="token") String token, @WebParam(name="tiId") long tiId, @WebParam(name="name") String name) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("deleteTaskInstanceVariable({}, {}, {})", new Object[]{token, tiId, name});
        WorkflowModule wm = ModuleManager.getWorkflowModule();
        wm.deleteTaskInstanceVariable(token, tiId, name);
        log.debug("deleteTaskInstanceVariable: void");
    }

    @WebMethod
    public void startTaskInstance(@WebParam(name="token") String token, @WebParam(name="tiId") long tiId) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("startTaskInstance({}, {})", (Object)token, (Object)tiId);
        WorkflowModule wm = ModuleManager.getWorkflowModule();
        wm.startTaskInstance(token, tiId);
        log.debug("startTaskInstance: void");
    }

    @WebMethod
    public void endTaskInstance(@WebParam(name="token") String token, @WebParam(name="tiId") long tiId, @WebParam(name="transName") String transName) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("endTaskInstance({}, {}, {})", new Object[]{token, tiId, transName});
        WorkflowModule wm = ModuleManager.getWorkflowModule();
        wm.endTaskInstance(token, tiId, transName);
        log.debug("endTaskInstance: void");
    }

    @WebMethod
    public void suspendTaskInstance(@WebParam(name="token") String token, @WebParam(name="tiId") long tiId) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("suspendTaskInstance({}, {})", (Object)token, (Object)tiId);
        WorkflowModule wm = ModuleManager.getWorkflowModule();
        wm.suspendTaskInstance(token, tiId);
        log.debug("suspendTaskInstance: void");
    }

    @WebMethod
    public void resumeTaskInstance(@WebParam(name="token") String token, @WebParam(name="tiId") long tiId) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("resumeTaskInstance({}, {})", (Object)token, (Object)tiId);
        WorkflowModule wm = ModuleManager.getWorkflowModule();
        wm.resumeTaskInstance(token, tiId);
        log.debug("resumeTaskInstance: void");
    }

    @WebMethod
    public Token getToken(@WebParam(name="token") String token, @WebParam(name="tkId") long tkId) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("getToken({}, {})", (Object)token, (Object)tkId);
        WorkflowModule wm = ModuleManager.getWorkflowModule();
        Token result = wm.getToken(token, tkId);
        log.debug("getToken: {}", (Object)result);
        return result;
    }

    @WebMethod
    public void addTokenComment(@WebParam(name="token") String token, @WebParam(name="tkId") long tkId, @WebParam(name="message") String message) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("addTokenComment({}, {}, {})", new Object[]{token, tkId, message});
        WorkflowModule wm = ModuleManager.getWorkflowModule();
        wm.addTokenComment(token, tkId, message);
        log.debug("addTokenComment: void");
    }

    @WebMethod
    public void suspendToken(@WebParam(name="token") String token, @WebParam(name="tkId") long tkId) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("suspendToken({}, {})", (Object)token, (Object)tkId);
        WorkflowModule wm = ModuleManager.getWorkflowModule();
        wm.suspendToken(token, tkId);
        log.debug("suspendToken: void");
    }

    @WebMethod
    public void resumeToken(@WebParam(name="token") String token, @WebParam(name="tkId") long tkId) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("resumeToken({}, {})", (Object)token, (Object)tkId);
        WorkflowModule wm = ModuleManager.getWorkflowModule();
        wm.resumeToken(token, tkId);
        log.debug("resumeToken: void");
    }

    @WebMethod
    public Token sendTokenSignal(@WebParam(name="token") String token, @WebParam(name="tkId") long tkId, @WebParam(name="transName") String transName) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("sendTokenSignal({}, {}, {})", new Object[]{token, tkId, transName});
        WorkflowModule wm = ModuleManager.getWorkflowModule();
        Token result = wm.sendTokenSignal(token, tkId, transName);
        log.debug("sendTokenSignal: {}", (Object)result);
        return result;
    }

    @WebMethod
    public void setTokenNode(@WebParam(name="token") String token, @WebParam(name="tkId") long tkId, @WebParam(name="nodeName") String nodeName) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("setTokenNode({}, {}, {})", new Object[]{token, tkId, nodeName});
        WorkflowModule wm = ModuleManager.getWorkflowModule();
        wm.setTokenNode(token, tkId, nodeName);
        log.debug("setTokenNode: void");
    }

    @WebMethod
    public void endToken(@WebParam(name="token") String token, @WebParam(name="tkId") long tkId) throws RepositoryException, DatabaseException, WorkflowException {
        log.debug("endToken({}, {})", (Object)token, (Object)tkId);
        WorkflowModule wm = ModuleManager.getWorkflowModule();
        wm.endToken(token, tkId);
        log.debug("endToken: void");
    }
}

