/*
 * Decompiled with CFR 0.152.
 */
package cz.solnet.activityLogger;

import cz.solnet.activityLogger.ServiceLocator;
import cz.solnet.activityLogger.ServiceLocatorException;
import java.io.Serializable;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityProducer {
    private static Logger log = LoggerFactory.getLogger(ActivityProducer.class);
    private ConnectionFactory connectionFactory = null;
    private Session session = null;
    private Destination destination = null;
    private MessageProducer messageProducer = null;
    private Connection connection = null;
    private boolean initialized = false;

    public boolean isInitialized() {
        return this.initialized;
    }

    public void init(String cfJndiName, String dstJndiName) {
        log.debug("Initializing JMS producer ({}, {})", (Object)cfJndiName, (Object)dstJndiName);
        if (this.initialized) {
            log.warn("Already initialized");
            return;
        }
        try {
            log.debug("Creating connection factory");
            this.connectionFactory = ServiceLocator.getJmsConnectionFactory(cfJndiName);
            log.debug("Getting connection");
            this.connection = this.connectionFactory.createConnection();
            log.debug("Creating session");
            this.session = this.connection.createSession(false, 1);
            log.debug("Looking up destionation");
            this.destination = ServiceLocator.getJmsDestination(dstJndiName);
            log.debug("Creating message producer");
            this.messageProducer = this.session.createProducer(this.destination);
            this.initialized = true;
        }
        catch (JMSException je) {
            log.error("Error when initializing JMS producer", (Throwable)je);
        }
        catch (ServiceLocatorException sle) {
            log.error("Error when initializing JMS producer", (Throwable)sle);
        }
    }

    public void send(String txtMessage) {
        log.debug("Sending message: {}", (Object)txtMessage);
        if (!this.isInitialized()) {
            log.warn("Not initialized");
            return;
        }
        try {
            TextMessage message = this.session.createTextMessage(txtMessage);
            this.messageProducer.send((Message)message);
            log.debug("Message sent ({})", (Object)txtMessage);
        }
        catch (JMSException je) {
            String errMsg = String.format("Error when sending message (%1$s)", txtMessage);
            log.error(errMsg, (Throwable)je);
        }
    }

    public void send(Serializable message) {
        if (message == null) {
            log.warn("Cannot send null message");
            return;
        }
        try {
            ObjectMessage objectMessage = this.session.createObjectMessage(message);
            this.messageProducer.send((Message)objectMessage);
            log.debug("Message sent ({})", (Object)message);
        }
        catch (JMSException je) {
            String errMsg = String.format("Error when sending message (%1$s)", message);
            log.error(errMsg, (Throwable)je);
        }
    }

    public void close() {
        log.debug("Closing JMS producer");
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception e) {
                log.warn("Cannot close connection");
            }
        }
        this.initialized = false;
    }
}

