/*
 * Decompiled with CFR 0.152.
 */
package cz.solnet.jbpm.custom;

import com.openkm.core.Config;
import com.openkm.workflow.AddressResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmException;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.jpdl.el.ELException;
import org.jbpm.jpdl.el.FunctionMapper;
import org.jbpm.jpdl.el.VariableResolver;
import org.jbpm.jpdl.el.impl.JbpmExpressionEvaluator;
import org.jbpm.taskmgmt.exe.PooledActor;
import org.jbpm.util.ClassLoaderUtil;
import org.jbpm.util.XmlUtil;
import org.w3c.dom.Element;

public class Mail
implements ActionHandler {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(Mail.class);
    private static long lastTemplateModification;
    static Map<String, Properties> templates;
    static Map<String, String> templateVariables;
    String fromAddress = null;
    String template = null;
    String actors = null;
    String to = null;
    String bcc = null;
    String bccActors = null;
    String subject = null;
    String text = null;
    Properties headers = null;
    ExecutionContext executionContext = null;

    public Mail() {
    }

    public Mail(String template, String actors, String to, String subject, String text) {
        this.template = template;
        this.actors = actors;
        this.to = to;
        this.subject = subject;
        this.text = text;
    }

    public Mail(String template, String actors, String to, String bccActors, String bcc, String subject, String text) {
        this.template = template;
        this.actors = actors;
        this.to = to;
        this.bccActors = bccActors;
        this.bcc = bcc;
        this.subject = subject;
        this.text = text;
    }

    public void execute(ExecutionContext executionContext) {
        this.executionContext = executionContext;
        this.send();
    }

    public List<String> getRecipients() {
        String evaluatedActors;
        List<String> tokenizedActors;
        ArrayList<String> recipients = new ArrayList<String>();
        if (this.actors != null && (tokenizedActors = this.tokenize(evaluatedActors = this.evaluate(this.actors))) != null) {
            recipients.addAll(this.resolveAddresses(tokenizedActors));
        }
        if (this.to != null) {
            String resolvedTo = this.evaluate(this.to);
            recipients.addAll(this.tokenize(resolvedTo));
        }
        return recipients;
    }

    public List<String> getBccRecipients() {
        String evaluatedActors;
        List<String> tokenizedActors;
        ArrayList<String> recipients = new ArrayList<String>();
        if (this.bccActors != null && (tokenizedActors = this.tokenize(evaluatedActors = this.evaluate(this.bccActors))) != null) {
            recipients.addAll(this.resolveAddresses(tokenizedActors));
        }
        if (this.bcc != null) {
            String resolvedTo = this.evaluate(this.bcc);
            recipients.addAll(this.tokenize(resolvedTo));
        }
        if (JbpmConfiguration.Configs.hasObject((String)"jbpm.mail.bcc.address")) {
            recipients.addAll(this.tokenize(JbpmConfiguration.Configs.getString((String)"jbpm.mail.bcc.address")));
        }
        return recipients;
    }

    public String getSubject() {
        if (this.subject == null) {
            return null;
        }
        return this.evaluate(this.subject);
    }

    public String getText() {
        if (this.text == null) {
            return null;
        }
        return this.evaluate(this.text);
    }

    public Properties getHeaders() {
        if (this.headers == null) {
            return null;
        }
        Properties properties = new Properties();
        for (String string : this.headers.keySet()) {
            String value = this.headers.getProperty(string);
            String evalValue = this.evaluate(value);
            properties.setProperty(string, evalValue);
        }
        return properties;
    }

    public String getFromAddress() {
        if (this.fromAddress != null && !this.fromAddress.equals("")) {
            return this.evaluate(this.fromAddress);
        }
        if (JbpmConfiguration.Configs.hasObject((String)"jbpm.mail.from.address")) {
            return JbpmConfiguration.Configs.getString((String)"jbpm.mail.from.address");
        }
        return "jbpm@noreply";
    }

    public void send() {
        if (this.template != null) {
            Properties properties = Mail.getMailTemplateProperties(this.template);
            if (properties == null) {
                throw new JbpmException("Cannot send email - no template '" + this.template + "' found");
            }
            this.fromAddress = properties.getProperty("fromAddress");
            this.actors = properties.getProperty("actors");
            this.to = properties.getProperty("to");
            this.subject = properties.getProperty("subject");
            this.text = properties.getProperty("text");
            this.bcc = properties.getProperty("bcc");
            this.bccActors = properties.getProperty("bccActors");
            this.headers = (Properties)properties.get("headers");
        }
        Mail.send(this.getMailServerProperties(), this.getFromAddress(), this.getRecipients(), this.getBccRecipients(), this.getSubject(), this.getText(), this.getHeaders());
    }

    public static void send(Properties mailServerProperties, String fromAddress, List<String> recipients, String subject, String text) {
        Mail.send(mailServerProperties, fromAddress, recipients, null, subject, text, null);
    }

    public static void send(Properties mailServerProperties, String fromAddress, List<String> recipients, List<String> bccRecipients, String subject, String text, Properties headers) {
        if ((recipients == null || recipients.isEmpty()) && (bccRecipients == null || bccRecipients.isEmpty())) {
            log.debug((Object)"skipping mail because there are no recipients");
            return;
        }
        try {
            for (int retries = 5; 0 < retries; --retries) {
                try {
                    Mail.sendMailInternal(mailServerProperties, fromAddress, recipients, bccRecipients, subject, text, headers);
                    break;
                }
                catch (MessagingException msgex) {
                    if (retries == 0) {
                        throw msgex;
                    }
                    System.out.println("Cannot send mail, now retrying: " + (Object)((Object)msgex));
                    log.error((Object)("Cannot send mail, now retrying: " + (Object)((Object)msgex)));
                    Thread.sleep(1000L);
                    continue;
                }
            }
        }
        catch (Exception e) {
            throw new JbpmException("Cannot send email", (Throwable)e);
        }
    }

    private static void sendMailInternal(Properties mailServerProperties, String fromAddress, List<String> recipients, List<String> bccRecipients, String subject, String text, Properties headers) throws Exception {
        log.debug((Object)("sending email to '" + recipients + "' " + (bccRecipients != null ? "and in bcc to '" + bccRecipients + "' " : "") + "about '" + subject + "'"));
        Session session = Session.getDefaultInstance((Properties)mailServerProperties, null);
        MimeMessage message = new MimeMessage(session);
        if (fromAddress != null) {
            message.setFrom((Address)new InternetAddress(fromAddress));
        }
        for (String address : recipients) {
            InternetAddress recipient = new InternetAddress(address);
            message.addRecipient(Message.RecipientType.TO, (Address)recipient);
        }
        String headersString = null;
        if (headers != null) {
            int i = 0;
            StringBuffer sb = new StringBuffer();
            Iterator<Object> iter = headers.keySet().iterator();
            while (iter.hasNext()) {
                if (i > 0) {
                    sb.append(", ");
                }
                String key = (String)iter.next();
                String value = headers.getProperty(key);
                message.addHeader(key, value);
                sb.append(key);
                sb.append("=");
                sb.append(value);
                ++i;
            }
            headersString = sb.toString();
        }
        log.debug((Object)("email headers: " + headersString));
        if (bccRecipients != null) {
            for (String address : bccRecipients) {
                InternetAddress recipient = new InternetAddress(address);
                message.addRecipient(Message.RecipientType.BCC, (Address)recipient);
            }
        }
        if (subject != null) {
            message.setSubject(subject);
        }
        if (text != null) {
            message.setText(text);
        }
        message.setSentDate(new Date());
        Transport.send((Message)message);
    }

    protected List<String> tokenize(String text) {
        if (text == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(text, ";:");
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        return list;
    }

    protected Collection<String> resolveAddresses(List<String> actorIds) {
        ArrayList<String> emailAddresses = new ArrayList<String>();
        for (String actorId : actorIds) {
            AddressResolver addressResolver = (AddressResolver)JbpmConfiguration.Configs.getObject((String)"jbpm.mail.address.resolver");
            Object resolvedAddresses = addressResolver.resolveAddress(actorId);
            if (resolvedAddresses == null) continue;
            if (resolvedAddresses instanceof String) {
                emailAddresses.add((String)resolvedAddresses);
                continue;
            }
            if (resolvedAddresses instanceof Collection) {
                Collection tmpCollection = (Collection)resolvedAddresses;
                emailAddresses.addAll(tmpCollection);
                continue;
            }
            if (resolvedAddresses instanceof String[]) {
                emailAddresses.addAll(Arrays.asList((String[])resolvedAddresses));
                continue;
            }
            throw new JbpmException("Address resolver '" + addressResolver + "' returned '" + resolvedAddresses.getClass().getName() + "' instead of a String, Collection or String-array: " + resolvedAddresses);
        }
        return emailAddresses;
    }

    Properties getMailServerProperties() {
        Properties mailServerProperties = new Properties();
        if (JbpmConfiguration.Configs.hasObject((String)"resource.mail.properties")) {
            String mailServerPropertiesResource = JbpmConfiguration.Configs.getString((String)"resource.mail.properties");
            try {
                InputStream mailServerStream = ClassLoaderUtil.getStream((String)mailServerPropertiesResource);
                mailServerProperties.load(mailServerStream);
            }
            catch (Exception e) {
                throw new JbpmException("couldn't get configuration properties for jbpm mail server from resource '" + mailServerPropertiesResource + "'", (Throwable)e);
            }
        } else if (JbpmConfiguration.Configs.hasObject((String)"jbpm.mail.smtp.host")) {
            String smtpServer = JbpmConfiguration.Configs.getString((String)"jbpm.mail.smtp.host");
            mailServerProperties.put("mail.smtp.host", smtpServer);
        } else {
            log.error((Object)"couldn't get mail properties");
        }
        return mailServerProperties;
    }

    private static Element parseJbpmTemplate(String templateName) {
        log.debug((Object)("Getting template '" + templateName + "' from file '" + Config.JBPM_MAIL_TEMPLATE + "'"));
        try {
            FileInputStream fis = new FileInputStream(new File(Config.JBPM_MAIL_TEMPLATE));
            Element docElement = XmlUtil.parseXmlInputStream((InputStream)fis).getDocumentElement();
            fis.close();
            return docElement;
        }
        catch (Exception e) {
            log.error((Object)"Unable to parse template", (Throwable)e);
            return null;
        }
    }

    static synchronized Properties getMailTemplateProperties(String templateName) {
        File file = new File(Config.JBPM_MAIL_TEMPLATE);
        long lastModify = file.lastModified();
        if (file != null && lastModify > lastTemplateModification) {
            log.debug((Object)("mail template '" + Config.JBPM_MAIL_TEMPLATE + "' has been modified, going to reset cached template"));
            templates = null;
        }
        if (templates == null) {
            templates = new HashMap<String, Properties>();
            String mailTemplatesResource = JbpmConfiguration.Configs.getString((String)"resource.mail.templates");
            Element mailTemplatesElement = Mail.parseJbpmTemplate(templateName);
            if (mailTemplatesElement == null) {
                mailTemplatesElement = XmlUtil.parseXmlResource((String)mailTemplatesResource, (boolean)false).getDocumentElement();
            }
            List mailTemplateElements = XmlUtil.elements((Element)mailTemplatesElement, (String)"mail-template");
            for (Element mailTemplateElement : mailTemplateElements) {
                Properties templateProperties = new Properties();
                Mail.addTemplateProperty(mailTemplateElement, "fromAddress", templateProperties);
                Mail.addTemplateProperty(mailTemplateElement, "actors", templateProperties);
                Mail.addTemplateProperty(mailTemplateElement, "to", templateProperties);
                Mail.addTemplateProperty(mailTemplateElement, "subject", templateProperties);
                Mail.addTemplateProperty(mailTemplateElement, "text", templateProperties);
                Mail.addTemplateProperty(mailTemplateElement, "bcc", templateProperties);
                Mail.addTemplateProperty(mailTemplateElement, "bccActors", templateProperties);
                Mail.addTemplatePropertyKeyValues(mailTemplateElement, "headers", "header", templateProperties);
                String name = mailTemplateElement.getAttribute("name");
                templates.put(name, templateProperties);
                log.debug((Object)("Template '" + name + "' has been put inside template collection"));
            }
            templateVariables = new HashMap<String, String>();
            List variableElements = XmlUtil.elements((Element)mailTemplatesElement, (String)"variable");
            for (Element variableElement : variableElements) {
                templateVariables.put(variableElement.getAttribute("name"), variableElement.getAttribute("value"));
            }
        }
        lastTemplateModification = lastModify;
        return templates.get(templateName);
    }

    static void addTemplateProperty(Element mailTemplateElement, String property, Properties templateProperties) {
        Element element = XmlUtil.element((Element)mailTemplateElement, (String)property);
        if (element == null) {
            return;
        }
        templateProperties.put(property, XmlUtil.getContentText((Element)element));
    }

    static void addTemplatePropertyKeyValues(Element mailTemplateElement, String property, String subElementName, Properties templateProperties) {
        Element element = XmlUtil.element((Element)mailTemplateElement, (String)property);
        if (element == null) {
            return;
        }
        Properties properties = new Properties();
        List elements = XmlUtil.elements((Element)element, (String)subElementName);
        for (Object objSubElement : elements) {
            Element subElement = (Element)objSubElement;
            String key = subElement.getAttribute("key");
            String value = subElement.getAttribute("value");
            if (key == null || key.equals("")) continue;
            properties.setProperty(key, value);
        }
        templateProperties.put(property, properties);
    }

    String evaluate(String expression) {
        Object result;
        if (expression == null) {
            return null;
        }
        VariableResolver variableResolver = JbpmExpressionEvaluator.getUsedVariableResolver();
        if (variableResolver != null) {
            variableResolver = new MailVariableResolver(templateVariables, variableResolver);
        }
        if ((result = JbpmExpressionEvaluator.evaluate((String)expression, (ExecutionContext)this.executionContext, (VariableResolver)variableResolver, (FunctionMapper)JbpmExpressionEvaluator.getUsedFunctionMapper())) == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        if (result instanceof Iterable) {
            for (Object value : (Iterable)result) {
                if (value instanceof PooledActor) {
                    value = ((PooledActor)value).getActorId();
                }
                if (value == null) continue;
                if (!first) {
                    sb.append(";");
                }
                first = false;
                sb.append(value.toString());
            }
            result = sb.toString();
        }
        return result.toString();
    }

    static {
        templates = null;
        templateVariables = null;
    }

    class MailVariableResolver
    implements VariableResolver,
    Serializable {
        private static final long serialVersionUID = 1L;
        Map<String, String> templateVariables = null;
        VariableResolver variableResolver = null;

        public MailVariableResolver(Map<String, String> templateVariables, VariableResolver variableResolver) {
            this.templateVariables = templateVariables;
            this.variableResolver = variableResolver;
        }

        public Object resolveVariable(String pName) throws ELException {
            if (this.templateVariables != null && this.templateVariables.containsKey(pName)) {
                return this.templateVariables.get(pName);
            }
            return this.variableResolver.resolveVariable(pName);
        }
    }
}

