/*
 * Decompiled with CFR 0.152.
 */
package cz.solnet.webdav;

import cz.solnet.webdav.SolnetFilterChain;
import cz.solnet.webdav.SolnetFilterConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CommonFilter
implements Filter {
    private static Logger log = LoggerFactory.getLogger(CommonFilter.class);
    private HashMap<String, Filter> filters = new LinkedHashMap<String, Filter>();
    private String filterName = null;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterName = filterConfig.getFilterName();
        log.debug("Iitializing common filter '" + this.filterName + "'");
        String configFileName = filterConfig.getInitParameter("config.file.name");
        if (configFileName == null || configFileName.equalsIgnoreCase("")) {
            log.error("Config file name is not specified");
            return;
        }
        try {
            this.createFilters(configFileName);
        }
        catch (Exception e) {
            log.error("Unable to init filter mapping", (Throwable)e);
        }
    }

    public void destroy() {
        for (Filter filter : this.filters.values()) {
            if (filter == null) continue;
            filter.destroy();
        }
        this.filters.clear();
        this.filters = null;
        log.debug("Common filter '" + this.filterName + "' destroyed");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        SolnetFilterChain solnetChain = new SolnetFilterChain(chain);
        for (Map.Entry<String, Filter> entry : this.filters.entrySet()) {
            solnetChain.addFilter(entry.getValue());
        }
        solnetChain.doFilter(request, response);
    }

    private static void addFilterConfigParam(SolnetFilterConfig filterConfig, Element element) {
        String paramName = CommonFilter.getSubElementTextValue(element, "param-name");
        String paramValue = CommonFilter.getSubElementTextValue(element, "param-value");
        if (paramName != null && !"".equalsIgnoreCase(paramName)) {
            log.debug("Adding param name and value (" + paramName + ", " + paramValue + "')");
            filterConfig.addParam(paramName, paramValue);
        }
    }

    private void createFilter(Element element) throws Exception {
        log.debug("Creating filter for element " + element.getTagName());
        Filter filter = null;
        SolnetFilterConfig filterConfig = new SolnetFilterConfig(null);
        String filterName = CommonFilter.getSubElementTextValue(element, "filter-name");
        String filterClass = CommonFilter.getSubElementTextValue(element, "filter-class");
        List<Element> params = CommonFilter.getSubElements(element, "init-param");
        for (Element param : params) {
            CommonFilter.addFilterConfigParam(filterConfig, param);
        }
        if (filterName == null) {
            log.error("No filter name defined for class " + filterClass);
            return;
        }
        if (filterClass == null) {
            log.error("No filter class defined for filter " + filterName);
            return;
        }
        filter = (Filter)Class.forName(filterClass).newInstance();
        filter.init((FilterConfig)filterConfig);
        log.debug("Filter created and initialized (" + filterName + ", " + filterClass + ")");
        this.filters.put(filterName, filter);
    }

    private static String getSubElementTextValue(Element element, String tagName) {
        Element subElement = CommonFilter.getSubElement(element, tagName);
        return subElement != null ? subElement.getTextContent() : null;
    }

    private static Element getSubElement(Element element, String tagName) {
        NodeList nodeList = element.getElementsByTagName(tagName);
        return nodeList != null && nodeList.getLength() > 0 ? (Element)nodeList.item(0) : null;
    }

    private static List<Element> getSubElements(Element element, String tagName) {
        NodeList nodeList = element.getElementsByTagName(tagName);
        ArrayList<Element> list = new ArrayList<Element>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            list.add((Element)nodeList.item(i));
        }
        return list;
    }

    private void createFilters(String fileName) throws Exception {
        log.debug("Getting filter configuration from '" + fileName + "'");
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document dom = db.parse(fileName);
        Element docElement = dom.getDocumentElement();
        NodeList filterNodeList = docElement.getElementsByTagName("filter");
        for (int i = 0; i < filterNodeList.getLength(); ++i) {
            Element element = (Element)filterNodeList.item(i);
            String commonFilterName = element.getAttribute("commonFilterName");
            if (!this.filterName.equalsIgnoreCase(commonFilterName)) continue;
            this.createFilter(element);
        }
        log.debug("Filters created");
    }
}

