/*
 * Decompiled with CFR 0.152.
 */
package cz.solnet.webdav;

import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.core.JcrSessionManager;
import com.openkm.dao.LegacyDAO;
import com.openkm.dao.bean.DatabaseMetadataValue;
import com.openkm.jcr.JCRUtils;
import com.openkm.module.base.BaseAuthModule;
import com.openkm.module.direct.DirectRepositoryModule;
import com.openkm.principal.PrincipalAdapter;
import com.openkm.util.DatabaseMetadataUtils;
import com.openkm.webdav.JcrSessionTokenHolder;
import com.openkm.webdav.WebDavService;
import cz.solnet.webdav.OkmUserCacheItem;
import cz.solnet.webdav.SimpleGroup;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.jcr.LoginException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jcifs.UniAddress;
import jcifs.http.NtlmSsp;
import jcifs.smb.NtlmChallenge;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbAuthException;
import jcifs.smb.SmbSession;
import jcifs.util.Hexdump;
import org.apache.jackrabbit.core.security.UserPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NtlmWebDavFilter
implements Filter {
    private static Logger log = LoggerFactory.getLogger(NtlmWebDavFilter.class);
    private static final HashMap<String, OkmUserCacheItem> ntlmUserCache = new HashMap();
    private static int NTLM_USER_CACHE_PERIOD = 3600000;
    private String defaultDomain;
    private String domainController;
    private boolean loadBalance;
    private static PrincipalAdapter principalAadapter;

    public void init(FilterConfig filterConfig) throws ServletException {
        jcifs.Config.setProperty((String)"jcifs.smb.client.soTimeout", (String)"1800000");
        jcifs.Config.setProperty((String)"jcifs.netbios.cachePolicy", (String)"1200");
        jcifs.Config.setProperty((String)"jcifs.smb.lmCompatibility", (String)"0");
        jcifs.Config.setProperty((String)"jcifs.smb.client.useExtendedSecurity", (String)"false");
        jcifs.Config.setProperty((String)"minuteUserCachePeriod", (String)"60");
        Enumeration e = filterConfig.getInitParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            jcifs.Config.setProperty((String)name, (String)filterConfig.getInitParameter(name));
        }
        this.defaultDomain = jcifs.Config.getProperty((String)"jcifs.smb.client.domain");
        this.domainController = jcifs.Config.getProperty((String)"jcifs.http.domainController");
        if (this.domainController == null) {
            this.domainController = this.defaultDomain;
            this.loadBalance = jcifs.Config.getBoolean((String)"jcifs.http.loadBalance", (boolean)true);
        }
        int minuteUserCachePeriod = jcifs.Config.getInt((String)"minuteUserCachePeriod");
        NTLM_USER_CACHE_PERIOD = minuteUserCachePeriod * 60 * 1000;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        try {
            jcifs.Config.list((PrintStream)ps);
            String configInfo = baos.toString();
            log.debug("JCIFS PROPERTIES: {}", (Object)configInfo);
        }
        catch (IOException ex) {
            log.warn("Cannot log JCIFS properties", (Throwable)ex);
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (Config.SYSTEM_WEBDAV_SERVER) {
            response.setContentType(Config.MIME_HTML);
            this.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        } else {
            response.setContentType(Config.MIME_TEXT);
            PrintWriter out = response.getWriter();
            out.println("WebDAV is disabled. Contact with your administrator.");
            out.flush();
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String okmUser;
        UUID uuid;
        SessionWrapper sessionWrapper;
        block12: {
            NtlmPasswordAuthentication ntlm;
            block11: {
                sessionWrapper = null;
                uuid = UUID.randomUUID();
                log.debug("Handeling request ({}, {}, {})", new Object[]{request.getMethod(), request.getRequestURL().toString(), uuid});
                okmUser = null;
                ntlm = this.negotiate(request, response);
                if (ntlm != null) break block11;
                response.getOutputStream().flush();
                response.flushBuffer();
                if (sessionWrapper != null) {
                    JcrSessionManager.getInstance().remove(JcrSessionTokenHolder.get());
                    JCRUtils.logout(sessionWrapper.getSession());
                }
                log.debug("Request handled ({}, {}, {}, {})", new Object[]{request.getMethod(), request.getRequestURL().toString(), okmUser, uuid});
                return;
            }
            sessionWrapper = this.getSession(request, response, ntlm.getName());
            if (sessionWrapper != null) break block12;
            response.getOutputStream().flush();
            response.flushBuffer();
            if (sessionWrapper != null) {
                JcrSessionManager.getInstance().remove(JcrSessionTokenHolder.get());
                JCRUtils.logout(sessionWrapper.getSession());
            }
            log.debug("Request handled ({}, {}, {}, {})", new Object[]{request.getMethod(), request.getRequestURL().toString(), okmUser, uuid});
            return;
        }
        try {
            okmUser = sessionWrapper.getOkmUser();
            String uid = UUID.randomUUID().toString();
            JcrSessionManager.getInstance().add(uid, sessionWrapper.getSession());
            JcrSessionTokenHolder.set(uid);
            WebDavService.get().handleNTLMRequest(sessionWrapper.getOkmUser(), request, response);
        }
        catch (Throwable t) {
            try {
                log.error("Cannot handle NTLM WebDAV request, " + uuid, t);
                response.sendError(500, t.getMessage());
            }
            catch (Throwable throwable) {
                response.getOutputStream().flush();
                response.flushBuffer();
                if (sessionWrapper != null) {
                    JcrSessionManager.getInstance().remove(JcrSessionTokenHolder.get());
                    JCRUtils.logout(sessionWrapper.getSession());
                }
                log.debug("Request handled ({}, {}, {}, {})", new Object[]{request.getMethod(), request.getRequestURL().toString(), okmUser, uuid});
                throw throwable;
            }
            response.getOutputStream().flush();
            response.flushBuffer();
            if (sessionWrapper != null) {
                JcrSessionManager.getInstance().remove(JcrSessionTokenHolder.get());
                JCRUtils.logout(sessionWrapper.getSession());
            }
            log.debug("Request handled ({}, {}, {}, {})", new Object[]{request.getMethod(), request.getRequestURL().toString(), okmUser, uuid});
        }
        response.getOutputStream().flush();
        response.flushBuffer();
        if (sessionWrapper != null) {
            JcrSessionManager.getInstance().remove(JcrSessionTokenHolder.get());
            JCRUtils.logout(sessionWrapper.getSession());
        }
        log.debug("Request handled ({}, {}, {}, {})", new Object[]{request.getMethod(), request.getRequestURL().toString(), okmUser, uuid});
    }

    private static SimpleGroup getUserRoles(String userName) {
        try {
            if (principalAadapter == null) {
                principalAadapter = BaseAuthModule.getPrincipalAdapter();
            }
            List<String> roles = principalAadapter.getRolesByUser(userName);
            SimpleGroup group = new SimpleGroup("userRole");
            for (String role : roles) {
                group.addMember((Principal)new UserPrincipal(role));
            }
            return group;
        }
        catch (Exception e) {
            log.error("Unable to get roles for user '" + userName + "'", (Throwable)e);
            return null;
        }
    }

    private SessionWrapper getSession(HttpServletRequest request, HttpServletResponse response, String ntlmUser) throws Exception {
        String okmUser = null;
        try {
            Object object;
            okmUser = NtlmWebDavFilter.getOkmUser(ntlmUser);
            if (okmUser == null) {
                response.setHeader("WWW-Authenticate", "NTLM");
                response.setStatus(401);
                return null;
            }
            Subject subject = new Subject();
            Set<Principal> principals = subject.getPrincipals();
            principals.add((Principal)new UserPrincipal(okmUser));
            SimpleGroup group = NtlmWebDavFilter.getUserRoles(okmUser);
            if (group != null) {
                principals.add(group);
            }
            if ((object = Subject.doAs(subject, new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Session session = null;
                    try {
                        session = DirectRepositoryModule.getRepository().login();
                    }
                    catch (LoginException e) {
                        return e;
                    }
                    catch (RepositoryException e) {
                        return e;
                    }
                    return session;
                }
            })) instanceof Exception) {
                throw (Exception)object;
            }
            Session session = (Session)object;
            String sessionHex = Integer.toHexString(System.identityHashCode(session));
            String userIdHex = Integer.toHexString(System.identityHashCode(session.getUserID()));
            log.debug("JCR session created for '{}' (session={}, userId={})", new Object[]{okmUser, sessionHex, userIdHex});
            return new SessionWrapper(session, okmUser);
        }
        catch (Exception e) {
            String msg = "Unable to login OKM user into repository (OKM user='" + okmUser + "')";
            log.error(msg, (Throwable)e);
            throw new Exception("Unable to login OKM user into repository (OKM user='" + okmUser + "')", e);
        }
    }

    protected NtlmPasswordAuthentication negotiate(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        NtlmPasswordAuthentication ntlm = null;
        String msg = req.getHeader("Authorization");
        if (msg != null && msg.startsWith("NTLM ")) {
            byte[] challenge;
            UniAddress dc;
            HttpSession ssn = req.getSession();
            if (this.loadBalance) {
                NtlmChallenge chal = (NtlmChallenge)ssn.getAttribute("NtlmHttpChal");
                if (chal == null) {
                    chal = SmbSession.getChallengeForDomain();
                    ssn.setAttribute("NtlmHttpChal", (Object)chal);
                }
                dc = chal.dc;
                challenge = chal.challenge;
            } else {
                dc = UniAddress.getByName((String)this.domainController, (boolean)true);
                challenge = SmbSession.getChallenge((UniAddress)dc);
            }
            ntlm = NtlmSsp.authenticate((HttpServletRequest)req, (HttpServletResponse)resp, (byte[])challenge);
            if (ntlm == null) {
                return null;
            }
            ssn.removeAttribute("NtlmHttpChal");
            try {
                SmbSession.logon((UniAddress)dc, (NtlmPasswordAuthentication)ntlm);
                log.info("NTLM user '{}' successfully authenticated against {}", new Object[]{ntlm, dc});
            }
            catch (SmbAuthException sae) {
                String errMsg = String.format("User %1$s not authenticated: 0x%2$s", ntlm.getName(), Hexdump.toHexString((int)sae.getNtStatus(), (int)8));
                log.warn(errMsg, (Throwable)sae);
                if (sae.getNtStatus() == -1073741819 && (ssn = req.getSession(false)) != null) {
                    ssn.removeAttribute("NtlmHttpAuth");
                }
                resp.setHeader("WWW-Authenticate", "NTLM");
                resp.setStatus(401);
                resp.setContentLength(0);
                resp.flushBuffer();
                return null;
            }
            req.getSession().setAttribute("NtlmHttpAuth", (Object)ntlm);
        } else {
            HttpSession ssn = req.getSession(false);
            if (ssn == null || (ntlm = (NtlmPasswordAuthentication)ssn.getAttribute("NtlmHttpAuth")) == null) {
                resp.setHeader("WWW-Authenticate", "NTLM");
                resp.setStatus(401);
                resp.setContentLength(0);
                resp.flushBuffer();
                return null;
            }
        }
        return ntlm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addCachedUser(String ntlmUser, String okmUser) {
        HashMap<String, OkmUserCacheItem> hashMap = ntlmUserCache;
        synchronized (hashMap) {
            OkmUserCacheItem item = new OkmUserCacheItem(ntlmUser, okmUser);
            ntlmUserCache.put(ntlmUser, item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getCachedOkmUser(String ntlmUser) {
        HashMap<String, OkmUserCacheItem> hashMap = ntlmUserCache;
        synchronized (hashMap) {
            if (!ntlmUserCache.containsKey(ntlmUser)) {
                return null;
            }
            OkmUserCacheItem item = ntlmUserCache.get(ntlmUser);
            if (item == null) {
                return null;
            }
            Date now = new Date();
            if (now.getTime() - item.getDtStamp().getTime() > (long)NTLM_USER_CACHE_PERIOD) {
                ntlmUserCache.remove(ntlmUser);
                return null;
            }
            log.debug("Got cached OKM user '{}' for NTLM user '{}'", new Object[]{item.getOkmUser(), ntlmUser});
            return item.getOkmUser();
        }
    }

    private static String getOkmUserFromDb(String ntlmUser) throws DatabaseException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (ntlmUser == null) {
            log.debug("No NTLM user specified");
            return null;
        }
        ntlmUser = ntlmUser.toLowerCase();
        String filter = "$ntlm_user='" + ntlmUser.replaceAll("\\\\", "\\\\\\\\").replaceAll("'", "''") + "'";
        String query = DatabaseMetadataUtils.buildQuery("ntlm_mapping", filter, null);
        List<Object> list = LegacyDAO.executeQuery(query);
        if (list == null || list.size() == 0) {
            log.warn("No OKM user found for NTLM user '{}'", new Object[]{ntlmUser});
            return null;
        }
        if (list.size() > 1) {
            log.warn("Found more than 2 OKM users for NTLM user '{}'", new Object[]{ntlmUser});
            return null;
        }
        DatabaseMetadataValue mv = (DatabaseMetadataValue)list.get(0);
        String okmUser = DatabaseMetadataUtils.getString(mv, "okm_user");
        log.debug("Found OKM user '{}' for NTLM user '{}' in DB", new Object[]{okmUser, ntlmUser});
        return okmUser;
    }

    private static String getOkmUser(String ntlmUser) throws DatabaseException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        log.debug("Getting OKM user for '{}'", (Object)ntlmUser);
        String okmUser = NtlmWebDavFilter.getCachedOkmUser(ntlmUser);
        if (okmUser == null && (okmUser = NtlmWebDavFilter.getOkmUserFromDb(ntlmUser)) != null) {
            NtlmWebDavFilter.addCachedUser(ntlmUser, okmUser);
        }
        return okmUser;
    }

    private class SessionWrapper {
        private Session session;
        private String okmUser;

        public SessionWrapper(Session session, String okmUser) {
            this.session = session;
            this.okmUser = okmUser;
        }

        public Session getSession() {
            return this.session;
        }

        public String getOkmUser() {
            return this.okmUser;
        }
    }
}

