/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell.logger.identifiers;

import cz.nextiraone.tmobile.wintell.logger.identifiers.GeneralLogIdentity;
import cz.nextiraone.tmobile.wintell.logger.identifiers.IdentifiableLogId;

public class LogIdFactory {
    public static final String UNKNOWN_TYPE = "U";
    public static final String UNKNOWN_ID = "UNKNOWN";
    public static final String WINTELL_SYSTEM_TYPE = "W";
    public static final String WINTELL_SYSTEM_ID = "SYS";
    public static final String HTTP_SESSION_TYPE = "H";
    public static final String WINTELL_SESSION_TYPE = "S";
    public static final String OFER_ACTIVITY_TYPE = "O";
    public static final String REQUEST_ID_TYPE = "R";
    public static final String TIB_PROCESS_ID_TYPE = "T";
    public static final String JMS_ID_TYPE = "J";
    private static final IdentifiableLogId UNKNOWN_SESSION_ID = new GeneralLogIdentity("U", "UNKNOWN");

    public static IdentifiableLogId createUnknownId() {
        return UNKNOWN_SESSION_ID;
    }

    public static IdentifiableLogId createSystemId() {
        return new GeneralLogIdentity(WINTELL_SYSTEM_TYPE, WINTELL_SYSTEM_ID);
    }

    public static IdentifiableLogId createHttpSessionId(String sessionId) {
        return new GeneralLogIdentity(HTTP_SESSION_TYPE, sessionId);
    }

    public static IdentifiableLogId createWintellSessionId(long sessionId) {
        return new GeneralLogIdentity(WINTELL_SESSION_TYPE, Long.toString(sessionId));
    }

    public static IdentifiableLogId createTibProcessId(long tibProcessId) {
        return new GeneralLogIdentity(TIB_PROCESS_ID_TYPE, Long.toString(tibProcessId));
    }

    public static IdentifiableLogId createRequestId(long requestId) {
        return new GeneralLogIdentity(REQUEST_ID_TYPE, Long.toString(requestId));
    }

    public static IdentifiableLogId createOfferActivityId(long offerActivityId) {
        return new GeneralLogIdentity(OFER_ACTIVITY_TYPE, Long.toString(offerActivityId));
    }

    public static IdentifiableLogId createJmsMessageId(String jmsMessageId) {
        return new GeneralLogIdentity(JMS_ID_TYPE, jmsMessageId);
    }
}

