/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell.tool;

import cz.nextiraone.tmobile.wintell.context.WintellActionContext;
import cz.nextiraone.tmobile.wintell.context.WintellSubprojectEnum;
import cz.nextiraone.tmobile.wintell.context.WintellSystemActionContext;
import cz.nextiraone.tmobile.wintell.exception.ServiceLocatorException;
import cz.nextiraone.tmobile.wintell.logger.WintellLogger;
import java.util.Properties;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class ServiceLocatorHA {
    private static final String DEFAULT_PARTITION_NAME = System.getProperty("jboss.partition.name", "DefaultPartition");
    private static final WintellLogger log = WintellLogger.getLogger(ServiceLocatorHA.class);
    private static final WintellActionContext systemActionContext = new WintellSystemActionContext(WintellSubprojectEnum.NONE);

    private ServiceLocatorHA() {
    }

    private static Context getHAContext() throws NamingException {
        Properties p = new Properties();
        p.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
        p.put("java.naming.factory.url.pkgs", "jboss.naming:org.jnp.interfaces");
        p.put("jnp.partitionName", DEFAULT_PARTITION_NAME);
        return new InitialContext(p);
    }

    public static ConnectionFactory getJmsConnectionFactory(String jmsConnectionFactoryJndiName) throws ServiceLocatorException {
        ConnectionFactory jmsConnectionFactory = null;
        try {
            Context ctx = ServiceLocatorHA.getHAContext();
            log.debug(systemActionContext, "getJmsConnectionFactory context" + ctx.toString());
            jmsConnectionFactory = (ConnectionFactory)ctx.lookup(jmsConnectionFactoryJndiName);
        }
        catch (ClassCastException cce) {
            throw new ServiceLocatorException(cce);
        }
        catch (NamingException ne) {
            throw new ServiceLocatorException(ne);
        }
        return jmsConnectionFactory;
    }

    public static Destination getJmsDestination(String jmsDestinationJndiName) throws ServiceLocatorException {
        Destination jmsDestination = null;
        try {
            Context ctx = ServiceLocatorHA.getHAContext();
            log.debug(systemActionContext, "getJmsDestination for: " + jmsDestinationJndiName + " with context" + ctx.toString());
            jmsDestination = (Destination)ctx.lookup(jmsDestinationJndiName);
        }
        catch (ClassCastException cce) {
            throw new ServiceLocatorException(cce);
        }
        catch (NamingException ne) {
            throw new ServiceLocatorException(ne);
        }
        return jmsDestination;
    }

    public static void setHaJndiObject(String hajndiName, Object object) throws NamingException {
        Context ctx = ServiceLocatorHA.getHAContext();
        ctx.bind(hajndiName, object);
    }

    public static Object getHaJndiObject(String hajndiName) throws NamingException {
        Context ctx = ServiceLocatorHA.getHAContext();
        return ctx.lookup(hajndiName);
    }

    public static void removeHaJndiObject(String hajndiName) throws NamingException {
        Context ctx = ServiceLocatorHA.getHAContext();
        ctx.unbind(hajndiName);
    }

    public static void createHaJndiSubcontext(String subCtxName) throws NamingException {
        Context ctx = ServiceLocatorHA.getHAContext();
        String[] subCtxNameParts = subCtxName.split("/");
        StringBuffer ctxPath = new StringBuffer();
        for (int i = 0; i < subCtxNameParts.length; ++i) {
            ctxPath.append((i > 0 ? "/" : "") + subCtxNameParts[i]);
            log.debug(systemActionContext, "Creating subcontext [" + ctxPath.toString() + "]");
            ctx.createSubcontext(ctxPath.toString());
            log.debug(systemActionContext, "Creating subcontext [" + ctxPath.toString() + "] DONE");
        }
    }

    public static void destroyHaJndiSubcontext(String subCtxName) throws NamingException {
        Context ctx = ServiceLocatorHA.getHAContext();
        ctx.destroySubcontext(subCtxName);
    }
}

