/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell.logger;

import cz.nextiraone.tmobile.wintell.context.DefaultUnknownWintellActionContext;
import cz.nextiraone.tmobile.wintell.context.WintellActionContext;
import cz.nextiraone.tmobile.wintell.logger.identifiers.IdentifiableLogId;
import cz.nextiraone.tmobile.wintell.logger.identifiers.LogIdFactory;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class WintellLogger
implements Serializable {
    private static final long serialVersionUID = -602544134009542424L;
    public static final String STACK_TRACE_DELIMITTER = "\nStack trace: \n";
    private Logger logger;

    protected WintellLogger(Logger logger) {
        this.logger = logger;
    }

    public static WintellLogger getLogger(String name) {
        return new WintellLogger(Logger.getLogger((String)name));
    }

    public static WintellLogger getLogger(Class clazz) {
        return new WintellLogger(Logger.getLogger((Class)clazz));
    }

    @Deprecated
    public void debug(String message) {
        this.logger.debug((Object)message);
    }

    @Deprecated
    public void debug(String message, Throwable t) {
        this.logger.debug((Object)(message + STACK_TRACE_DELIMITTER + WintellLogger.getStackTrace(t)));
    }

    public void debug(WintellActionContext context, String message) {
        this.logger.debug((Object)this.prefixMessageWithTopMessageId(context, message));
    }

    public void debug(WintellActionContext context, String message, Throwable t) {
        this.debug(context, message + STACK_TRACE_DELIMITTER + WintellLogger.getStackTrace(t));
    }

    @Deprecated
    public void info(String message) {
        this.logger.info((Object)message);
    }

    @Deprecated
    public void info(String message, Throwable t) {
        this.logger.info((Object)(message + STACK_TRACE_DELIMITTER + WintellLogger.getStackTrace(t)));
    }

    public void info(WintellActionContext context, String message) {
        this.logger.info((Object)this.prefixMessageWithTopMessageId(context, message));
    }

    public void info(WintellActionContext context, String message, Throwable t) {
        this.info(context, message + STACK_TRACE_DELIMITTER + WintellLogger.getStackTrace(t));
    }

    @Deprecated
    public void warn(String message) {
        this.logger.warn((Object)message);
    }

    @Deprecated
    public void warn(String message, Throwable t) {
        this.logger.warn((Object)(message + STACK_TRACE_DELIMITTER + WintellLogger.getStackTrace(t)));
    }

    public void warn(WintellActionContext context, String message) {
        this.logger.warn((Object)this.prefixMessageWithTopMessageId(context, message));
    }

    public void warn(WintellActionContext context, String message, Throwable t) {
        this.warn(context, message + STACK_TRACE_DELIMITTER + WintellLogger.getStackTrace(t));
    }

    @Deprecated
    public void error(String message) {
        this.logger.error((Object)message);
    }

    @Deprecated
    public void error(String message, Throwable t) {
        this.logger.error((Object)(message + STACK_TRACE_DELIMITTER + WintellLogger.getStackTrace(t)));
    }

    public void error(WintellActionContext context, String message) {
        this.logger.error((Object)this.prefixMessageWithTopMessageId(context, message));
    }

    public void error(WintellActionContext context, String message, Throwable t) {
        this.error(context, message + STACK_TRACE_DELIMITTER + WintellLogger.getStackTrace(t));
    }

    public void fatal(WintellActionContext context, String message) {
        this.logger.fatal((Object)this.prefixMessageWithTopMessageId(context, message));
    }

    public void fatal(WintellActionContext context, String message, Throwable t) {
        this.fatal(context, message + STACK_TRACE_DELIMITTER + WintellLogger.getStackTrace(t));
    }

    public void logIdentityGlue(WintellActionContext context) {
        List<IdentifiableLogId> identities = context.getLogIdChain().getChain();
        if (identities.size() == 2 && LogIdFactory.createUnknownId().equals(identities.get(0))) {
            return;
        }
        StringBuilder message = new StringBuilder();
        for (IdentifiableLogId identity : identities) {
            message.append(identity.getIdentity() + "=>");
        }
        this.logger.info((Object)(context.getSubproject().toString() + ":" + message.substring(0, message.length() - 2) + " __ID::MAPPING__"));
    }

    private String getMessageTopId(WintellActionContext context) {
        if (!this.isNullContext(context)) {
            return context.getSubproject().toString() + ":" + context.getLogIdChain().getTopId().getIdentity();
        }
        return this.getMessageTopId(DefaultUnknownWintellActionContext.getInstance());
    }

    public static String getStackTrace(Throwable t) {
        if (t == null) {
            return "Null throwable";
        }
        String stackTrace = null;
        try {
            StringWriter strWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(strWriter);
            t.printStackTrace(printWriter);
            stackTrace = strWriter.getBuffer().toString();
            printWriter.close();
            strWriter.close();
        }
        catch (Throwable neverShouldHappenThrowable) {
            return "defaultStackTrace - got exception while getting stack trace from throwable: " + neverShouldHappenThrowable.getMessage();
        }
        return stackTrace;
    }

    private String prefixMessageWithTopMessageId(WintellActionContext context, String message) {
        String messageId = this.getMessageTopId(context) + ":";
        if (message != null && message.contains("\n")) {
            String[] lines;
            StringBuilder buff = new StringBuilder();
            for (String s : lines = message.split("\n")) {
                buff.append(" " + messageId + "\t" + s + "\n");
            }
            return buff.substring(0, buff.length() - 1);
        }
        return messageId + message;
    }

    private boolean isNullContext(WintellActionContext context) {
        if (context == null) {
            this.error(DefaultUnknownWintellActionContext.getInstance(), "NULL context");
            return true;
        }
        if (context.getSubproject() == null) {
            this.error(DefaultUnknownWintellActionContext.getInstance(), "NULL subproject");
            return true;
        }
        if (context.getLogIdChain() == null) {
            this.error(DefaultUnknownWintellActionContext.getInstance(), "NULL LogIdChain");
            return true;
        }
        if (context.getLogIdChain().getTopId() == null) {
            this.error(DefaultUnknownWintellActionContext.getInstance(), "NULL topId");
            return true;
        }
        if (context.getLogIdChain().getTopId().getIdentity() == null) {
            this.error(DefaultUnknownWintellActionContext.getInstance(), "NULL Identity for topId");
            return true;
        }
        return false;
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isEnabledFor(Priority level) {
        return this.logger.isEnabledFor(level);
    }

    public static String getStackTrace(Exception e) {
        StringWriter sWriter = new StringWriter();
        PrintWriter pWriter = new PrintWriter(sWriter);
        e.printStackTrace(pWriter);
        return sWriter.toString();
    }
}

