/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell.tool;

import cz.nextiraone.tmobile.wintell.exception.JmsProducerException;
import cz.nextiraone.tmobile.wintell.exception.ServiceLocatorException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class JmsProducer {
    private static final int MAX_FAILURES = 2;
    private static Map<String, Object> lookupCache = new HashMap<String, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(Serializable payload, String jmsCorrelationID, String destinationJndiName) throws JmsProducerException {
        int i = 1;
        while (true) {
            block7: {
                try {
                    this.sendMessage(payload, jmsCorrelationID, "ClusteredConnectionFactory", destinationJndiName);
                }
                catch (Exception e) {
                    if (i < 2) {
                        Map<String, Object> map = lookupCache;
                        synchronized (map) {
                            lookupCache.clear();
                            break block7;
                        }
                    }
                    throw new JmsProducerException(e);
                }
                return;
            }
            ++i;
        }
    }

    public void sendMessage(Serializable payload, String jmsCorrelationID, String connectionFactoryJndiName, String destinationJndiName) throws JmsProducerException, ServiceLocatorException, JMSException {
        ConnectionFactory connectionFactory = null;
        Connection connection = null;
        Session session = null;
        Destination destination = null;
        MessageProducer messageProducer = null;
        ObjectMessage message = null;
        connectionFactory = ServiceLocator.getJmsConnectionFactory(connectionFactoryJndiName);
        connection = connectionFactory.createConnection();
        session = connection.createSession(false, 1);
        destination = ServiceLocator.getJmsDestination(destinationJndiName);
        messageProducer = session.createProducer(destination);
        message = session.createObjectMessage(payload);
        if (jmsCorrelationID != null) {
            message.setJMSCorrelationID(jmsCorrelationID);
        }
        messageProducer.send((Message)message);
        messageProducer.close();
        session.close();
        connection.close();
    }

    public static class ServiceLocator {
        private ServiceLocator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ConnectionFactory getJmsConnectionFactory(String jmsConnectionFactoryJndiName) throws ServiceLocatorException {
            Map map = lookupCache;
            synchronized (map) {
                if (lookupCache.containsKey(jmsConnectionFactoryJndiName)) {
                    return (ConnectionFactory)lookupCache.get(jmsConnectionFactoryJndiName);
                }
                ConnectionFactory jmsConnectionFactory = null;
                try {
                    InitialContext ctx = new InitialContext();
                    jmsConnectionFactory = (ConnectionFactory)ctx.lookup(jmsConnectionFactoryJndiName);
                    lookupCache.put(jmsConnectionFactoryJndiName, jmsConnectionFactory);
                }
                catch (ClassCastException cce) {
                    throw new ServiceLocatorException(cce);
                }
                catch (NamingException ne) {
                    throw new ServiceLocatorException(ne);
                }
                return jmsConnectionFactory;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Destination getJmsDestination(String jmsDestinationJndiName) throws ServiceLocatorException {
            Map map = lookupCache;
            synchronized (map) {
                if (lookupCache.containsKey(jmsDestinationJndiName)) {
                    return (Destination)lookupCache.get(jmsDestinationJndiName);
                }
                Destination jmsDestination = null;
                try {
                    InitialContext ctx = new InitialContext();
                    jmsDestination = (Destination)ctx.lookup(jmsDestinationJndiName);
                    lookupCache.put(jmsDestinationJndiName, jmsDestination);
                }
                catch (ClassCastException cce) {
                    throw new ServiceLocatorException(cce);
                }
                catch (NamingException ne) {
                    throw new ServiceLocatorException(ne);
                }
                return jmsDestination;
            }
        }
    }
}

