/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell;

import cz.nextiraone.tmobile.wintell.WintellOfferCategory;
import java.io.Serializable;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="BLAZE_STATS")
@NamedQueries(value={@NamedQuery(name="blazeStatsByMSISDN", query="SELECT OBJECT(x) FROM BlazeStats x WHERE x.id.msisdn = ?1")})
public class BlazeStats
implements Serializable {
    private static final long serialVersionUID = -1690730126245427342L;
    @EmbeddedId
    public Id statsId = new Id();
    int count;
    @ManyToOne
    @JoinColumn(name="OFFERCATEGORYID", insertable=false, updatable=false)
    private WintellOfferCategory offerCategory;

    public BlazeStats(Id statsId) {
        this.statsId = statsId;
        this.count = 0;
    }

    public BlazeStats(String msisdn, Integer categoryId, Date month) {
        this.statsId = new Id(msisdn, categoryId, month);
        this.count = 0;
    }

    public BlazeStats() {
        this.count = 0;
    }

    public Id getStatsId() {
        return this.statsId;
    }

    public void setStatsId(Id statsId) {
        this.statsId = statsId;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public WintellOfferCategory getOfferCategory() {
        return this.offerCategory;
    }

    public void setOfferCategory(WintellOfferCategory offerCategory) {
        this.offerCategory = offerCategory;
    }

    @Transient
    public boolean equals(Object o) {
        if (o != null && o instanceof BlazeStats) {
            BlazeStats that = (BlazeStats)o;
            return this.statsId.equals(that.statsId);
        }
        return false;
    }

    @Transient
    public int hashCode() {
        return this.statsId.hashCode();
    }

    @Embeddable
    public static class Id
    implements Serializable {
        private static final long serialVersionUID = -6925487827228727405L;
        @Column(name="MONTH", nullable=false, updatable=false, insertable=false)
        private Date month = null;
        @Column(name="MSISDN", nullable=false, updatable=false, insertable=false)
        private String msisdn = null;
        @Column(name="OFFERCATEGORYID")
        private Integer categoryId = null;

        public Id() {
        }

        public Id(String msisdn, Integer categoryId, Date month) {
            this.msisdn = msisdn;
            this.categoryId = categoryId;
            GregorianCalendar cal = null;
            cal = new GregorianCalendar();
            cal.setTime(month);
            cal.set(14, 0);
            cal.set(13, 0);
            cal.set(12, 0);
            cal.set(11, 0);
            cal.set(5, 1);
            this.month = cal.getTime();
        }

        @Transient
        public boolean equals(Object o) {
            if (o != null && o instanceof Id) {
                Id that = (Id)o;
                return this.month.equals(that.month) && this.msisdn.equals(that.msisdn) && this.categoryId.equals(that.categoryId);
            }
            return false;
        }

        @Transient
        public int hashCode() {
            return this.msisdn.hashCode() + this.categoryId.hashCode() + this.month.hashCode();
        }

        public Date getMonth() {
            return this.month;
        }

        public void setMonth(Date month) {
            this.month = month;
        }

        public String getMsisdn() {
            return this.msisdn;
        }

        public void setMsisdn(String msisdn) {
            this.msisdn = msisdn;
        }

        public Integer getCategoryId() {
            return this.categoryId;
        }

        public void setCategoryId(Integer categoryId) {
            this.categoryId = categoryId;
        }
    }
}

