/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell;

import cz.nextiraone.tmobile.wintell.MoreInfoItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="MOREINFO_GROUPS", uniqueConstraints={@UniqueConstraint(columnNames={"groupName"})})
public class MoreInfoGroup
implements Serializable {
    private static final long serialVersionUID = -7177763579813798539L;
    @Id
    @GeneratedValue(generator="MiGroupId")
    @SequenceGenerator(name="MiGroupId", sequenceName="SEQ_MI_GROUP", allocationSize=1)
    private int moreInfoGroupId;
    @Column(length=1000)
    private String groupName;
    @ManyToMany
    @JoinTable(name="MOREINFO_ASSN", joinColumns={@JoinColumn(name="moreInfoGroupId")}, inverseJoinColumns={@JoinColumn(name="moreInfoItemId")})
    private List<MoreInfoItem> moreInfoItems = new ArrayList<MoreInfoItem>();

    @Transient
    public void join(MoreInfoGroup g) {
        for (MoreInfoItem mi : g.getMoreInfoItems()) {
            this.moreInfoItems.add(mi);
        }
    }

    public int getMoreInfoGroupId() {
        return this.moreInfoGroupId;
    }

    public void setMoreInfoGroupId(int moreInfoGroupId) {
        this.moreInfoGroupId = moreInfoGroupId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public List<MoreInfoItem> getMoreInfoItems() {
        return this.moreInfoItems;
    }

    public void setMoreInfoItems(List<MoreInfoItem> moreInfoItems) {
        this.moreInfoItems = moreInfoItems;
    }

    @Transient
    public boolean equals(Object o) {
        if (o != null && o instanceof MoreInfoGroup) {
            MoreInfoGroup that = (MoreInfoGroup)o;
            return new Integer(this.moreInfoGroupId).equals(that.moreInfoGroupId);
        }
        return false;
    }

    @Transient
    public int hashCode() {
        return new Integer(this.moreInfoGroupId).hashCode();
    }
}

