/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell;

import cz.nextiraone.tmobile.wintell.context.WintellActionContext;
import cz.nextiraone.tmobile.wintell.events.GeneralEvent;
import cz.nextiraone.tmobile.wintell.request.WintellRequestStep;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="LOG_REQUEST")
public class RequestLog
implements Serializable {
    private static final long serialVersionUID = -8633683693278520174L;
    @EmbeddedId
    public Id id = new Id();
    @ManyToOne
    @JoinColumn(name="REQUEST_ID", nullable=false, updatable=false, insertable=false)
    private GeneralEvent event;
    @Column(name="XML", length=9999)
    private String xml;
    Date ts;
    String type;
    String state;
    Long ms;
    Integer delta;

    public RequestLog() {
    }

    public RequestLog(GeneralEvent e, Object o, String type, String state, WintellActionContext ctx) {
        this.setRequestStep(new WintellRequestStep(o, ctx));
        this.setType(type);
        this.setState(state);
        if (e != null) {
            this.setupEvent(e);
            this.setEvent(e);
            this.event.addLog(this);
        } else {
            this.id = new Id();
        }
    }

    public RequestLog(Long requestId, int pos, Object o, String type, String state, WintellActionContext ctx) {
        this.setRequestStep(new WintellRequestStep(o, ctx));
        this.setType(type);
        this.setState(state);
        this.id = new Id(requestId, pos);
    }

    @Transient
    public void setupEvent(GeneralEvent e) {
        this.id = new Id(e.getRequestId(), e.getLogReq().size());
    }

    public String getXml() {
        return this.xml;
    }

    public void setXml(String xml) {
        this.xml = xml;
    }

    @Transient
    public void setRequestStep(WintellRequestStep r) {
        this.xml = r.toString();
        this.setTs(new Date());
        this.ms = System.currentTimeMillis();
    }

    @Transient
    public int getPosition() {
        return this.id.position;
    }

    @Transient
    public String toString() {
        return this.xml;
    }

    public Date getTs() {
        return this.ts;
    }

    public void setTs(Date ts) {
        this.ts = ts;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public GeneralEvent getEvent() {
        return this.event;
    }

    public void setEvent(GeneralEvent event) {
        this.event = event;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Long getMs() {
        return this.ms;
    }

    public void setMs(Long ms) {
        this.ms = ms;
    }

    public Integer getDelta() {
        return this.delta;
    }

    public void setDelta(Integer delta) {
        this.delta = delta;
    }

    public Id getId() {
        return this.id;
    }

    public void setId(Id id) {
        this.id = id;
    }

    @Transient
    public boolean equals(Object o) {
        if (o != null && o instanceof RequestLog) {
            RequestLog that = (RequestLog)o;
            return this.id.equals(that.id);
        }
        return false;
    }

    @Transient
    public int hashCode() {
        return this.id.hashCode();
    }

    @Embeddable
    public static class Id
    implements Serializable {
        private static final long serialVersionUID = 8516471889773547325L;
        @Column(name="REQUEST_ID", nullable=false, updatable=false, insertable=false)
        private Long requestId = null;
        @Column(name="POSITION")
        private Integer position = null;

        public Id() {
        }

        public Id(Long requestId, Integer position) {
            this.requestId = requestId;
            this.position = position;
        }

        @Transient
        public boolean equals(Object o) {
            if (o != null && o instanceof Id) {
                Id that = (Id)o;
                return this.requestId.equals(that.requestId) && this.position.equals(that.position);
            }
            return false;
        }

        @Transient
        public int hashCode() {
            return this.requestId.hashCode() + this.position.hashCode();
        }

        @Transient
        public String toString() {
            return "[" + this.requestId + "/" + this.position + "]";
        }

        public Long getRequestId() {
            return this.requestId;
        }

        public void setRequestId(Long requestId) {
            this.requestId = requestId;
        }

        public Integer getPosition() {
            return this.position;
        }

        public void setPosition(Integer position) {
            this.position = position;
        }
    }
}

