/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell;

import cz.nextiraone.tmobile.wintell.WintellActionClass;
import java.io.Serializable;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="ACTION_BUTTONS")
public class WintellActionButton
implements Serializable {
    private static final long serialVersionUID = 4689596291592659879L;
    public static final int BUTTON_OPEN = 1;
    public static final int BUTTON_ACCEPT = 2;
    public static final int BUTTON_OFFER = 3;
    public static final int BUTTON_DECLINE = 4;
    public static final int BUTTON_AUTOMATIC = 10;
    @Id
    @Column(name="BUTTON_ID")
    private Integer buttonId;
    private String description;
    @Column(name="SINGLE_ACTION")
    private boolean isSingleAction;
    @ManyToMany
    @JoinTable(name="ACTION_TEMPLATE_BTN_CLASS", joinColumns={@JoinColumn(name="buttonId")}, inverseJoinColumns={@JoinColumn(name="ACT_C_TYPE"), @JoinColumn(name="ACT_C_SUB_TYPE")})
    private List<WintellActionClass> actionClasses;

    @Transient
    public boolean equals(Object o) {
        if (o != null && o instanceof WintellActionButton) {
            WintellActionButton that = (WintellActionButton)o;
            return this.buttonId.equals(that.buttonId);
        }
        return false;
    }

    @Transient
    public int hashCode() {
        return this.buttonId.hashCode();
    }

    @Transient
    public String toString() {
        switch (this.buttonId) {
            case 1: {
                return "BUTTON_OPEN";
            }
            case 2: {
                return "BUTTON_ACCEPT";
            }
            case 3: {
                return "BUTTON_OFFER";
            }
            case 4: {
                return "BUTTON_DECLINE";
            }
            case 10: {
                return "BUTTON_AUTOMATIC";
            }
        }
        return "BUTTON.Id=" + this.buttonId;
    }

    @Transient
    public boolean isCommonButton() {
        if (this.buttonId == 2) {
            return true;
        }
        if (this.buttonId == 3) {
            return true;
        }
        return this.buttonId == 4;
    }

    public Integer getButtonId() {
        return this.buttonId;
    }

    public void setButtonId(Integer buttonId) {
        this.buttonId = buttonId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<WintellActionClass> getActionClasses() {
        return this.actionClasses;
    }

    public void setActionClasses(List<WintellActionClass> actionClasses) {
        this.actionClasses = actionClasses;
    }

    @Transient
    public boolean isUrl() {
        return this.buttonId == 1;
    }

    public boolean isSingleAction() {
        return this.isSingleAction;
    }

    public void setSingleAction(boolean isSingleAction) {
        this.isSingleAction = isSingleAction;
    }
}

