/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell;

import cz.nextiraone.tmobile.wintell.MoreInfoGroup;
import cz.nextiraone.tmobile.wintell.WintellOfferCategory;
import cz.nextiraone.tmobile.wintell.WintellOfferr2Action;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="REGISTRY_OFFERS")
public class WintellOffer
implements Serializable {
    private static final long serialVersionUID = 1650351146015377414L;
    @Id
    @GeneratedValue(generator="OfferId")
    @SequenceGenerator(name="OfferId", sequenceName="SEQ_OFFER", allocationSize=1)
    private int offerId;
    private String description;
    private String offerType;
    @Column(name="SHORT_DESCRIPTION", length=80)
    private String shortDescription;
    @ManyToMany
    @JoinTable(name="OFFER_MINFO_ASSN", joinColumns={@JoinColumn(name="offerId")}, inverseJoinColumns={@JoinColumn(name="moreInfoGroupId")})
    private List<MoreInfoGroup> moreInfoGroups = new ArrayList<MoreInfoGroup>();
    @OneToMany(mappedBy="offer")
    @OrderBy(value="POSITION")
    private List<WintellOfferr2Action> actionButtons = new ArrayList<WintellOfferr2Action>();
    @ManyToMany
    @JoinTable(name="OFFER2CATEGORY", joinColumns={@JoinColumn(name="OFFERID")}, inverseJoinColumns={@JoinColumn(name="OFFERCATEGORYID")})
    private List<WintellOfferCategory> categories = new ArrayList<WintellOfferCategory>();
    @Column(name="DEFAULT_CSS_CLASSES")
    private String defaultCssClasses;
    @Column(nullable=false)
    private boolean isAutomatic = false;
    @Transient
    private transient Boolean webOpenable;

    public int getOfferId() {
        return this.offerId;
    }

    public void setOfferId(int offerId) {
        this.offerId = offerId;
    }

    @Transient
    public boolean isMessage() {
        if (this.offerType == null) {
            return false;
        }
        return this.offerType.equalsIgnoreCase("Text");
    }

    @Transient
    public MoreInfoGroup getMoreInfoGroup() {
        MoreInfoGroup ret = new MoreInfoGroup();
        for (MoreInfoGroup g : this.getMoreInfoGroups()) {
            ret.join(g);
        }
        return ret;
    }

    public List<MoreInfoGroup> getMoreInfoGroups() {
        return this.moreInfoGroups;
    }

    public void setMoreInfoGroups(List<MoreInfoGroup> moreInfoGroups) {
        this.moreInfoGroups = moreInfoGroups;
    }

    public List<WintellOfferCategory> getCategories() {
        return this.categories;
    }

    public void setCategories(List<WintellOfferCategory> categories) {
        this.categories = categories;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Transient
    public boolean isMoreInfo() {
        return !this.moreInfoGroups.isEmpty();
    }

    public String getOfferType() {
        return this.offerType;
    }

    public void setOfferType(String offerType) {
        this.offerType = offerType;
    }

    public List<WintellOfferr2Action> getActionButtons() {
        return this.actionButtons;
    }

    public void setActionButtons(List<WintellOfferr2Action> actionButtons) {
        this.actionButtons = actionButtons;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    public String getDefaultCssClasses() {
        return this.defaultCssClasses;
    }

    public void setDefaultCssClasses(String defaultCssClasses) {
        this.defaultCssClasses = defaultCssClasses;
    }

    @Transient
    public boolean equals(Object o) {
        if (o != null && o instanceof WintellOffer) {
            WintellOffer that = (WintellOffer)o;
            return this.offerId == that.offerId;
        }
        return false;
    }

    @Transient
    public int hashCode() {
        return new Integer(this.offerId).hashCode();
    }

    @Transient
    public boolean isWebOpenable() {
        if (this.webOpenable != null) {
            return this.webOpenable;
        }
        this.webOpenable = false;
        for (WintellOfferr2Action o2a : this.getActionButtons()) {
            if (!o2a.getAction().getActionClass().getClassType().equals("WEB")) continue;
            this.webOpenable = true;
            break;
        }
        return this.webOpenable;
    }

    @Transient
    public String getWebButtonName() {
        for (WintellOfferr2Action o2a : this.getActionButtons()) {
            if (!o2a.getAction().getActionClass().getClassType().equals("WEB")) continue;
            return o2a.getButton().getDescription();
        }
        return "BUTTON_NOT_FOUND";
    }

    @Transient
    public int getWebButtonId() {
        for (WintellOfferr2Action o2a : this.getActionButtons()) {
            if (!o2a.getAction().getActionClass().getClassType().equals("WEB")) continue;
            return o2a.getButton().getButtonId();
        }
        return -1;
    }

    @Transient
    public String toString() {
        return this.getClass().getSimpleName() + "(type=" + this.offerType + ",offerId=" + this.offerId + ",descr=" + this.description + ")";
    }

    public boolean isAutomatic() {
        return this.isAutomatic;
    }

    public void setAutomatic(boolean isAutomatic) {
        this.isAutomatic = isAutomatic;
    }
}

