/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell;

import cz.nextiraone.tmobile.wintell.MoreInfoItemValue;
import cz.nextiraone.tmobile.wintell.WintellActionOutput;
import cz.nextiraone.tmobile.wintell.WintellOffer;
import cz.nextiraone.tmobile.wintell.WintellOfferCategory;
import cz.nextiraone.tmobile.wintell.WintellOfferr2Action;
import cz.nextiraone.tmobile.wintell.events.GeneralEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="OFFER_ACTIVITIES")
@NamedQueries(value={@NamedQuery(name="offerActivityByOfferForPressed", query="SELECT x FROM WintellOfferActivity x WHERE x.offer.offerId = :offerId and someButtonPressed=1 and x.objectId = :objectId and x.objectType = :objectType order by x.offerActivityId desc"), @NamedQuery(name="offerActivityForPressed", query="SELECT x FROM WintellOfferActivity x WHERE someButtonPressed=1 and x.objectId = :objectId and x.objectType = :objectType order by x.offerActivityId")})
public class WintellOfferActivity
implements Serializable {
    private static final long serialVersionUID = 8853114733414499497L;
    @Id
    @GeneratedValue(generator="OfferActivityId")
    @SequenceGenerator(name="OfferActivityId", sequenceName="SEQ_OFFER_ACTIVITY", allocationSize=1)
    private long offerActivityId;
    private boolean accepted;
    private boolean offered;
    private boolean declined;
    private boolean moreInfoOpened;
    private Boolean someButtonPressed = false;
    private Boolean disabled = false;
    private Integer priority;
    @ManyToOne
    @JoinColumn(name="OFFERID", nullable=false)
    private WintellOffer offer;
    @ManyToOne
    @JoinColumn(name="offerCategoryId", nullable=false)
    private WintellOfferCategory offerCategory;
    @Column(name="OBJECT_ID")
    private String objectId;
    @Column(name="OBJECT_TYPE")
    private int objectType;
    @ManyToOne
    @JoinColumn(name="REQUEST_ID", nullable=false)
    private GeneralEvent event;
    @OneToMany(mappedBy="offerActivity")
    private List<MoreInfoItemValue> moreInfoValues = new ArrayList<MoreInfoItemValue>();
    @OneToMany(mappedBy="offerActivity")
    private List<WintellActionOutput> actionActivities = new ArrayList<WintellActionOutput>();
    private Date dateTime = new Date();
    @Column(name="CSS_CLASSES")
    private String cssClasses;

    @Transient
    public void addMoreInfoValue(MoreInfoItemValue miV) {
        miV.setOfferActivity(this);
        this.moreInfoValues.add(miV);
        this.setMoreInfoOpened(true);
    }

    @Transient
    public void addActionOutput(WintellActionOutput aO) {
        aO.setOfferActivity(this);
        this.actionActivities.add(aO);
    }

    @Transient
    public boolean isMoreInfo() {
        return this.offer.isMoreInfo();
    }

    @Transient
    public boolean isMoreInfoStored() {
        return this.moreInfoOpened;
    }

    @Transient
    public String getUsr() {
        return this.event.getUsr();
    }

    @Transient
    public String toString() {
        return this.getClass().getSimpleName() + "(id=" + this.offerActivityId + ",offer=" + this.offer + ")";
    }

    @Transient
    public String getDescription() {
        return this.offer.getDescription();
    }

    @Transient
    public boolean isMessage() {
        if (this.offer == null) {
            return true;
        }
        return this.offer.isMessage();
    }

    @Transient
    public boolean isAcceptable() {
        return this.isButtonPresent(2) || this.isWebOpenable();
    }

    @Transient
    public boolean isOfferable() {
        return this.isButtonPresent(3);
    }

    @Transient
    public boolean isDeclinable() {
        return this.isButtonPresent(4);
    }

    @Transient
    public boolean isWebOpenable() {
        return this.getOffer().isWebOpenable();
    }

    @Transient
    public String getWebButtonName() {
        return this.getOffer().getWebButtonName();
    }

    @Transient
    public int getWebButtonId() {
        return this.getOffer().getWebButtonId();
    }

    @Transient
    public boolean isButtonPresent(int buttonId) {
        for (WintellOfferr2Action o2a : this.getOffer().getActionButtons()) {
            if (o2a.getButton().getButtonId() != buttonId) continue;
            return true;
        }
        return false;
    }

    public long getOfferActivityId() {
        return this.offerActivityId;
    }

    public void setOfferActivityId(long offerActivityId) {
        this.offerActivityId = offerActivityId;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public void setAccepted(boolean accepted) {
        this.accepted = accepted;
    }

    public boolean isOffered() {
        return this.offered;
    }

    public void setOffered(boolean offered) {
        this.offered = offered;
    }

    public boolean isDeclined() {
        return this.declined;
    }

    public void setDeclined(boolean declined) {
        this.declined = declined;
    }

    public WintellOffer getOffer() {
        return this.offer;
    }

    public void setOffer(WintellOffer offer) {
        this.offer = offer;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public int getObjectType() {
        return this.objectType;
    }

    public void setObjectType(int objectType) {
        this.objectType = objectType;
    }

    public Date getDateTime() {
        if (this.dateTime == null) {
            return new Date();
        }
        return this.dateTime;
    }

    public void setDateTime(Date dateTime) {
        this.dateTime = dateTime;
    }

    public GeneralEvent getEvent() {
        return this.event;
    }

    public void setEvent(GeneralEvent event) {
        this.event = event;
    }

    public List<MoreInfoItemValue> getMoreInfoValues() {
        return this.moreInfoValues;
    }

    public void setMoreInfoValues(List<MoreInfoItemValue> moreInfoValues) {
        this.moreInfoValues = moreInfoValues;
    }

    public List<WintellActionOutput> getActionActivities() {
        return this.actionActivities;
    }

    public void setActionActivities(List<WintellActionOutput> actionActivities) {
        this.actionActivities = actionActivities;
    }

    public WintellOfferCategory getOfferCategory() {
        return this.offerCategory;
    }

    public void setOfferCategory(WintellOfferCategory offerCategory) {
        this.offerCategory = offerCategory;
    }

    public boolean isMoreInfoOpened() {
        return this.moreInfoOpened;
    }

    public void setMoreInfoOpened(boolean moreInfoOpened) {
        this.moreInfoOpened = moreInfoOpened;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public boolean isSomeButtonPressed() {
        if (this.someButtonPressed == null) {
            return false;
        }
        return this.someButtonPressed;
    }

    public void setSomeButtonPressed(boolean someButtonPressed) {
        this.someButtonPressed = someButtonPressed;
    }

    public boolean isDisabled() {
        if (this.disabled == null) {
            return false;
        }
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public String getCssClasses() {
        return this.cssClasses;
    }

    public void setCssClasses(String cssClasses) {
        this.cssClasses = cssClasses;
    }

    @Transient
    public boolean equals(Object o) {
        if (o != null && o instanceof WintellOfferActivity) {
            WintellOfferActivity that = (WintellOfferActivity)o;
            return this.offerActivityId == that.offerActivityId;
        }
        return false;
    }

    @Transient
    public int hashCode() {
        return new Long(this.offerActivityId).hashCode();
    }

    @Transient
    public boolean isButtonPressed(int buttonId) {
        switch (buttonId) {
            case 2: {
                return this.isAccepted();
            }
            case 4: {
                return this.isDeclined();
            }
            case 3: {
                return this.isOffered();
            }
        }
        for (WintellActionOutput ao : this.getActionActivities()) {
            if (ao.getButton().getButtonId() != buttonId || ao.getActions().isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Transient
    public boolean isSubmitable() {
        return !this.isAccepted() && !this.isDeclined() && !this.isMessage() && !this.isDisabled();
    }

    @Transient
    public String extendClasses(String c) {
        if (this.cssClasses == null) {
            return c;
        }
        return c + " " + this.cssClasses;
    }
}

