/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell;

import cz.nextiraone.tmobile.wintell.WintellOfferActivity;
import cz.nextiraone.tmobile.wintell.WintellOfferCategory;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class WintellOfferActivityCategory
implements Serializable {
    private static final long serialVersionUID = 6332860646709671596L;
    private List<WintellOfferActivity> offers;
    private WintellOfferCategory category;
    private Boolean containsOfferB = null;
    private Boolean containsNonDisabledOfferB = null;

    public WintellOfferActivityCategory(WintellOfferCategory type, List<WintellOfferActivity> o) {
        this.setCategory(type);
        this.setOffers(o);
    }

    public String getType() {
        if (this.category == null) {
            return null;
        }
        return this.category.getName();
    }

    public List<WintellOfferActivity> getOffers() {
        if (this.offers != null) {
            Collections.sort(this.offers, new OfferActivitySort());
        }
        return this.offers;
    }

    public void setOffers(List<WintellOfferActivity> offers) {
        this.containsOfferB = null;
        this.containsNonDisabledOfferB = null;
        this.offers = offers;
    }

    public boolean containsOffer() {
        if (this.containsOfferB != null) {
            return this.containsOfferB;
        }
        this.containsOfferB = false;
        for (WintellOfferActivity o : this.getOffers()) {
            if (o.isMessage()) continue;
            this.containsOfferB = true;
            break;
        }
        return this.containsOfferB;
    }

    public boolean containsNonDisabledOffer() {
        if (this.containsNonDisabledOfferB != null) {
            return this.containsNonDisabledOfferB;
        }
        this.containsNonDisabledOfferB = false;
        for (WintellOfferActivity o : this.getOffers()) {
            if (o.isDisabled()) continue;
            this.containsNonDisabledOfferB = true;
            break;
        }
        return this.containsNonDisabledOfferB;
    }

    public String toString() {
        return this.getType();
    }

    public WintellOfferCategory getCategory() {
        return this.category;
    }

    public void setCategory(WintellOfferCategory category) {
        this.category = category;
    }

    public int getPriority() {
        if (this.getOffers() != null && !this.getOffers().isEmpty()) {
            return this.getOffers().get(0).getPriority();
        }
        return -1;
    }

    public String getDescription() {
        return this.getType();
    }

    public Integer getCategoryId() {
        return this.category.getOfferCategoryId();
    }

    public static class OfferActivitySort<T>
    implements Comparator<T> {
        @Override
        public int compare(Object obj1, Object obj2) {
            Integer i2;
            Integer i1 = ((WintellOfferActivity)obj1).getPriority();
            int ret = i1.compareTo(i2 = ((WintellOfferActivity)obj2).getPriority());
            if (ret == 0) {
                try {
                    i1 = ((WintellOfferActivity)obj1).getOffer().getOfferId();
                    i2 = ((WintellOfferActivity)obj2).getOffer().getOfferId();
                    ret = i1.compareTo(i2);
                }
                catch (Exception er) {
                    // empty catch block
                }
            }
            return -ret;
        }
    }
}

