/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell;

import cz.nextiraone.tmobile.wintell.events.AgsEvent;
import java.io.Serializable;
import java.util.Date;
import java.util.Set;
import java.util.TreeSet;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="WINTELL_SESSIONS")
public class WintellSession
implements Serializable {
    private static final long serialVersionUID = -7093355319263669969L;
    @Id
    @GeneratedValue(generator="SessionId")
    @SequenceGenerator(name="SessionId", sequenceName="SEQ_SESSION", allocationSize=1)
    private long sessionId;
    private String username;
    private Date sessionStart;
    private Date sessionStop;
    @OneToMany(mappedBy="session")
    private Set<AgsEvent> wintellEvents = new TreeSet<AgsEvent>();
    @Column(name="OBJECT_ID")
    private String objectId;
    @Column(name="OBJECT_TYPE")
    private int objectType;

    public WintellSession() {
    }

    public WintellSession(String user, String objectId, int objectType) {
        this.setUsername(new String(user));
        this.objectId = new String(objectId);
        this.objectType = objectType;
        this.sessionStart = new Date();
    }

    public Set<AgsEvent> getWintellEvents() {
        return this.wintellEvents;
    }

    public void setWintellEvents(Set<AgsEvent> wintellEvents) {
        this.wintellEvents = wintellEvents;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public int getObjectType() {
        return this.objectType;
    }

    public void setObjectType(int objectType) {
        this.objectType = objectType;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(long msessionId) {
        this.sessionId = msessionId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String musername) {
        this.username = musername;
    }

    public Date getSessionStart() {
        return this.sessionStart;
    }

    public void setSessionStart(Date msessionStart) {
        this.sessionStart = msessionStart;
    }

    public Date getSessionStop() {
        return this.sessionStop;
    }

    public void setSessionStop(Date msessionStop) {
        this.sessionStop = msessionStop;
    }

    @Transient
    public String toString() {
        String ret = "";
        ret = ret + "sessionId=" + Long.toString(this.sessionId);
        ret = ret + ",username='" + this.username + "'";
        if (this.sessionStart != null) {
            ret = ret + ",sessionStart=" + this.sessionStart.toString();
        }
        if (this.sessionStop != null) {
            ret = ret + ",sessionStop=" + this.sessionStop.toString();
        }
        return ret;
    }

    @Transient
    public void addEvent(AgsEvent e) {
        this.wintellEvents.add(e);
    }

    @Transient
    public boolean equals(Object o) {
        if (o != null && o instanceof WintellSession) {
            WintellSession that = (WintellSession)o;
            return this.sessionId == that.sessionId;
        }
        return false;
    }

    @Transient
    public int hashCode() {
        return new Long(this.sessionId).hashCode();
    }
}

