/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell.events;

import cz.nextiraone.tmobile.wintell.WintellSession;
import cz.nextiraone.tmobile.wintell.context.WintellActionContext;
import cz.nextiraone.tmobile.wintell.events.EventField;
import cz.nextiraone.tmobile.wintell.events.GeneralEvent;
import java.io.Serializable;
import java.util.Map;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PostPersist;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.log4j.Logger;

@Inheritance(strategy=InheritanceType.JOINED)
@Entity
@Table(name="EVENT_Ags")
public class AgsEvent
extends GeneralEvent
implements Serializable {
    static Logger log = Logger.getLogger(AgsEvent.class);
    private static final long serialVersionUID = -983203761387960724L;
    @EventField(name="IRP_TAG", descr="IRP tag", mandatory=false)
    public String irpTag;
    @EventField(name="SUID", exVal="2322982", descr="Calling party identification [string]. At least one of MSISDN and EXTID_SU must be specified")
    public String suid;
    @ManyToOne
    @JoinColumn(name="sessionId", nullable=true)
    private WintellSession session;

    public AgsEvent() {
    }

    @PrePersist
    public void PrePersist() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("@PrePersist: id=" + this.getRequestId()));
        }
    }

    @PostPersist
    public void PostPersist() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("@PostPersist: id=" + this.getRequestId()), new Throwable());
        }
    }

    @Transient
    public String getMessageName() {
        return null;
    }

    public WintellSession getSession() {
        return this.session;
    }

    public void setSession(WintellSession msession) {
        this.session = msession;
    }

    @Transient
    public String toString() {
        return this.getMessageName() + ":" + this.getTs();
    }

    @Transient
    public long getSessionId() {
        if (this.session == null) {
            return -1L;
        }
        return this.session.getSessionId();
    }

    public AgsEvent(Map<String, String> params, WintellActionContext ctx) throws Exception {
        this.setFields(this.getClass().getFields(), params, ctx);
    }

    public String getSuid() {
        return this.suid;
    }

    public void setSuid(String suid) {
        this.suid = suid;
    }

    public String getIrpTag() {
        return this.irpTag;
    }

    public void setIrpTag(String irpTag) {
        this.irpTag = irpTag;
    }
}

