/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell.events;

import cz.nextiraone.tmobile.wintell.RequestLog;
import cz.nextiraone.tmobile.wintell.WintellOfferActivity;
import cz.nextiraone.tmobile.wintell.WintellOfferActivityCategory;
import cz.nextiraone.tmobile.wintell.WintellOfferCategory;
import cz.nextiraone.tmobile.wintell.context.WintellActionContext;
import cz.nextiraone.tmobile.wintell.events.EventField;
import cz.nextiraone.tmobile.wintell.logger.WintellLogger;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;

@Inheritance(strategy=InheritanceType.JOINED)
@Entity
@Table(name="EVENT_General")
public class GeneralEvent
implements Serializable,
Comparable<GeneralEvent> {
    private static final long serialVersionUID = -7361956846447952665L;
    private static final WintellLogger log = WintellLogger.getLogger(GeneralEvent.class);
    public static final int TYPE_STRING = 0;
    public static final int TYPE_INT = 1;
    public static final int TYPE_YYYYMMDD = 2;
    public static final int TYPE_YYYYMMDDHHNNSS = 3;
    public static final int TYPE_TS = 4;
    protected static Pattern dateYYYYMMDDHHMISS = Pattern.compile("(\\d{4})(\\d{2})(\\d{2})(\\d{2})(\\d{2})(\\d{2})");
    protected static Pattern dateYYYYMMDD = Pattern.compile("(\\d{4})(\\d{2})(\\d{2})");
    protected static Pattern dateINT = Pattern.compile("\\d+");
    @Id
    @GeneratedValue(generator="ReqId")
    @SequenceGenerator(name="ReqId", sequenceName="SEQ_REQ", allocationSize=1)
    @Column(name="REQUEST_ID")
    private Long requestId = null;
    @EventField(name="EV", descr="Name of the event")
    public String ev;
    @EventField(name="CH", descr="Channel name CUI/CLARIFY/BPA")
    public String ch;
    @EventField(name="TS", type=4, descr="TimeStamp in case of\n if ch==CUI|BPA: long,\n if ch==CLARIFY: YYYYMMDDHHMISS")
    public Date ts;
    @EventField(name="MSISDN", exVal="603164549", descr="Calling party identification [string]. At least one of MSISDN and EXTID_SU must be specified", mandatory=false)
    public String msisdn;
    @EventField(name="INTERID", exVal="CLF080121117455", descr="Interaction ID [string]", mandatory=false)
    public String interid;
    @EventField(name="PIN", descr="User PIN identification", mandatory=false)
    public String pin;
    @EventField(name="USR", descr="User identification")
    public String usr;
    @OneToMany
    @JoinColumn(name="REQUEST_ID")
    private List<WintellOfferActivity> offers = new ArrayList<WintellOfferActivity>();
    @Column(name="OBJECT_ID")
    private String objectId;
    @Column(name="OBJECT_TYPE")
    private int objectType;
    @OneToMany(mappedBy="event")
    @OrderColumn(name="POSITION")
    private List<RequestLog> logReq = new ArrayList<RequestLog>();

    public List<WintellOfferActivity> getOffers() {
        return this.offers;
    }

    public void setOffers(List<WintellOfferActivity> offers) {
        this.offers = offers;
    }

    @Transient
    public Integer addLog(RequestLog r) {
        if (this.logReq.size() > 0) {
            RequestLog last = this.logReq.get(this.logReq.size() - 1);
            r.setDelta((int)(r.getMs() - last.getMs()));
        }
        this.logReq.add(r);
        return this.logReq.size();
    }

    @Transient
    public void addOffer(WintellOfferActivity o, WintellActionContext ctx) {
        if (this.offers == null) {
            this.offers = new ArrayList<WintellOfferActivity>();
            log.error(ctx, "new ArrayList<WintellOffer>()");
        }
        this.offers.add(o);
    }

    @Transient
    public List<WintellOfferActivityCategory> getOfferTypes() {
        ArrayList<WintellOfferActivityCategory> ret = new ArrayList<WintellOfferActivityCategory>();
        HashMap<WintellOfferCategory, ArrayList<WintellOfferActivity>> map = new HashMap<WintellOfferCategory, ArrayList<WintellOfferActivity>>();
        for (WintellOfferActivity wintellOfferActivity : this.offers) {
            ArrayList<WintellOfferActivity> lo = (ArrayList<WintellOfferActivity>)map.get(wintellOfferActivity.getOfferCategory());
            if (lo == null) {
                lo = new ArrayList<WintellOfferActivity>();
                map.put(wintellOfferActivity.getOfferCategory(), lo);
            }
            lo.add(wintellOfferActivity);
        }
        for (Map.Entry entry : map.entrySet()) {
            ret.add(new WintellOfferActivityCategory((WintellOfferCategory)entry.getKey(), (List)entry.getValue()));
        }
        Collections.sort(ret, new CategorySort());
        return ret;
    }

    @Transient
    public List<WintellOfferActivity> getMessages() {
        ArrayList<WintellOfferActivity> ret = new ArrayList<WintellOfferActivity>();
        for (WintellOfferActivity o : this.offers) {
            if (!o.isMessage()) continue;
            ret.add(o);
        }
        return ret;
    }

    public Long getRequestId() {
        return this.requestId;
    }

    public void setRequestId(Long requestId) {
        this.requestId = requestId;
    }

    public String getEv() {
        return this.ev;
    }

    public void setEv(String ev) {
        this.ev = ev;
    }

    public String getCh() {
        return this.ch;
    }

    public void setCh(String ch) {
        this.ch = ch;
    }

    public Date getTs() {
        return this.ts;
    }

    public void setTs(Date ts) {
        this.ts = ts;
    }

    public String getMsisdn() {
        return this.msisdn;
    }

    public void setMsisdn(String msisdn) {
        this.msisdn = msisdn;
    }

    public List<RequestLog> getLogReq() {
        return this.logReq;
    }

    public void setLogReq(List<RequestLog> logReq) {
        this.logReq = logReq;
    }

    public String getInterid() {
        return this.interid;
    }

    public void setInterid(String interid) {
        this.interid = interid;
    }

    public String getPin() {
        return this.pin;
    }

    public void setPin(String pin) {
        this.pin = pin;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public int getObjectType() {
        return this.objectType;
    }

    public void setObjectType(int objectType) {
        this.objectType = objectType;
    }

    public String getUsr() {
        return this.usr;
    }

    public void setUsr(String usr) {
        this.usr = usr;
    }

    @Transient
    protected void setFields(Field[] declaredFields, Map<String, String> params, WintellActionContext ctx) throws Exception {
        block6: for (Field f : declaredFields) {
            EventField ef = f.getAnnotation(EventField.class);
            if (ef == null) continue;
            String fn = ef.name();
            if (!params.containsKey(fn)) {
                if (ef.mandatory()) {
                    throw new Exception("the param: '" + fn + "' is mandatory");
                }
                log.debug(ctx, "the param: '" + fn + "' not contained & is not mandatory");
                continue;
            }
            String p = params.get(fn);
            Integer tx = ef.type();
            if (tx == 4) {
                String chP = params.get("CH");
                if (chP == null) continue;
                if (chP.equals("CLARIFY")) {
                    tx = 3;
                }
            }
            if (tx != 0 && p.length() == 0) {
                log.debug(ctx, "unexpected value='', just a number is expected as " + fn);
                continue;
            }
            Matcher m = null;
            Calendar c = null;
            switch (tx) {
                case 4: {
                    m = dateINT.matcher(p);
                    if (!m.matches()) {
                        throw new Exception("unexpected value='" + p + "', just a number is expected as " + fn);
                    }
                    f.set(this, new Date(new Long(p)));
                    continue block6;
                }
                case 2: {
                    m = dateYYYYMMDD.matcher(p);
                    if (!m.matches()) {
                        throw new Exception("unexpected value='" + p + "', expected is YYYYMMDD as " + fn);
                    }
                    c = Calendar.getInstance();
                    c.set(Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2)) - 1, Integer.parseInt(m.group(3)));
                    f.set(this, c.getTime());
                    c = null;
                    continue block6;
                }
                case 3: {
                    m = dateYYYYMMDDHHMISS.matcher(p);
                    if (!m.matches()) {
                        throw new Exception("unexpected value='" + p + "', expected is YYYYMMDDHHMISS as " + fn);
                    }
                    c = Calendar.getInstance();
                    c.set(Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2)) - 1, Integer.parseInt(m.group(3)), Integer.parseInt(m.group(4)), Integer.parseInt(m.group(5)), Integer.parseInt(m.group(6)));
                    f.set(this, c.getTime());
                    c = null;
                    continue block6;
                }
                case 1: {
                    f.set(this, Integer.parseInt(p));
                    continue block6;
                }
                default: {
                    if (p == null) {
                        f.set(this, p);
                        continue block6;
                    }
                    f.set(this, new String(p));
                }
            }
        }
    }

    @Transient
    public boolean equals(Object o) {
        if (o != null && o instanceof GeneralEvent) {
            GeneralEvent that = (GeneralEvent)o;
            return this.requestId == that.requestId;
        }
        return false;
    }

    @Transient
    public int hashCode() {
        return this.requestId.hashCode();
    }

    @Override
    @Transient
    public int compareTo(GeneralEvent o) {
        return this.requestId.compareTo(o.getRequestId());
    }

    public static class CategorySort<T>
    implements Comparator<T> {
        @Override
        @Transient
        public int compare(Object obj1, Object obj2) {
            Integer i2;
            Integer i1 = ((WintellOfferActivityCategory)obj1).getPriority();
            int ret = i1.compareTo(i2 = Integer.valueOf(((WintellOfferActivityCategory)obj2).getPriority()));
            if (ret == 0) {
                try {
                    i1 = ((WintellOfferActivityCategory)obj1).getCategory().getOfferCategoryId();
                    i2 = ((WintellOfferActivityCategory)obj2).getCategory().getOfferCategoryId();
                    ret = i1.compareTo(i2);
                }
                catch (Exception er) {
                    // empty catch block
                }
            }
            return -ret;
        }
    }
}

