/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell;

import cz.nextiraone.tmobile.wintell.BlazePlatfomSwitch;
import cz.nextiraone.tmobile.wintell.IAGSBlaze;
import cz.nextiraone.tmobile.wintell.ags.AGSBusiness;
import cz.nextiraone.tmobile.wintell.ags.model.ActionValidationInput;
import cz.nextiraone.tmobile.wintell.ags.model.ActionValidationOutput;
import cz.nextiraone.tmobile.wintell.ags.model.Request;
import cz.nextiraone.tmobile.wintell.ags.model.Response;
import cz.nextiraone.tmobile.wintell.context.WintellActionContext;
import cz.nextiraone.tmobile.wintell.events.AgsEvent;
import cz.nextiraone.tmobile.wintell.exceptions.WintellAppException;
import cz.nextiraone.tmobile.wintell.logger.WintellLogger;
import javax.annotation.PreDestroy;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;

@Stateless(name="AGSBlaze")
@Local(value={IAGSBlaze.class})
public class AGSBlaze
implements IAGSBlaze {
    public static final String DEFAULT_PLATFORM = "AGSProduction";
    private static final WintellLogger log = WintellLogger.getLogger(AGSBlaze.class);
    private long printLevel = 255L;
    private long printTarget = 2L;
    private long printEvent = 63L;
    @EJB(lookup="java:global/AGSBean/AGSBean/wintell/AGSBean")
    private AGSBusiness _server = null;

    protected static Context getInitialContext() throws Exception {
        return new InitialContext();
    }

    @PreDestroy
    public void destroyBean() {
    }

    private void ensureConnected(WintellActionContext actionContext) throws WintellAppException {
        if (this._server == null) {
            log.info(actionContext, "Trying to connect to blaze...");
            try {
                Context ctx = AGSBlaze.getInitialContext();
                this._server = (AGSBusiness)ctx.lookup("java:global/AGSBean/AGSBean/wintell/AGSBean");
            }
            catch (Exception e) {
                this._server = null;
                log.fatal(actionContext, "Exception when connecting to Blaze: " + e.getMessage(), (Throwable)e);
                throw new WintellAppException(e);
            }
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public Response invokeacceptCaseDebugEP(String platform, Request request, WintellActionContext ctx) throws WintellAppException {
        this.ensureConnected(ctx);
        try {
            Response response = this._server.invokeacceptCaseDebugEP(platform, request, this.printLevel, this.printTarget, this.printEvent);
            return response;
        }
        catch (Exception e) {
            throw new WintellAppException(e);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public Response invokefindCallerDebugEP(String platform, Request request, WintellActionContext ctx) throws WintellAppException {
        this.ensureConnected(ctx);
        try {
            Response response = this._server.invokefindCallerDebugEP(platform, request, this.printLevel, this.printTarget, this.printEvent);
            return response;
        }
        catch (Exception e) {
            throw new WintellAppException(e);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public Response invokesaveCaseDebugEP(String platform, Request request, WintellActionContext ctx) throws WintellAppException {
        this.ensureConnected(ctx);
        try {
            Response response = this._server.invokesaveCaseDebugEP(platform, request, this.printLevel, this.printTarget, this.printEvent);
            return response;
        }
        catch (Exception e) {
            throw new WintellAppException(e);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public ActionValidationOutput invokeactionValidationEP(String platform, ActionValidationInput request, WintellActionContext ctx) throws WintellAppException {
        this.ensureConnected(ctx);
        try {
            ActionValidationOutput response = this._server.invokeactionValidationEP(platform, request);
            return response;
        }
        catch (Exception e) {
            throw new WintellAppException(e);
        }
    }

    @Override
    public long getPrintLevel() {
        return this.printLevel;
    }

    @Override
    public void setPrintLevel(long printLevel) {
        this.printLevel = printLevel;
    }

    @Override
    public long getPrintTarget() {
        return this.printTarget;
    }

    @Override
    public void setPrintTarget(long printTarget) {
        this.printTarget = printTarget;
    }

    @Override
    public long getPrintEvent() {
        return this.printEvent;
    }

    @Override
    public void setPrintEvent(long printEvent) {
        this.printEvent = printEvent;
    }

    public static String testSwitchPlatform(EntityManager em, AgsEvent e, WintellActionContext ctx) {
        String platform = null;
        if (platform == null) {
            platform = AGSBlaze.testSwitchPlatform(em, "MSISDN", e.getMsisdn(), ctx);
        }
        if (platform == null) {
            platform = AGSBlaze.testSwitchPlatform(em, "USER", e.getUsr(), ctx);
        }
        return platform;
    }

    private static String testSwitchPlatform(EntityManager em, String type, String id, WintellActionContext ctx) {
        BlazePlatfomSwitch plSwitch = (BlazePlatfomSwitch)em.find(BlazePlatfomSwitch.class, BlazePlatfomSwitch.newId((String)type, (String)id));
        String platform = null;
        if (plSwitch != null) {
            platform = plSwitch.getPlatform();
            log.info(ctx, "platform: " + platform + ", was used based on " + type + " params");
        }
        return platform;
    }
}

