/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell;

import cz.nextiraone.tmobile.wintell.BlazeStatsLocal;
import cz.nextiraone.tmobile.wintell.BlazeStatsMessage;
import cz.nextiraone.tmobile.wintell.context.DefaultWintellActionContext;
import cz.nextiraone.tmobile.wintell.context.WintellActionContext;
import cz.nextiraone.tmobile.wintell.context.WintellSubprojectEnum;
import cz.nextiraone.tmobile.wintell.logger.WintellLogger;
import cz.nextiraone.tmobile.wintell.logger.identifiers.LogIdFactory;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.EJB;
import javax.ejb.MessageDriven;
import javax.ejb.MessageDrivenContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;

@MessageDriven(activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Queue"), @ActivationConfigProperty(propertyName="destination", propertyValue="queue/wintell/BlazeLogQueue"), @ActivationConfigProperty(propertyName="acknowledgeMode", propertyValue="AUTO_ACKNOWLEDGE"), @ActivationConfigProperty(propertyName="minSession", propertyValue="4")})
public class BlazeStatsMDB
implements MessageListener {
    private static final WintellLogger log = WintellLogger.getLogger(BlazeStatsMDB.class);
    private static final WintellActionContext systemActionContext = new DefaultWintellActionContext(WintellSubprojectEnum.NONE, LogIdFactory.createSystemId());
    @EJB
    BlazeStatsLocal blazeStats;
    @Resource
    private MessageDrivenContext context;

    public void onMessage(Message message) {
        if (log.isDebugEnabled()) {
            log.debug(systemActionContext, "consumerMDB");
        }
        long entry = new Date().getTime();
        WintellActionContext ctx = systemActionContext;
        if (message instanceof ObjectMessage) {
            ObjectMessage om = (ObjectMessage)message;
            Serializable o = null;
            try {
                o = om.getObject();
                String corelationId = om.getJMSCorrelationID();
                if (corelationId == null) {
                    log.error(systemActionContext, "corelationId=null");
                    corelationId = "NONE:0";
                }
                WintellSubprojectEnum prj = WintellSubprojectEnum.valueOf((String)corelationId.split(":")[0]);
                ctx = new DefaultWintellActionContext(prj, LogIdFactory.createJmsMessageId((String)(String.valueOf(om.getJMSCorrelationID()) + "/" + om.getJMSMessageID())));
            }
            catch (JMSException e1) {
                log.error(systemActionContext, "Got JMSException while getting object from message.", (Throwable)e1);
                this.context.setRollbackOnly();
                return;
            }
            if (!(o instanceof BlazeStatsMessage)) {
                log.info(ctx, " not instance of " + BlazeStatsMessage.class.getSimpleName());
                this.context.setRollbackOnly();
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug(ctx, "casting to " + BlazeStatsMessage.class.getSimpleName());
            }
            BlazeStatsMessage p = (BlazeStatsMessage)o;
            try {
                String cats;
                if (p.getVisitedCategories() != null) {
                    if (log.isDebugEnabled()) {
                        cats = "";
                        for (Integer categoryId : p.getVisitedCategories()) {
                            if (!"".equals(cats)) {
                                cats = String.valueOf(cats) + ",";
                            }
                            cats = String.valueOf(cats) + categoryId;
                        }
                        log.debug(ctx, "MSISDN=" + p.getMsisdn() + ", cats=" + cats);
                    }
                    this.blazeStats.increment(p.getMsisdn(), p.getVisitedCategories());
                } else {
                    if (log.isDebugEnabled()) {
                        cats = "";
                        for (Map.Entry<Integer, Integer> categoryIdCount : p.getIncrementCategories().entrySet()) {
                            Integer categoryId = categoryIdCount.getKey();
                            Integer count = categoryIdCount.getValue();
                            if (!"".equals(cats)) {
                                cats = String.valueOf(cats) + ",";
                            }
                            cats = String.valueOf(cats) + "[cat=" + categoryId + ",count=" + count + "]";
                        }
                        log.debug(ctx, "MSISDN=" + p.getMsisdn() + ", cats=" + cats);
                    }
                    this.blazeStats.increment(p.getMsisdn(), p.getIncrementCategories());
                }
                log.info(ctx, "done (deltaDelivery=" + (new Date().getTime() - om.getJMSTimestamp()) + "ms, process=" + (new Date().getTime() - entry) + "ms) for msisdn=" + p.getMsisdn());
                return;
            }
            catch (Exception e) {
                log.info(ctx, "catch exeption:" + e.getClass().getSimpleName());
            }
        }
        this.context.setRollbackOnly();
    }
}

