/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell;

import cz.nextiraone.tmobile.wintell.context.WintellActionContext;
import cz.nextiraone.tmobile.wintell.logger.WintellLogger;
import cz.nextiraone.tmobile.wintell.utils.HttpSessionContext;
import java.io.IOException;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.annotations.web.Filter;
import org.jboss.seam.web.AbstractFilter;

@Install(value=false, precedence=0)
@BypassInterceptors
@Startup
@Scope(value=ScopeType.APPLICATION)
@Filter
@Name(value="cz.nextiraone.tmobile.wintell.characterEncodingFilter")
public class CharacterEncodingFilter
extends AbstractFilter {
    private static WintellLogger log = WintellLogger.getLogger(CharacterEncodingFilter.class);
    private String encoding;
    private String urlRegexp;
    private boolean overrideClient;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (this.encoding != null && (this.overrideClient || request.getCharacterEncoding() == null) && this.pathMatches(request)) {
            request.setCharacterEncoding(this.encoding);
            Map reqMap = request.getParameterMap();
            if (log.isDebugEnabled()) {
                HttpSessionContext ctx = new HttpSessionContext();
                log.debug((WintellActionContext)ctx, "set encoding to:" + this.encoding);
                for (String s : reqMap.keySet()) {
                    log.debug((WintellActionContext)ctx, "\t" + s + "=" + ((String[])reqMap.get(s))[0]);
                }
            }
        }
        filterChain.doFilter(request, response);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean getOverrideClient() {
        return this.overrideClient;
    }

    public void setOverrideClient(boolean overrideClient) {
        this.overrideClient = overrideClient;
    }

    public String getUrlRegexp() {
        return this.urlRegexp;
    }

    public void setUrlRegexp(String urlRegexp) {
        this.urlRegexp = urlRegexp;
    }

    private boolean pathMatches(ServletRequest request) {
        if (!(request instanceof HttpServletRequest)) {
            return false;
        }
        String path = ((HttpServletRequest)request).getServletPath();
        if (path == null) {
            return false;
        }
        return path.matches(this.urlRegexp);
    }
}

