/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell;

import cz.nextiraone.tmobile.tibco.WintellServiceHandlerRemote;
import cz.nextiraone.tmobile.wintell.WintellActionClass;
import cz.nextiraone.tmobile.wintell.WintellActionLog;
import cz.nextiraone.tmobile.wintell.WintellHandler;
import cz.nextiraone.tmobile.wintell.WintellHandlerException;
import cz.nextiraone.tmobile.wintell.context.WintellActionContext;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Map;
import javax.persistence.EntityManager;

public class IvccWintellHandler
extends WintellHandler {
    protected static DateFormat yyyyMMddHHmmssFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private String url;
    private String attributes;
    WintellActionContext actionContext;
    WintellServiceHandlerRemote wintellServices;
    private String windowName;

    public IvccWintellHandler(WintellServiceHandlerRemote wintellServices, WintellActionContext actionContext) {
        this.wintellServices = wintellServices;
        this.actionContext = actionContext;
    }

    @Override
    public boolean handle(EntityManager em, WintellActionLog al) throws WintellHandlerException {
        WintellActionClass ac = al.getAction().getActionClass();
        if (!ac.getClassType().equals("WEB")) {
            return false;
        }
        Map<String, String> body = this.getBody(al, this.actionContext);
        this.windowName = body.get("WINDOW_NAME");
        if (ac.getSubType().equals("IVCC")) {
            this.url = String.valueOf(this.wintellServices.getConfValue("ivcc.url")) + "?";
            try {
                String iuser = this.getString(body, "USER_NAME");
                String idirectory_number = this.getString(body, "MSISDN");
                Integer iaction_id = this.getInteger(body, "IACTION_ID");
                String imedium_id = this.getString(body, "CASE_MEDIUM_ID");
                String iinteraction_id = this.getString(body, "INTERACTION_ID");
                String computeString = this.wintellServices.vccConvertBoost(iuser, idirectory_number, iaction_id, imedium_id, iinteraction_id, this.actionContext);
                this.url = String.valueOf(this.url) + "action=directPortlet";
                this.url = String.valueOf(this.url) + "&99=d";
                this.url = String.valueOf(this.url) + "&portletId=10";
                this.url = String.valueOf(this.url) + "&p2=" + computeString;
            }
            catch (Exception e) {
                this.url = null;
                throw new WintellHandlerException("IVCC doesn't work corectly.", "IvccWintellHandler", e);
            }
            return true;
        }
        if (ac.getSubType().equals("VCCNG")) {
            this.url = String.valueOf(this.wintellServices.getConfValue("vccNG.url")) + "?";
            try {
                String icaller_id;
                String itarget_id = icaller_id = this.getString(body, "SUID");
                String imodule_id = this.getString(body, "IVCC_MODULE");
                Integer imedium_id = this.getInteger(body, "CASE_MEDIUM_ID");
                String iinteraction_id = this.getString(body, "INTERACTION_ID");
                String iclarify_user = this.getString(body, "USER_NAME");
                String computeString = this.wintellServices.vccngConvertWintell("6", icaller_id, "6", itarget_id, imodule_id, imedium_id, iinteraction_id, iclarify_user, this.actionContext);
                this.url = String.valueOf(this.url) + "dn=" + computeString;
            }
            catch (Exception e) {
                this.url = null;
                throw new WintellHandlerException("IVCC doesn't work corectly.", "IvccWintellHandler", e);
            }
            return true;
        }
        return false;
    }

    private Integer getInteger(Map<String, String> body, String key) throws Exception {
        String val = this.getString(body, key);
        return Integer.parseInt(val);
    }

    private String getString(Map<String, String> body, String key) throws Exception {
        String ret = body.get(key);
        if (ret == null) {
            throw new Exception("the key=" + key + " is not defined");
        }
        return ret;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getAttributes() {
        return this.attributes;
    }

    public void setAttributes(String attributes) {
        this.attributes = attributes;
    }

    public String getWindowName() {
        return this.windowName;
    }
}

