/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell;

import cz.nextiraone.tmobile.wintell.MonitoringLocal;
import cz.nextiraone.tmobile.wintell.RequestLog;
import cz.nextiraone.tmobile.wintell.RequestLogMessage;
import cz.nextiraone.tmobile.wintell.RequestStats;
import cz.nextiraone.tmobile.wintell.WintellStats;
import cz.nextiraone.tmobile.wintell.WintellStatsMessage;
import cz.nextiraone.tmobile.wintell.context.WintellActionContext;
import cz.nextiraone.tmobile.wintell.events.EventFactory;
import cz.nextiraone.tmobile.wintell.events.GeneralEvent;
import cz.nextiraone.tmobile.wintell.logger.WintellLogger;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

@Stateless
@Local(value={MonitoringLocal.class})
public class MonitoringBean
implements MonitoringLocal,
Serializable {
    private static final long serialVersionUID = 6523813744760486148L;
    private static final WintellLogger log = WintellLogger.getLogger(MonitoringBean.class);
    @PersistenceContext(unitName="wintell")
    private EntityManager em;

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void addLog(RequestLogMessage rlm) {
        GeneralEvent e = (GeneralEvent)this.em.find(GeneralEvent.class, (Object)rlm.getRequestId());
        RequestLog rl = rlm.getRequestLog();
        rl.setEvent(e);
        this.em.persist((Object)rl);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void addStats(WintellStatsMessage ws, WintellActionContext ctx) throws Exception {
        GeneralEvent e = null;
        Long requestId = ws.getRequestId();
        String chan = ws.getFlag("CH");
        if (requestId != null) {
            e = (GeneralEvent)this.em.find(GeneralEvent.class, (Object)requestId);
            if (e == null) {
                log.error(ctx, "cannot find event for requestId=" + requestId);
                throw new Exception("cannot find event for requestId=" + requestId);
            }
        } else {
            HashMap<String, String> mo = new HashMap<String, String>();
            mo.put("EV", "GeneralEvent");
            mo.put("TS", "" + new Date().getTime());
            mo.put("CH", chan);
            mo.put("INTERID", ws.getFlag("INTERID"));
            try {
                e = EventFactory.createEvent(mo, (WintellActionContext)ctx);
                this.em.persist((Object)e);
            }
            catch (Exception ex) {
                log.error(ctx, "cannot create requestId for: CH=" + chan, (Throwable)ex);
                throw ex;
            }
        }
        RequestStats rs = new RequestStats();
        rs.setDecisionOverAllTime(ws.getTime(WintellStats.RequestState.ALL));
        rs.setEvalInBlazeTime(ws.getTime(WintellStats.RequestState.EVALUATING_IN_BLAZE));
        rs.setGatheringDataTime(ws.getTime(WintellStats.RequestState.GATHERING_DATA));
        rs.setRequestDeliveryTime(ws.getTime(WintellStats.RequestState.DELIVERY_TIME));
        rs.setNodeId(ws.getNodeId());
        rs.setErrCode(ws.getErrCode());
        rs.setEvent(e);
        this.em.persist((Object)rs);
    }
}

