/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell;

import cz.nextiraone.tmobile.wintell.MonitoringLocal;
import cz.nextiraone.tmobile.wintell.RequestLogMessage;
import cz.nextiraone.tmobile.wintell.WintellStatsMessage;
import cz.nextiraone.tmobile.wintell.context.DefaultWintellActionContext;
import cz.nextiraone.tmobile.wintell.context.WintellActionContext;
import cz.nextiraone.tmobile.wintell.context.WintellSubprojectEnum;
import cz.nextiraone.tmobile.wintell.logger.WintellLogger;
import cz.nextiraone.tmobile.wintell.logger.identifiers.LogIdFactory;
import java.io.Serializable;
import java.util.Date;
import javax.annotation.Resource;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.EJB;
import javax.ejb.MessageDriven;
import javax.ejb.MessageDrivenContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;

@MessageDriven(activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Queue"), @ActivationConfigProperty(propertyName="destination", propertyValue="queue/wintell/WintellMonitorQueue"), @ActivationConfigProperty(propertyName="acknowledgeMode", propertyValue="AUTO_ACKNOWLEDGE"), @ActivationConfigProperty(propertyName="minSession", propertyValue="4")})
public class MonitoringMDB
implements MessageListener {
    private static final WintellLogger log = WintellLogger.getLogger(MonitoringMDB.class);
    private static final WintellActionContext systemActionContext = new DefaultWintellActionContext(WintellSubprojectEnum.NONE, LogIdFactory.createSystemId());
    @EJB
    MonitoringLocal monitoring;
    @Resource
    private MessageDrivenContext context;

    public void onMessage(Message message) {
        if (log.isDebugEnabled()) {
            log.debug(systemActionContext, "consumerMDB");
        }
        long entry = new Date().getTime();
        WintellActionContext ctx = systemActionContext;
        if (message instanceof ObjectMessage) {
            ObjectMessage om = (ObjectMessage)message;
            Serializable o = null;
            try {
                o = om.getObject();
                String corelationId = om.getJMSCorrelationID();
                if (corelationId == null) {
                    log.error(systemActionContext, "corelationId=null");
                    corelationId = "NONE:0";
                }
                WintellSubprojectEnum prj = WintellSubprojectEnum.valueOf((String)corelationId.split(":")[0]);
                ctx = new DefaultWintellActionContext(prj, LogIdFactory.createJmsMessageId((String)(String.valueOf(om.getJMSCorrelationID()) + "/" + om.getJMSMessageID())));
            }
            catch (JMSException e1) {
                log.error(systemActionContext, "Got JMSException while getting object from message.", (Throwable)e1);
                this.context.setRollbackOnly();
                return;
            }
            if (o instanceof RequestLogMessage) {
                RequestLogMessage rl = (RequestLogMessage)o;
                try {
                    this.monitoring.addLog(rl);
                    log.info(ctx, "LogRequestMessage:" + rl.getRequestLogId() + ": done (deltaDelivery=" + (new Date().getTime() - om.getJMSTimestamp()) + "ms, process=" + (new Date().getTime() - entry) + "ms)");
                    return;
                }
                catch (Exception e) {
                    log.info(ctx, "catch exeption:" + e.getClass().getSimpleName());
                }
            } else if (o instanceof WintellStatsMessage) {
                WintellStatsMessage ws = (WintellStatsMessage)o;
                try {
                    this.monitoring.addStats(ws, ctx);
                    log.info(ctx, "WintellStatsMessage: done (deltaDelivery=" + (new Date().getTime() - om.getJMSTimestamp()) + "ms, process=" + (new Date().getTime() - entry) + "ms)");
                    return;
                }
                catch (Exception e) {
                    log.info(ctx, "catch exeption:" + e.getClass().getSimpleName(), (Throwable)e);
                }
            } else {
                log.warn(ctx, " unsupported object type of the message: " + o.getClass().getName());
            }
        }
        this.context.setRollbackOnly();
    }
}

