/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell;

import cz.nextiraone.tmobile.wintell.IMoreInfo;
import cz.nextiraone.tmobile.wintell.IWintellTabs;
import cz.nextiraone.tmobile.wintell.MoreInfoGroup;
import cz.nextiraone.tmobile.wintell.MoreInfoItem;
import cz.nextiraone.tmobile.wintell.MoreInfoItemValue;
import cz.nextiraone.tmobile.wintell.RegistryContractType;
import cz.nextiraone.tmobile.wintell.RegistryTariffCode;
import cz.nextiraone.tmobile.wintell.WintellOffer;
import cz.nextiraone.tmobile.wintell.WintellOfferActivity;
import cz.nextiraone.tmobile.wintell.context.WintellActionContext;
import cz.nextiraone.tmobile.wintell.logger.WintellLogger;
import cz.nextiraone.tmobile.wintell.utils.HttpSessionContext;
import cz.tmobile.ei.wintell.datatypes.BillingArrangement;
import cz.tmobile.ei.wintell.datatypes.Customer;
import cz.tmobile.ei.wintell.datatypes.MoreInfoResp;
import cz.tmobile.ei.wintell.datatypes.Service;
import cz.tmobile.ei.wintell.datatypes.Subscriber;
import cz.tmobile.ei.wintell.datatypes.WintellResponse;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ejb.Stateless;
import javax.faces.context.FacesContext;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.XMLGregorianCalendar;
import org.jboss.ejb3.annotation.Clustered;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.web.RequestParameter;

@Stateless(name="moreInfo")
@Clustered
@Name(value="moreInfo")
public class MoreInfo
implements IMoreInfo,
Serializable {
    private static final long serialVersionUID = -3959968513072927471L;
    private static DateFormat ddMMyyyyFormat = new SimpleDateFormat("dd.MM.yyyy");
    private static DateFormat monthFormat = new SimpleDateFormat("MMMM yyyy", new Locale("cs", "CZ"));
    private static Pattern m123 = Pattern.compile("(.*)\\$m$");
    private static int SERVICE_LOYALITY = 772;
    private WintellLogger log = WintellLogger.getLogger(MoreInfo.class);
    @RequestParameter(value="activityId")
    String activityId;
    @RequestParameter(value="offerId")
    String offerId;
    @RequestParameter(value="moreInfoId")
    String moreInfoId;
    @In(scope=ScopeType.SESSION, value="wintellTabs", required=false)
    private IWintellTabs wTabs;
    @In(create=true)
    @Out(scope=ScopeType.SESSION)
    private HttpSessionContext httpSessionContext = new HttpSessionContext();
    @PersistenceContext(unitName="wintell")
    private EntityManager em;
    private WintellOfferActivity offerActivity = null;

    @Override
    public WintellOffer getOffer() {
        Integer aId = Integer.valueOf(this.offerId);
        this.log.info((WintellActionContext)this.httpSessionContext, "offerId: " + Integer.toString(aId));
        WintellOffer a = (WintellOffer)this.em.find(WintellOffer.class, (Object)aId);
        return a;
    }

    @Override
    public WintellOfferActivity getOfferActivity() {
        if (this.activityId == null) {
            this.log.info((WintellActionContext)this.httpSessionContext, "activityId is not set");
            return null;
        }
        Long aId = Long.valueOf(this.activityId);
        WintellOfferActivity a = (WintellOfferActivity)this.em.find(WintellOfferActivity.class, (Object)aId);
        if (a == null) {
            this.log.info((WintellActionContext)this.httpSessionContext, "Not found activity for: " + aId);
        }
        return a;
    }

    @Override
    public MoreInfoGroup getmoreInfoGroup() {
        Integer aId = Integer.valueOf(this.moreInfoId);
        this.log.info((WintellActionContext)this.httpSessionContext, "moreInfoId: " + Integer.toString(aId));
        MoreInfoGroup a = (MoreInfoGroup)this.em.find(MoreInfoGroup.class, (Object)aId);
        return a;
    }

    public String array2str(String[] a) {
        String ret = "";
        String[] stringArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (ret.length() > 0) {
                ret = String.valueOf(ret) + ",";
            }
            ret = String.valueOf(ret) + s;
            ++n2;
        }
        return "[" + ret + "]";
    }

    public String getValueByPath(String[] path, Integer pos, Object o) throws Throwable {
        if (path.length == pos) {
            if (o instanceof XMLGregorianCalendar) {
                XMLGregorianCalendar xGc = (XMLGregorianCalendar)o;
                return ddMMyyyyFormat.format(xGc.toGregorianCalendar().getTime());
            }
            if (o instanceof JAXBElement) {
                JAXBElement xV = (JAXBElement)o;
                if (xV.isNil()) {
                    return null;
                }
                return this.getValueByPath(path, pos, xV.getValue());
            }
            if (o instanceof Double || o instanceof Float) {
                return String.format("%.2f", o);
            }
            return o.toString();
        }
        String mName = path[pos];
        if (mName.length() == 0) {
            this.log.error((WintellActionContext)this.httpSessionContext, "bad name for more info on pos=" + pos + "in path=" + this.array2str(path));
            throw new Throwable("NOT IMPLEMENTED");
        }
        Matcher ma123 = m123.matcher(mName);
        if (ma123.matches()) {
            this.log.info((WintellActionContext)this.httpSessionContext, "getL3MA on " + o.getClass().getName() + ", " + mName + ") for more info:" + this.array2str(path));
            Integer[] a = new Integer[]{1, 2, 3};
            String ret = "";
            Double sum = 0.0;
            Double n = 0.0;
            Integer[] integerArray = a;
            int n2 = a.length;
            int n3 = 0;
            while (n3 < n2) {
                block18: {
                    Integer i = integerArray[n3];
                    if (ret.length() > 0) {
                        ret = String.valueOf(ret) + ";";
                    }
                    String[] nPath = new String[]{String.valueOf(ma123.group(1)) + i};
                    String rx = this.getValueByPath(nPath, 0, o);
                    ret = String.valueOf(ret) + rx;
                    Double r = null;
                    try {
                        r = Double.parseDouble(rx);
                    }
                    catch (Exception ex) {
                        this.log.error((WintellActionContext)this.httpSessionContext, "not parseble number: [" + i + "]=" + rx + ", method: " + o.getClass().getSimpleName() + "." + mName + "() for more info:" + this.array2str(path) + ", ERR:" + ex.getMessage());
                        break block18;
                    }
                    if (r != null) {
                        sum = sum + r;
                        n = n + 1.0;
                    }
                }
                ++n3;
            }
            if (n > 0.0) {
                Double avg = sum / n;
                return String.valueOf(String.format("%.2f", avg)) + ";" + ret;
            }
            this.log.error((WintellActionContext)this.httpSessionContext, "cannot count avg for: " + ret + ", method: " + o.getClass().getSimpleName() + "." + mName + "() for more info:" + this.array2str(path));
            return "?UNKNOWN?;" + ret;
        }
        Class[] argTypes = new Class[]{};
        Object[] theData = new Object[]{};
        mName = "get" + mName.substring(0, 1).toUpperCase() + mName.substring(1);
        Method get = null;
        try {
            get = o.getClass().getMethod(mName, argTypes);
        }
        catch (NoSuchMethodException ex) {
            this.log.error((WintellActionContext)this.httpSessionContext, "cannot find method: " + o.getClass().getSimpleName() + "." + mName + "() for more info:" + this.array2str(path) + " ERR: " + ex.getMessage());
            throw new Throwable("NOT IMPLEMENTED");
        }
        this.log.info((WintellActionContext)this.httpSessionContext, "get method: " + o.getClass().getSimpleName() + "." + mName + "() for more info:" + this.array2str(path));
        Object io = null;
        try {
            io = get.invoke(o, theData);
        }
        catch (Exception ex) {
            this.log.error((WintellActionContext)this.httpSessionContext, "cannot invoke " + o.getClass().getSimpleName() + "." + mName + "() for more info:" + this.array2str(path) + " ERR: " + ex.getMessage());
            throw new Throwable("NOT IMPLEMENTED");
        }
        if (io == null) {
            return null;
        }
        return this.getValueByPath(path, pos + 1, io);
    }

    public String getValueByPath(String pathString, Object o) throws Throwable {
        String[] path = pathString.split("\\.");
        return this.getValueByPath(path, 0, o);
    }

    public String getValueFromMI(String name, MoreInfoResp r, Customer cc) {
        if (name.equals("bonusProgramme")) {
            try {
                boolean isRegistered = false;
                for (Service s : ((Subscriber)((BillingArrangement)cc.getBillingArrangementList().get(0)).getSubscriberList().get(0)).getServiceList()) {
                    if (s.getId() == null || s.getId().intValue() != SERVICE_LOYALITY) continue;
                    isRegistered = true;
                    break;
                }
                if (!isRegistered) {
                    for (Service s : cc.getServiceList()) {
                        if (s.getId() == null || s.getId().intValue() != SERVICE_LOYALITY) continue;
                        isRegistered = true;
                        break;
                    }
                }
                return isRegistered ? "ANO" : "NE";
            }
            catch (Exception e) {
                return "?UNDEFINED?";
            }
        }
        if (name.equals("lenOfCallToTMCZ")) {
            String[] c = null;
            String[] j = null;
            try {
                c = this.getValueByPath("subscriber.callStats.tmczCallQtyM$m", r).split(";");
                j = this.getValueByPath("subscriber.callStats.tmczCallCntM$m", r).split(";");
            }
            catch (Throwable e1) {
                c = "null;null;null".split(";");
                j = "null;null;null".split(";");
            }
            String ret = "";
            Integer i = 0;
            while (i <= 3) {
                if (ret.length() > 0) {
                    ret = String.valueOf(ret) + ";";
                }
                try {
                    ret = String.valueOf(ret) + String.format("%.2f", new Double(Double.parseDouble(c[i]) / Double.parseDouble(j[i])));
                }
                catch (Exception e) {
                    ret = String.valueOf(ret) + "ERROR (" + name + "):" + e.getMessage();
                }
                i = i + 1;
            }
            return ret;
        }
        if (name.equals("tarif")) {
            if (r.getSubscriber().getTarifId() != null) {
                RegistryTariffCode tc = (RegistryTariffCode)this.em.find(RegistryTariffCode.class, (Object)r.getSubscriber().getTarifId().intValue());
                if (tc == null) {
                    this.log.error((WintellActionContext)this.httpSessionContext, "cannot find tarif in MoreInfo, id=" + r.getSubscriber().getTarifId() + "in REGISTRY_TARIFF_CODE");
                    return "?UNKNOWN tarifId=" + r.getSubscriber().getTarifId();
                }
                return tc.getTarCzDes();
            }
            this.log.error((WintellActionContext)this.httpSessionContext, "subscriber.tarifId=null in MoreInfo, id=" + r.getSubscriber().getTarifId());
            return "subscriber.tarifId=null";
        }
        if (name.equals("Contract")) {
            if (r.getSubscriber().getContractType() != null) {
                RegistryContractType ct = (RegistryContractType)this.em.find(RegistryContractType.class, (Object)r.getSubscriber().getContractType().intValue());
                if (ct == null) {
                    this.log.error((WintellActionContext)this.httpSessionContext, "cannot find contract in MoreInfo, id=" + r.getSubscriber().getTarifId() + "in REGISTRY_CONTRACT_TYPE");
                    return "?UNKNOWN contractType=" + r.getSubscriber().getContractType();
                }
                return ct.getDescription();
            }
            this.log.error((WintellActionContext)this.httpSessionContext, "subscriber.contractType=null in MoreInfo, id=" + r.getSubscriber().getTarifId());
            return "subscriber.contractType=null";
        }
        if (name.equals("custSpend")) {
            try {
                if (r.getBillingArrangement().getInvoiceInfo().getInvoicedAmountM3().isNil()) {
                    return "??NULL??";
                }
            }
            catch (Exception e) {
                return "PREPAID";
            }
            return String.format("%.2f", new Double((Double)r.getBillingArrangement().getInvoiceInfo().getInvoicedAmountM3().getValue()) / 3.0);
        }
        Pattern misCons = Pattern.compile("(Customer)\\.(.*)$");
        Matcher mamisCons = misCons.matcher(name);
        if (mamisCons.matches()) {
            String attr = mamisCons.group(1);
            String restName = mamisCons.group(2);
            Object o = null;
            if ("Customer".equals(attr)) {
                o = ((BillingArrangement)cc.getBillingArrangementList().get(0)).getSubscriberList().get(0);
            }
            try {
                String ret = this.getValueByPath(restName, o);
                this.log.info((WintellActionContext)this.httpSessionContext, "CC: " + name + " => " + ret);
                return ret;
            }
            catch (Throwable throwable) {
                return "NOT IMPLEMENTED:" + name;
            }
        }
        try {
            String ret = this.getValueByPath(name, r);
            this.log.info((WintellActionContext)this.httpSessionContext, "MI: " + name + " => " + ret);
            return ret;
        }
        catch (Throwable throwable) {
            return "NOT IMPLEMENTED:" + name;
        }
    }

    public String getValueFromDB(MoreInfoItemValue miV, Integer m, WintellOfferActivity oa) {
        MoreInfoItem miI = miV.getMoreInfoItem();
        if (miI.getMItype().endsWith("3MA")) {
            Integer n = -m.intValue();
            String[] ret = miV.getValue().split(";");
            if (n >= 0 && n < ret.length) {
                return ret[n];
            }
            this.log.error((WintellActionContext)this.httpSessionContext, "error while getting miValue " + miI.getName() + "[" + n + "] from '" + miV.getValue() + "'" + ", offeractivityId=" + oa.getOfferActivityId());
            return "?ERROR?";
        }
        return miV.getValue();
    }

    public void findOfferActivity() {
        this.offerActivity = this.getOfferActivity();
    }

    @Override
    public List<MoreInfoItem> getMoreInfoItems() {
        this.findOfferActivity();
        return this.offerActivity.getOffer().getMoreInfoGroup().getMoreInfoItems();
    }

    @Override
    public String getMonth(Integer m) {
        GregorianCalendar cal = new GregorianCalendar();
        this.findOfferActivity();
        cal.setTime(this.offerActivity.getDateTime());
        ((Calendar)cal).add(2, m);
        return monthFormat.format(cal.getTime());
    }

    @Override
    public String getValue(String name, Integer m) {
        Customer cc;
        MoreInfoResp r;
        MoreInfoItemValue miV;
        MoreInfoItem moreInfoItem;
        block7: {
            this.findOfferActivity();
            moreInfoItem = this.getMoreInfoItem(name);
            if (moreInfoItem == null) {
                this.log.error((WintellActionContext)this.httpSessionContext, "cannot get moreInfoItem, while getting miValue " + name + "[" + m + "]" + ", offeractivityId=" + this.offerActivity.getOfferActivityId());
                return "?ERROR?";
            }
            miV = (MoreInfoItemValue)this.em.find(MoreInfoItemValue.class, (Object)new MoreInfoItemValue.Id(Integer.valueOf(moreInfoItem.getMoreInfoItemId()), Long.valueOf(this.offerActivity.getOfferActivityId())));
            if (miV != null) {
                return this.getValueFromDB(miV, m, this.offerActivity);
            }
            r = null;
            WintellResponse wr = null;
            cc = null;
            String tabId = this.offerActivity.getObjectType() + ":" + this.offerActivity.getObjectId();
            try {
                r = this.wTabs.getMiResp(tabId);
                wr = this.wTabs.getRvaResponse(tabId);
                if (wr != null) {
                    cc = wr.getResponseData();
                }
                if (r != null && cc != null) break block7;
                this.log.error((WintellActionContext)this.httpSessionContext, "error while getting miValue " + name + "[" + m + "]" + ", offeractivityId=" + this.offerActivity.getOfferActivityId());
                return "null";
            }
            catch (Exception e) {
                this.log.error((WintellActionContext)this.httpSessionContext, "Exception evaluating: miValue " + name + "[" + m + "]" + " offeractivityId=" + this.offerActivity.getOfferActivityId(), (Throwable)e);
                return "null";
            }
        }
        String ret = this.getValueFromMI(name, r, cc);
        if (ret != null) {
            miV = new MoreInfoItemValue(ret, moreInfoItem, this.offerActivity);
            this.em.persist((Object)miV);
            return this.getValueFromDB(miV, m, this.offerActivity);
        }
        this.log.info((WintellActionContext)this.httpSessionContext, "miValue " + name + "[" + m + "]" + ":= null, offeractivityId=" + this.offerActivity.getOfferActivityId());
        return "null";
    }

    public MoreInfoItem getMoreInfoItem(String name) {
        Query q = this.em.createNamedQuery("moreInfoItemByName");
        q.setParameter(1, (Object)name);
        MoreInfoItem result = (MoreInfoItem)q.getSingleResult();
        return result;
    }

    @Override
    public String checkSession() {
        this.log.info((WintellActionContext)this.httpSessionContext, "checkSession called");
        if (!this.wTabs.isLogged()) {
            this.log.error((WintellActionContext)this.httpSessionContext, "!wTabs.isLogged()");
            return "session-expired";
        }
        if (this.wTabs.isHideMoreInfo(null)) {
            return "denied";
        }
        this.log.info((WintellActionContext)this.httpSessionContext, "checkSession OK");
        return "";
    }

    @Override
    public String getObjectTitle() {
        try {
            return this.wTabs.getActiveTab().getTabTitle();
        }
        catch (Exception e) {
            this.log.error((WintellActionContext)this.httpSessionContext, "in getObjectTitle()", (Throwable)e);
            return "";
        }
    }

    @Override
    public String getTabId() {
        try {
            return this.wTabs.getActiveTabId();
        }
        catch (Exception e) {
            this.log.error((WintellActionContext)this.httpSessionContext, "in getObjectTitle()", (Throwable)e);
            return "";
        }
    }

    @AroundInvoke
    public Object aroundInvoke(InvocationContext ctx) throws Exception {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null) {
            HttpServletRequest req = (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
            this.activityId = req.getParameter("activityId");
            this.offerId = req.getParameter("offerId");
            this.moreInfoId = req.getParameter("moreInfoId");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((WintellActionContext)this.httpSessionContext, "aroundInvoke:" + ctx.getMethod() + ", this=" + this);
        }
        try {
            if (facesContext != null) {
                if (this.wTabs != null) {
                    try {
                        this.wTabs.isLogged();
                    }
                    catch (Exception e1) {
                        this.log.error((WintellActionContext)this.httpSessionContext, "reset wintellTabs=null, because [" + e1.getClass().getName() + "]: " + e1.getMessage(), (Throwable)e1);
                        this.wTabs = null;
                    }
                }
                if (this.wTabs == null) {
                    this.wTabs = (IWintellTabs)Component.getInstance((String)"wintellTabs", (ScopeType)ScopeType.SESSION, (boolean)true);
                }
            }
            return ctx.proceed();
        }
        catch (Exception e2) {
            this.log.error((WintellActionContext)this.httpSessionContext, "uncatched exeption[class=" + e2.getClass().getSimpleName() + "]:" + e2.getMessage(), (Throwable)e2);
            throw e2;
        }
    }
}

