/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell;

import cz.nextiraone.tmobile.wintell.IOffersChecker;
import cz.nextiraone.tmobile.wintell.WintellOfferActivity;
import cz.nextiraone.tmobile.wintell.context.WintellActionContext;
import cz.nextiraone.tmobile.wintell.exceptions.WintellAppException;
import cz.nextiraone.tmobile.wintell.logger.WintellLogger;
import java.io.Serializable;
import java.util.List;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

@Stateless
@Local(value={IOffersChecker.class})
public class OffersChecker
implements Serializable,
IOffersChecker {
    private static final long serialVersionUID = -5330956533307030957L;
    private static final WintellLogger log = WintellLogger.getLogger(OffersChecker.class);
    @PersistenceContext(unitName="wintell")
    private EntityManager em;

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public WintellOfferActivity check(int offerId, int objectType, String objectId, WintellActionContext requestContext) throws WintellAppException {
        Query q = this.em.createNamedQuery("offerActivityByOfferForPressed");
        q.setParameter("offerId", (Object)offerId);
        q.setParameter("objectId", (Object)objectId);
        q.setParameter("objectType", (Object)objectType);
        q.setMaxResults(1);
        WintellOfferActivity oldOffer = null;
        try {
            List l = q.getResultList();
            if (!l.isEmpty()) {
                log.debug(requestContext, "oldOfferActivity for the same offerId=" + offerId + " and object id=" + objectId + " type=" + objectType);
                oldOffer = (WintellOfferActivity)l.get(0);
            } else {
                log.debug(requestContext, "oldOfferActivity for the same offerId=" + offerId + " and object id=" + objectId + " type=" + objectType + " not found");
            }
        }
        catch (Exception er) {
            throw new WintellAppException(er);
        }
        return oldOffer;
    }
}

