/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell;

import com.steadystate.css.parser.CSSOMParser;
import cz.nextiraone.tmobile.tibco.WintellServiceHandlerRemote;
import cz.nextiraone.tmobile.wintell.AGSBlaze;
import cz.nextiraone.tmobile.wintell.BlazeStatsMessage;
import cz.nextiraone.tmobile.wintell.IAGSBlaze;
import cz.nextiraone.tmobile.wintell.IRequestBean;
import cz.nextiraone.tmobile.wintell.IWintellJmsSender;
import cz.nextiraone.tmobile.wintell.IWintellObjectManager;
import cz.nextiraone.tmobile.wintell.IWintellTabs;
import cz.nextiraone.tmobile.wintell.IvccWintellHandler;
import cz.nextiraone.tmobile.wintell.RequestClass;
import cz.nextiraone.tmobile.wintell.RequestLog;
import cz.nextiraone.tmobile.wintell.WintellActionHandle;
import cz.nextiraone.tmobile.wintell.WintellActionHandleAgs;
import cz.nextiraone.tmobile.wintell.WintellActionOutput;
import cz.nextiraone.tmobile.wintell.WintellCssClass;
import cz.nextiraone.tmobile.wintell.WintellOffer;
import cz.nextiraone.tmobile.wintell.WintellOfferActivity;
import cz.nextiraone.tmobile.wintell.WintellOfferCategory;
import cz.nextiraone.tmobile.wintell.WintellSession;
import cz.nextiraone.tmobile.wintell.WintellStats;
import cz.nextiraone.tmobile.wintell.WintellTabData;
import cz.nextiraone.tmobile.wintell.WintellTabRequestCache;
import cz.nextiraone.tmobile.wintell.ags.model.DecisionOutput;
import cz.nextiraone.tmobile.wintell.ags.model.OfferAction;
import cz.nextiraone.tmobile.wintell.ags.model.OfferButtonEnumeration;
import cz.nextiraone.tmobile.wintell.ags.model.Request;
import cz.nextiraone.tmobile.wintell.ags.model.Response;
import cz.nextiraone.tmobile.wintell.context.DefaultWintellActionContext;
import cz.nextiraone.tmobile.wintell.context.WintellActionContext;
import cz.nextiraone.tmobile.wintell.context.WintellSubprojectEnum;
import cz.nextiraone.tmobile.wintell.events.AgsEvent;
import cz.nextiraone.tmobile.wintell.events.EventFactory;
import cz.nextiraone.tmobile.wintell.events.GeneralEvent;
import cz.nextiraone.tmobile.wintell.events.NotifyAcceptCaseEvent;
import cz.nextiraone.tmobile.wintell.events.NotifySaveCaseEvent;
import cz.nextiraone.tmobile.wintell.exceptions.WintellAppException;
import cz.nextiraone.tmobile.wintell.exceptions.WintellDGException;
import cz.nextiraone.tmobile.wintell.exceptions.WintellException;
import cz.nextiraone.tmobile.wintell.logger.WintellLogger;
import cz.nextiraone.tmobile.wintell.logger.identifiers.LogIdFactory;
import cz.nextiraone.tmobile.wintell.request.WintellRequestStep;
import cz.nextiraone.tmobile.wintell.rva.TibRvaError;
import cz.nextiraone.tmobile.wintell.rva.TibRvaTimeout;
import cz.nextiraone.tmobile.wintell.utils.HttpSessionContext;
import cz.tmobile.ei.wintell.datatypes.BillingArrangement;
import cz.tmobile.ei.wintell.datatypes.MoreInfoReq;
import cz.tmobile.ei.wintell.datatypes.MoreInfoResp;
import cz.tmobile.ei.wintell.datatypes.Subscriber;
import cz.tmobile.ei.wintell.datatypes.WintellRequest;
import cz.tmobile.ei.wintell.datatypes.WintellResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Remove;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.faces.context.FacesContext;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.servlet.http.HttpServletRequest;
import org.jboss.ejb3.annotation.TransactionTimeout;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.web.RequestParameter;
import org.richfaces.event.TreeToggleEvent;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleSheet;

@Stateless(name="requestBean")
@Name(value="requestBean")
public class RequestBean
implements IRequestBean,
Serializable {
    private static final long serialVersionUID = 6370476630882428191L;
    private static final WintellLogger log = WintellLogger.getLogger(RequestBean.class);
    private HttpSessionContext httpSessionContext = null;
    private static DateFormat yyyyMMddHHmmssFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    private static DateFormat yyMMddFormat = new SimpleDateFormat("yyMMdd");
    private static Pattern msisdnRegex = Pattern.compile("(\\d+)");
    private boolean newRequest = false;
    @PersistenceContext(unitName="wintell")
    private EntityManager em;
    @Resource(mappedName="java:global/wintell-tibco/wintell-tibco/wintell/WintellServiceHandler")
    private WintellServiceHandlerRemote handler;
    @EJB(name="AGSBlaze")
    private IAGSBlaze blaze;
    @In(scope=ScopeType.EVENT, value="wintellObjectManager", required=false)
    @Out(scope=ScopeType.EVENT, value="wintellObjectManager")
    IWintellObjectManager om;
    @In(scope=ScopeType.SESSION, value="wintellTabs", required=false)
    @Out(scope=ScopeType.SESSION, value="wintellTabs")
    private IWintellTabs wTabs;
    @In(required=false, scope=ScopeType.EVENT)
    @Out(required=false, scope=ScopeType.EVENT)
    private Boolean shallOpenWeb;
    @Out(required=false, scope=ScopeType.EVENT)
    private String webUrl;
    @Out(required=false, scope=ScopeType.EVENT)
    private String webAttributes;
    @Out(required=false, scope=ScopeType.EVENT)
    private String webWindowName;
    @RequestParameter(value="tabsForm:objectIdtoClose")
    private String tabIdtoClose;

    private void dumpBadRequest(String err, Map<String, String> mo) {
        log.error((WintellActionContext)this.httpSessionContext, err);
        for (Map.Entry<String, String> s : mo.entrySet()) {
            log.error((WintellActionContext)this.httpSessionContext, "\tparam:" + s.getKey() + "=" + s.getValue());
        }
    }

    private String failRequest(int errorCode, String string, Map<String, String> m) {
        this.dumpBadRequest(string, m);
        return this.failRequest(errorCode, string);
    }

    public String getWintellEventTest(Map<String, String> m, TreeMap<String, String> mo) throws Exception {
        boolean useDebugInfo;
        if (this.handler.isConfValueTrue("ags.skippALL")) {
            this.wTabs.logIn("NO-USER");
            return this.failRequest(-9, "Vynech\u00e1v\u00e1m - ags.skippALL=true");
        }
        boolean bl = useDebugInfo = "1".equals(m.get("DEBUG_INFO")) || this.handler.isConfValueTrue("ags.addDebugInfo");
        if (useDebugInfo) {
            this.om.addDebugInfo("HTTP_SESSION: " + this.httpSessionContext.getLogIdChain().getTopId().getIdentity());
        }
        if (this.handler.isConfValueTrue("ags.skippALL1")) {
            this.wTabs.logIn("NO-USER");
            return this.failRequest(-9, "Vynech\u00e1v\u00e1m - ags.skippALL1=true");
        }
        String h = m.get("H");
        String user = m.get("USR");
        if (h == null) {
            if (this.wTabs.isLogged()) {
                if (log.isDebugEnabled()) {
                    log.debug((WintellActionContext)this.httpSessionContext, "h==null, but session");
                }
                return "success";
            }
            return this.failRequest(-4, "noauth-nohash, add H=... into url", m);
        }
        if (this.handler.isConfValueTrue("ags.skippALL2")) {
            this.wTabs.logIn("NO-USER");
            return this.failRequest(-9, "Vynech\u00e1v\u00e1m - ags.skippALL2=true");
        }
        String ts = m.get("TS");
        if (ts == null) {
            if (this.wTabs.isLogged()) {
                if (log.isDebugEnabled()) {
                    log.debug((WintellActionContext)this.httpSessionContext, "ts==null, but session");
                }
                return "success";
            }
            return this.failRequest(-4, "noauth-noTs, add TS=... into url", m);
        }
        if (user == null) {
            if (this.wTabs.isLogged()) {
                if (log.isDebugEnabled()) {
                    log.debug((WintellActionContext)this.httpSessionContext, "user==null, but session");
                }
                return "success";
            }
            return this.failRequest(-4, "noauth-nouser, add USR=... into url", m);
        }
        this.om.setEventRequest(this.wTabs.isDebugEvent() || "1".equals(m.get("DEBUG")));
        this.newRequest = true;
        if (this.handler.isConfValueTrue("ags.skippALL3")) {
            this.wTabs.logIn("NO-USER");
            return this.failRequest(-9, "Vynech\u00e1v\u00e1m - ags.skippALL3=true");
        }
        String alg = "SHA-1";
        String enc = "utf8";
        if (h.length() > 0 && h.substring(0, 1).equals("_")) {
            alg = "MD5";
            enc = "cp1250";
            h = h.substring(1);
        }
        String logMessage = "H=" + m.get("H");
        String data = "";
        mo.remove("H");
        mo.remove("DEBUG_INFO");
        for (Map.Entry<String, String> s : mo.entrySet()) {
            if (data != "") {
                data = String.valueOf(data) + "&";
            }
            String value = s.getValue();
            data = String.valueOf(data) + s.getKey() + "=" + value;
            if (log.isDebugEnabled()) {
                log.debug((WintellActionContext)this.httpSessionContext, "param:" + s.getKey() + "=" + value);
            }
            logMessage = String.valueOf(logMessage) + "\n" + s.getKey() + "=" + value;
        }
        if (this.handler.isConfValueTrue("ags.skippALL4")) {
            this.wTabs.logIn("NO-USER");
            return this.failRequest(-9, "Vynech\u00e1v\u00e1m - ags.skippALL4=true");
        }
        String passwd = this.handler.getConfValue("ags.passwd");
        if (passwd != null && h.equals(passwd)) {
            this.updateTS(ts, mo);
        }
        if (!this.handler.isConfValueTrue("ags.skippAUTH")) {
            try {
                String my_h = this.hash4params(data, alg, enc);
                log.info((WintellActionContext)this.httpSessionContext, "user:" + user);
                log.info((WintellActionContext)this.httpSessionContext, "hash_input:" + data);
                log.info((WintellActionContext)this.httpSessionContext, "alg=" + alg + ", H=" + h + ", MY_H=" + my_h);
                if (!(passwd != null && h.equals(passwd) || h.equals(my_h))) {
                    return this.failRequest(-4, "Chyba autentizace - \u0161patn\u011b spo\u010d\u00edtan\u00fd podpis po\u017eadavku ze zdrojov\u00e9ho syst\u00e9mu: " + m.get("CH"));
                }
                my_h = null;
            }
            catch (NoSuchAlgorithmException e) {
                return this.failRequest(-4, "Chyba autentizace - nepodporovan\u00fd typ podpisu po\u017eadavku");
            }
            catch (UnsupportedEncodingException e) {
                return this.failRequest(-4, "Chyba autentizace - nepodporovan\u00fd typ k\u00f3dov\u00e9 sady v po\u017eadavku");
            }
            catch (Exception er) {
                String error = "Chyba autentizace - " + er.getMessage();
                log.error((WintellActionContext)this.httpSessionContext, error, (Throwable)er);
                return this.failRequest(-4, error);
            }
        }
        if (!this.wTabs.isLogged()) {
            log.info((WintellActionContext)this.httpSessionContext, "open wintell(init web session) for user: " + user);
            this.wTabs.logIn(user);
        }
        boolean reportDGerrors2user = this.handler.isConfValueTrue("ags.reportDGerrors2user");
        if (m.containsKey("REPORT_ERRORS")) {
            reportDGerrors2user = true;
        }
        if (reportDGerrors2user) {
            mo.put("__REPORT_DG2USERS", "true");
        }
        if (this.handler.isConfValueTrue("ags.skippALL5")) {
            return this.failRequest(-9, "Vynech\u00e1v\u00e1m - ags.skippALL5=true");
        }
        AgsEvent oldEvent = null;
        AgsEvent e = null;
        try {
            if (mo.containsKey("BLAZE_REUSE_REQ")) {
                oldEvent = this.findOldEvent(mo);
                mo.put("TS", ts);
                this.updateTS(ts, mo);
            }
            e = this.createEvent(mo, logMessage, (WintellActionContext)this.httpSessionContext);
            if (oldEvent == null && !this.checkTimeout(e)) {
                return this.failRequest(-3, "\u010casov\u00e1 zn\u00e1mka po\u017eadavku je neplatn\u00e1. Zkontrolujte pros\u00edm \u010das na Va\u0161\u00ed pracovn\u00ed stanici.");
            }
            String objectId = e.getObjectId();
            int objectType = e.getObjectType();
            if (objectId == null) {
                return this.failRequest(-5, "V syst\u00e9mu nebyla nalezena \u017e\u00e1dn\u00e1 vhodn\u00e1 nab\u00eddka.");
            }
        }
        catch (Exception er) {
            log.fatal((WintellActionContext)this.httpSessionContext, "cannot create event: " + er.getMessage());
            throw er;
        }
        this.om.setRequestSendTime(e.getTs());
        this.om.addFlag("CH", e.getCh());
        DefaultWintellActionContext requestContext = this.httpSessionContext.getMoreSpecificContext(LogIdFactory.createRequestId((long)e.getRequestId()));
        if (useDebugInfo) {
            mo.put("__USE_DEBUG_INFO", "true");
            this.om.addDebugInfo("REQUEST_ID: " + requestContext.getLogIdChain().getTopId().getIdentity());
        }
        mo.put("__REQUEST_ID", "" + e.getRequestId());
        this.om.setRequestParams(mo);
        log.info((WintellActionContext)requestContext, "request stored");
        return "success";
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=30L)
    public String handleRequest() throws WintellAppException {
        String err;
        Request baRequest;
        String platformDescr;
        String platform;
        String tabObjectId;
        int objectType;
        String objectId;
        DefaultWintellActionContext requestContext;
        AgsEvent e;
        AgsEvent oldEvent;
        TreeMap<String, String> mo;
        block86: {
            WintellRequestStep st;
            boolean useMSISDN;
            boolean reportDGerrors2user;
            boolean useDgCache;
            block84: {
                String tabTitle;
                mo = this.om.getRequestParams();
                if (mo == null) {
                    return "success";
                }
                if (log.isDebugEnabled()) {
                    log.debug((WintellActionContext)this.httpSessionContext, "om.getRequestParams():");
                    for (Map.Entry<String, String> s : mo.entrySet()) {
                        log.debug((WintellActionContext)this.httpSessionContext, "\tparam:" + s.getKey() + "=" + s.getValue());
                    }
                }
                useDgCache = this.handler.isConfValueTrue("ags.useDgCache");
                reportDGerrors2user = mo.containsKey("__REPORT_DG2USERS");
                boolean useDebugInfo = mo.containsKey("__USE_DEBUG_INFO");
                oldEvent = null;
                if (mo.containsKey("__REUSED")) {
                    oldEvent = (AgsEvent)this.em.find(AgsEvent.class, (Object)Long.parseLong(mo.get("__REUSED")));
                }
                e = (AgsEvent)this.em.find(AgsEvent.class, (Object)Long.parseLong(mo.get("__REQUEST_ID")));
                requestContext = this.httpSessionContext.getMoreSpecificContext(LogIdFactory.createRequestId((long)e.getRequestId()));
                objectId = e.getObjectId();
                objectType = e.getObjectType();
                tabObjectId = String.valueOf(Integer.toString(objectType)) + ":" + objectId;
                platform = null;
                platformDescr = "";
                platform = null;
                if (platform == null && mo.containsKey("BLAZE_PLATFORM")) {
                    platform = mo.get("BLAZE_PLATFORM");
                    log.info((WintellActionContext)this.httpSessionContext, "platform: " + platform + ", was used based on EVENT params");
                }
                if (platform == null) {
                    platform = AGSBlaze.testSwitchPlatform(this.em, e, (WintellActionContext)requestContext);
                }
                useMSISDN = false;
                Matcher ma = null;
                if (e.getMsisdn() != null) {
                    ma = msisdnRegex.matcher(e.getMsisdn());
                }
                if (ma != null && ma.matches()) {
                    useMSISDN = true;
                }
                if (this.handler.isConfValueTrue("ags.skippTABS")) {
                    return this.failRequest(-8, "Vynech\u00e1v\u00e1m - ags.skippTABS=true");
                }
                boolean hideMoreInfo = false;
                String string = tabTitle = useMSISDN ? "MSISDN: " + e.getMsisdn() : "SU: " + e.getObjectId();
                if (e.getPin() == null || "".equals(e.getPin())) {
                    String defaultPIN;
                    if (e.getUsr() == null || !e.getUsr().startsWith("CONTA")) {
                        hideMoreInfo = true;
                    }
                    if ((defaultPIN = this.handler.getConfValue("ags.defaultPIN")) == null || "".equals(defaultPIN)) {
                        defaultPIN = "0";
                    }
                    e.setPin(defaultPIN);
                }
                this.dbFlush();
                Long sessionId = this.getTab(tabObjectId, tabTitle, this.getDefaultClfyUser(), e, useMSISDN, hideMoreInfo, (WintellActionContext)requestContext);
                if (useDebugInfo) {
                    this.om.addDebugInfo("WINTELL_SESSION_ID: " + sessionId);
                }
                this.em.merge((Object)e);
                if (this.handler.isConfValueTrue("ags.skippDG")) {
                    return this.assignResults(e, null, -6, (WintellActionContext)requestContext);
                }
                baRequest = null;
                try {
                    if (!mo.containsKey("__REUSE_BA_FILE")) break block84;
                    log.info((WintellActionContext)requestContext, "__REUSE_BA_FILE=" + mo.get("__REUSE_BA_FILE"));
                    this.om.logEvent(e, "reuse BLAZE REQUEST FROM FILE:" + mo.get("__REUSE_BA_FILE"), "BA.fake", "REQ", (WintellActionContext)requestContext);
                    String xml = null;
                    FileInputStream stream = new FileInputStream(new File(mo.get("__REUSE_BA_FILE")));
                    try {
                        FileChannel fc = stream.getChannel();
                        MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
                        xml = Charset.defaultCharset().decode(bb).toString();
                    }
                    finally {
                        stream.close();
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((WintellActionContext)requestContext, "__REUSE_BA_XML=" + xml);
                    }
                    st = new WintellRequestStep(Request.class, (WintellActionContext)requestContext);
                    baRequest = (Request)st.getObject(xml);
                }
                catch (Exception er) {
                    String err2 = "error in fake-query of blaze:" + er.getMessage();
                    log.error((WintellActionContext)requestContext, err2, (Throwable)er);
                    this.om.logEvent(e, er.getMessage(), "BA.fake", "ERR", (WintellActionContext)requestContext);
                    return err2;
                }
            }
            this.wTabs.setErrorMessage(tabObjectId, null);
            if (baRequest == null) {
                Iterator err3;
                String err4;
                try {
                    if (oldEvent != null && mo.containsKey("__REUSED")) {
                        this.om.logEvent(e, "reuse data by tibco from request:" + mo.get("__REUSED"), "DG.fake", "REQ", (WintellActionContext)requestContext);
                        for (RequestLog rl : oldEvent.getLogReq()) {
                            if (log.isDebugEnabled()) {
                                log.debug((WintellActionContext)requestContext, "REUSE: id=" + rl.getPosition() + ", type=" + rl.getType() + ", state=" + rl.getState());
                            }
                            if (!rl.getType().equals("DG") && !rl.getType().startsWith("DG.") || !rl.getState().equals("RESP")) continue;
                            st = new WintellRequestStep(WintellResponse.class, (WintellActionContext)requestContext);
                            this.wTabs.setRvaResponse(tabObjectId, (WintellResponse)st.getObject(rl.getXml()));
                            break;
                        }
                        if (this.wTabs.getRvaResponse(tabObjectId) == null) {
                            err4 = "cannot reuse tibco data from request:" + mo.get("__REUSED");
                            log.error((WintellActionContext)requestContext, err4);
                            return err4;
                        }
                        this.om.logEvent(e, this.wTabs.getRvaResponse(tabObjectId), "DG.fake", "RESP", (WintellActionContext)requestContext);
                    } else if (this.wTabs.getRvaResponse(tabObjectId) == null || oldEvent != null || !useDgCache) {
                        WintellRequest req = new WintellRequest();
                        if (useMSISDN) {
                            req.setMSISDN(new String(e.getMsisdn()));
                        } else {
                            WintellRequest.Consumer consumer = new WintellRequest.Consumer();
                            consumer.setCSTYPE(4);
                            consumer.setEXTIDCS(Integer.parseInt(e.getSuid()));
                            req.setConsumer(consumer);
                            consumer = null;
                        }
                        this.om.logEvent(e, req, "DG", "REQ", (WintellActionContext)requestContext, null, WintellStats.RequestState.GATHERING_DATA);
                        try {
                            this.wTabs.setRvaResponse(tabObjectId, this.handler.reqFindCallerAGS(req, e.getInterid(), e.getRequestId() * 100L + 1L, (WintellActionContext)requestContext));
                            req = null;
                        }
                        catch (TibRvaTimeout er) {
                            this.om.logEvent(e, er.getMessage(), "DG", "ERR", (WintellActionContext)requestContext, WintellStats.RequestState.GATHERING_DATA, null);
                            log.error((WintellActionContext)requestContext, er.getMessage());
                            if (reportDGerrors2user) {
                                return er.getMessage();
                            }
                            err = this.getErrStringForTimeOut(e, er, 1, null);
                            this.wTabs.setErrorMessage(tabObjectId, err);
                            return this.assignResults(e, null, -103, (WintellActionContext)requestContext);
                        }
                        catch (Exception er) {
                            this.om.logEvent(e, er.toString(), "DG", "ERR", (WintellActionContext)requestContext, WintellStats.RequestState.GATHERING_DATA, null);
                            err = "cannot gather data by RVA:" + er.toString();
                            if (er instanceof TibRvaError && (er.toString().contains("QSUB_SUBSCRIBER_BY_MSISDN 0") || er.toString().contains("QSUB_SUBSCRIBER_BY_ID0") || er.toString().contains("No record found in "))) {
                                log.error((WintellActionContext)requestContext, err);
                                return this.assignResults(e, null, -101, (WintellActionContext)requestContext);
                            }
                            log.error((WintellActionContext)requestContext, err, (Throwable)er);
                            if (reportDGerrors2user) {
                                return err;
                            }
                            String err2 = this.getErrStringForTimeOut(e, null, 1, err);
                            this.wTabs.setErrorMessage(tabObjectId, err2);
                            return this.assignResults(e, null, -104, (WintellActionContext)requestContext);
                        }
                        if (this.wTabs.getRvaResponse(tabObjectId) != null) {
                            this.om.logEvent(e, this.wTabs.getRvaResponse(tabObjectId), "DG", "RESP", (WintellActionContext)requestContext, WintellStats.RequestState.GATHERING_DATA, null);
                        }
                    } else {
                        this.om.logEvent(e, this.wTabs.getRvaResponse(tabObjectId), "DG.cached", "RESP", (WintellActionContext)requestContext);
                    }
                    try {
                        e.setIrpTag(((Subscriber)((BillingArrangement)this.wTabs.getRvaResponse(tabObjectId).getResponseData().getBillingArrangementList().get(0)).getSubscriberList().get(0)).getIrpTags());
                    }
                    catch (Exception er) {
                        log.error((WintellActionContext)requestContext, "cannot set IrpTag: " + er.getMessage(), (Throwable)er);
                    }
                }
                catch (Exception er) {
                    err3 = "error in handling data (wintell cannot handle data gathered by RVA-AGS): " + er.getMessage();
                    this.om.logEvent(e, err3, "DG", "ERR", (WintellActionContext)requestContext, WintellStats.RequestState.GATHERING_DATA, null);
                    log.error((WintellActionContext)requestContext, (String)((Object)err3), (Throwable)er);
                    if (reportDGerrors2user) {
                        return err3;
                    }
                    return this.assignResults(e, null, -104, (WintellActionContext)requestContext);
                }
                if (!useMSISDN) {
                    try {
                        e.setMsisdn(((Subscriber)((BillingArrangement)this.wTabs.getRvaResponse(tabObjectId).getResponseData().getBillingArrangementList().get(0)).getSubscriberList().get(0)).getMsisdn());
                    }
                    catch (Exception er) {
                        log.error((WintellActionContext)requestContext, "cannot set MSISDN: " + er.getMessage(), (Throwable)er);
                    }
                }
                try {
                    if (oldEvent != null && mo.containsKey("__REUSED")) {
                        this.om.logEvent(e, "reuse data by tibco request:" + mo.get("__REUSED"), "DGM.fake", "REQ", (WintellActionContext)requestContext);
                        for (RequestLog rl : oldEvent.getLogReq()) {
                            if (!rl.getType().equals("DGM") && !rl.getType().startsWith("DGM.") || !rl.getState().equals("RESP")) continue;
                            st = new WintellRequestStep(MoreInfoResp.class, (WintellActionContext)requestContext);
                            this.wTabs.setMiResp(tabObjectId, (MoreInfoResp)st.getObject(rl.getXml()));
                            break;
                        }
                        if (this.wTabs.getMiResp(tabObjectId) == null) {
                            err4 = "cannot reuse tibco data on MI request:" + mo.get("__REUSED");
                            log.error((WintellActionContext)requestContext, err4);
                            return err4;
                        }
                        this.om.logEvent(e, this.wTabs.getMiResp(tabObjectId), "DGM.fake", "RESP", (WintellActionContext)requestContext);
                        break block86;
                    }
                    if (this.wTabs.getMiResp(tabObjectId) == null || oldEvent != null || !useDgCache) {
                        MoreInfoReq miReq = new MoreInfoReq();
                        if (useMSISDN) {
                            miReq.setMSISDN(e.getMsisdn());
                        } else {
                            miReq.setSubscriberId(new BigInteger(e.getSuid()));
                        }
                        miReq.setBillingArrangementInfo(true);
                        miReq.setPacList(true);
                        boolean useSkillList = this.handler.isConfValueTrueDefaultTrue("ags.useSkillList");
                        if (e.getPin() != null && !"".equals(e.getPin())) {
                            miReq.setUserPin(new BigInteger(e.getPin()));
                        } else {
                            useSkillList = false;
                        }
                        miReq.setSkillList(useSkillList);
                        boolean useCustomerInfo = this.handler.isConfValueTrueDefaultTrue("ags.useCustomerInfo");
                        miReq.setCustomerInfo(useCustomerInfo);
                        boolean useSubscriberInfo = this.handler.isConfValueTrueDefaultTrue("ags.useSubscriberInfo");
                        miReq.setSubscriberInfo(useSubscriberInfo);
                        miReq.setTLSPoints(true);
                        miReq.setTeamMemberFullInfo(false);
                        this.om.logEvent(e, miReq, "DGM", "REQ", (WintellActionContext)requestContext, null, WintellStats.RequestState.GATHERING_DATA);
                        try {
                            this.wTabs.setMiResp(tabObjectId, this.handler.reqMoreInfo(miReq, e.getInterid(), e.getRequestId() * 100L + 2L, (WintellActionContext)requestContext));
                            miReq = null;
                        }
                        catch (TibRvaTimeout er) {
                            if (this.wTabs.getMiResp(tabObjectId) == null) {
                                this.om.logEvent(e, er.getMessage(), "DGM", "ERR", (WintellActionContext)requestContext, WintellStats.RequestState.GATHERING_DATA, null);
                                log.error((WintellActionContext)requestContext, er.getMessage());
                                if (reportDGerrors2user) {
                                    return er.getMessage();
                                }
                                String err5 = this.getErrStringForTimeOut(e, er, 2, null);
                                this.wTabs.setErrorMessage(tabObjectId, err5);
                                return this.assignResults(e, null, -103, (WintellActionContext)requestContext);
                            }
                        }
                        catch (Exception er) {
                            this.om.logEvent(e, er.toString(), "DGM", "ERR", (WintellActionContext)requestContext, WintellStats.RequestState.GATHERING_DATA, null);
                            String err6 = "cannot gather MI data by RVA:" + er.toString();
                            log.error((WintellActionContext)requestContext, err6, (Throwable)er);
                            if (reportDGerrors2user) {
                                return err6;
                            }
                            String err2 = this.getErrStringForTimeOut(e, null, 2, err6);
                            this.wTabs.setErrorMessage(tabObjectId, err2);
                            return this.assignResults(e, null, -104, (WintellActionContext)requestContext);
                        }
                        if (this.wTabs.getMiResp(tabObjectId) != null) {
                            this.om.logEvent(e, this.wTabs.getMiResp(tabObjectId), "DGM", "RESP", (WintellActionContext)requestContext, WintellStats.RequestState.GATHERING_DATA, null);
                        }
                        break block86;
                    }
                    this.om.logEvent(e, this.wTabs.getMiResp(tabObjectId), "DGM.cached", "RESP", (WintellActionContext)requestContext);
                }
                catch (Exception er) {
                    err3 = "error in handling data (wintell cannot handle data gathered by RVA-MI): " + er.getMessage();
                    this.om.logEvent(e, err3, "DGM", "ERR", (WintellActionContext)requestContext, WintellStats.RequestState.GATHERING_DATA, null);
                    log.error((WintellActionContext)requestContext, (String)((Object)err3), (Throwable)er);
                    if (reportDGerrors2user) {
                        return err3;
                    }
                    return this.assignResults(e, null, -104, (WintellActionContext)requestContext);
                }
            }
        }
        String ret = "success";
        if (baRequest != null || this.wTabs.getRvaResponse(tabObjectId) != null && this.wTabs.getMiResp(tabObjectId) != null) {
            if (baRequest == null) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((WintellActionContext)requestContext, "before BL initRequest");
                    }
                    if (!this.handler.isConfValueTrue("ags.skippInitRequest")) {
                        RequestClass rc = new RequestClass(this.httpSessionContext, this.em);
                        baRequest = rc.initRequest(e, this.wTabs.getRvaResponse(tabObjectId).getResponseData(), this.wTabs.getMiResp(tabObjectId), (WintellActionContext)requestContext);
                        rc = null;
                    }
                }
                catch (Exception er) {
                    err = "cannot create query for blaze";
                    this.om.logEvent(e, err, "AS", "ERR", (WintellActionContext)requestContext);
                    log.fatal((WintellActionContext)requestContext, err, (Throwable)er);
                    return this.assignResults(e, null, -106, (WintellActionContext)requestContext);
                }
                if (baRequest == null) {
                    this.om.logEvent(e, "NULL baRequest", "AS", "ERR", (WintellActionContext)requestContext);
                    return this.assignResults(e, null, -106, (WintellActionContext)requestContext);
                }
            }
            Response baResponse = null;
            try {
                if (mo.containsKey("__REUSED")) {
                    this.om.logEvent(e, "reuse BLAZE RESPONSE:" + mo.get("__REUSED"), "BA.fake", "REQ", (WintellActionContext)requestContext);
                    for (RequestLog rl : oldEvent.getLogReq()) {
                        if (!rl.getType().equals("BA") && !rl.getType().startsWith("BA.") || !rl.getState().equals("RESP")) continue;
                        WintellRequestStep st = new WintellRequestStep(Response.class, (WintellActionContext)requestContext);
                        baResponse = (Response)st.getObject(rl.getXml());
                        break;
                    }
                    this.om.logEvent(e, baResponse, "BA.fake", "RESP", (WintellActionContext)requestContext);
                    return this.assignResults(e, baResponse, 0, (WintellActionContext)requestContext);
                }
            }
            catch (Exception er) {
                String err7 = "error in fake-query of blaze:" + er.getMessage();
                log.error((WintellActionContext)requestContext, err7, (Throwable)er);
                this.om.logEvent(e, er.getMessage(), "BA.fake", "ERR", (WintellActionContext)requestContext);
                return err7;
            }
            boolean disableBlazeCalls = this.handler.isConfValueTrue("ags.disableBlazeCalls");
            if (!disableBlazeCalls) {
                if (log.isDebugEnabled()) {
                    log.debug((WintellActionContext)requestContext, "before BL call");
                }
                Query q = this.em.createNamedQuery("offerActivityForPressed");
                q.setParameter("objectId", (Object)objectId).setParameter("objectType", (Object)objectType);
                for (WintellOfferActivity woa : q.getResultList()) {
                    HashSet<Integer> hs = new HashSet<Integer>();
                    for (WintellActionOutput wao : woa.getActionActivities()) {
                        hs.add(wao.getButton().getButtonId());
                    }
                    Object[] objectArray = hs.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        Integer buttonId = (Integer)obj;
                        if (woa.isButtonPressed(buttonId.intValue())) {
                            OfferAction oa = new OfferAction(woa.getDateTime(), woa.getOffer().getOfferId(), woa.getOfferCategory().getOfferCategoryId(), OfferButtonEnumeration.fromId((int)buttonId));
                            if (log.isDebugEnabled()) {
                                log.debug((WintellActionContext)requestContext, "addOfferAction for the [object id=" + objectId + " type=" + objectType + "]=>" + oa.toString());
                            }
                            baRequest.addOfferAction(oa);
                        }
                        ++n2;
                    }
                }
                try {
                    baResponse = this.callBlaze(e, (WintellActionContext)requestContext, platform, platformDescr, baRequest);
                }
                catch (WintellAppException er) {
                    String err6 = "error in query of blaze:" + er.getMessage();
                    log.error((WintellActionContext)requestContext, err6, (Throwable)er);
                    this.om.logEvent(e, er.getMessage(), "BA", "ERR", (WintellActionContext)requestContext, WintellStats.RequestState.EVALUATING_IN_BLAZE, null);
                    return this.assignResults(e, null, -106, (WintellActionContext)requestContext);
                }
                this.om.logEvent(e, baResponse, "BA", "RESP", (WintellActionContext)requestContext, WintellStats.RequestState.EVALUATING_IN_BLAZE, null);
                if (log.isDebugEnabled()) {
                    log.debug((WintellActionContext)requestContext, "after BL call");
                }
                this.sendStats(e.getRequestId(), e.getMsisdn(), baResponse.getVisitedCategories(), (WintellActionContext)requestContext);
            }
            ret = this.assignResults(e, baResponse, 0, (WintellActionContext)requestContext);
        }
        this.dbFlush();
        this.om.logEvent(e, "", "EV", "STOP", (WintellActionContext)requestContext);
        return ret;
    }

    private String getErrStringForTimeOut(AgsEvent e, TibRvaTimeout er, int reqIdOffset, String errorString) {
        String err = "&nbsp;Pro efektivn\u00ed zpracov\u00e1n\u00ed va\u0161eho po\u017eadavku zkop\u00edrujte n\u00e1sleduj\u00edc\u00ed text do t\u011bla Service callu:</br><i>";
        err = String.valueOf(err) + "REQUEST_ID=" + e.getRequestId();
        err = String.valueOf(err) + ", INTER_ID=" + e.getInterid();
        err = String.valueOf(err) + ", TIBCO.REQUEST_ID=" + (e.getRequestId() * 100L + (long)reqIdOffset);
        if (errorString != null) {
            err = String.valueOf(err) + " : " + errorString;
        }
        if (er != null) {
            err = er.isOverloaded() ? String.valueOf(err) + " : nedostatek vl\u00e1ken pro p\u0159ipojen\u00ed na Tibco : " + er.getMessage() : String.valueOf(err) + " : " + er.getMessage();
        }
        return String.valueOf(err.replaceAll("\n", "</br>\n")) + "</i >";
    }

    private Response callBlaze(AgsEvent e, WintellActionContext requestContext, String platform, String platformDescr, Request baRequest) throws WintellAppException {
        Response baResponse;
        String blazePlatform = "AGSProduction";
        if (platform != null) {
            blazePlatform = "AGS" + platform;
            platformDescr = "(" + platform + ")";
        }
        if (e.getClass() == NotifyAcceptCaseEvent.class) {
            this.om.logEvent(e, baRequest, "BA-AcceptCase" + platformDescr, "REQ", requestContext, null, WintellStats.RequestState.EVALUATING_IN_BLAZE);
            baResponse = this.blaze.invokeacceptCaseDebugEP(blazePlatform, baRequest, requestContext);
        } else if (e.getClass() == NotifySaveCaseEvent.class) {
            this.om.logEvent(e, baRequest, "BA-SaveCase" + platformDescr, "REQ", requestContext, null, WintellStats.RequestState.EVALUATING_IN_BLAZE);
            baResponse = this.blaze.invokesaveCaseDebugEP(blazePlatform, baRequest, requestContext);
        } else {
            this.om.logEvent(e, baRequest, "BA-FindCaller" + platformDescr, "REQ", requestContext, null, WintellStats.RequestState.EVALUATING_IN_BLAZE);
            baResponse = this.blaze.invokefindCallerDebugEP(blazePlatform, baRequest, requestContext);
        }
        return baResponse;
    }

    public AgsEvent createEvent(TreeMap<String, String> mo, String logMessage, WintellActionContext ctx) throws Exception {
        AgsEvent e = null;
        try {
            e = (AgsEvent)EventFactory.createEvent(mo, (WintellActionContext)ctx);
        }
        catch (Exception er) {
            log.error((WintellActionContext)this.httpSessionContext, "cannot create AgsEvent: " + er.getMessage());
            throw new Exception("cannot create AgsEvent:" + er.getMessage() + "\nfor:\n" + logMessage, er);
        }
        this.setObjectIds(e);
        this.em.persist((Object)e);
        if (e.getInterid() == null || e.getInterid().equals("")) {
            e.setInterid(String.format("WIN%s%06d", yyMMddFormat.format(new Date()), e.getRequestId() % 1000000L));
            log.info((WintellActionContext)this.httpSessionContext, "request:" + e.getRequestId() + ", generate interactionId:" + e.getInterid());
        }
        this.om.logEvent(e, logMessage, "EV", "CR-EVENT", ctx);
        this.om.addFlag("R", e.getRequestId().toString());
        return e;
    }

    public AgsEvent findOldEvent(TreeMap<String, String> mo) throws Exception {
        String logMessage = "";
        Long oldReqId = Long.parseLong(mo.get("BLAZE_REUSE_REQ"));
        log.info((WintellActionContext)this.httpSessionContext, "REUSE_REQ: " + oldReqId);
        AgsEvent oldEvent = (AgsEvent)this.em.find(AgsEvent.class, (Object)oldReqId);
        if (oldEvent == null) {
            throw new Exception("REUSE_REQ: cannot get AgsEvent(request_id=" + oldReqId + ")");
        }
        RequestLog rlf = null;
        for (RequestLog rl : oldEvent.getLogReq()) {
            if (!rl.getType().equals("EV") || !rl.getState().equals("CR-EVENT")) continue;
            rlf = rl;
            break;
        }
        if (rlf == null) {
            throw new Exception("REUSE_REQ: cannot get RequestLog = AgsEvent(request_id=" + oldReqId + ").get(0)");
        }
        Pattern paramP = Pattern.compile("^([^=]+)=(.*)", 42);
        mo.clear();
        mo.put("__REUSED", "" + oldReqId);
        String[] stringArray = rlf.getXml().split("\\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String par = stringArray[n2];
            Matcher paramM = paramP.matcher(par);
            if (paramM.matches()) {
                mo.put(paramM.group(1), paramM.group(2));
                logMessage = String.valueOf(logMessage) + "\n" + paramM.group(1) + "=" + paramM.group(2);
                if (log.isDebugEnabled()) {
                    log.debug((WintellActionContext)this.httpSessionContext, "REUSE_REQ: reuse param:" + paramM.group(1) + "=" + paramM.group(2));
                }
            } else {
                log.error((WintellActionContext)this.httpSessionContext, "REUSE_REQ: cannot match (from logReq as param=value) this line:" + par);
            }
            ++n2;
        }
        this.setObjectIds(oldEvent);
        return oldEvent;
    }

    private void setObjectIds(AgsEvent e) {
        if (e.getSuid() != null && !"".equals(e.getSuid())) {
            e.setObjectType(4);
            e.setObjectId(e.getSuid());
        }
    }

    private void updateTS(String ts, Map<String, String> mo) {
        if (ts.equals("NOW")) {
            String chP = mo.get("CH");
            if (chP != null && chP.equals("CLARIFY")) {
                mo.put("TS", yyyyMMddHHmmssFormat.format(new Date()));
            } else {
                mo.put("TS", "" + new Date().getTime());
            }
        }
    }

    private String assignResults(AgsEvent e, Response baResponse, int errorCode, WintellActionContext requestContext) throws WintellAppException {
        ArrayList<DecisionOutput> soL = null;
        if (baResponse != null) {
            soL = new ArrayList(baResponse.getDecisionOutputList());
            this.om.setFolderCategories(baResponse.getFoldedCategories());
        } else {
            soL = new ArrayList<DecisionOutput>();
        }
        String ret = this.assignResults2(soL, e, errorCode, requestContext);
        soL.clear();
        soL = null;
        return ret;
    }

    private String assignResults2(List<DecisionOutput> soL, AgsEvent e, int errorCode, WintellActionContext requestContext) throws WintellAppException {
        this.dbFlush();
        String fakeOffers = this.handler.getConfValue("ags.fakeOffers");
        if (fakeOffers != null) {
            String[] stringArray = fakeOffers.split("\\|");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String o = stringArray[n2];
                String[] xx = o.split(",");
                try {
                    Integer offerId = Integer.parseInt(xx[0]);
                    Integer categoryId = Integer.parseInt(xx[1]);
                    Integer priority = Integer.parseInt(xx[2]);
                    DecisionOutput oA = new DecisionOutput();
                    oA.setCategoryId(categoryId.intValue());
                    oA.setId(offerId.intValue());
                    oA.setListPriority(priority.intValue());
                    soL.add(oA);
                    log.info(requestContext, "adding fake offer(id=" + offerId + ",categoryId=" + categoryId + ",priority=" + priority + ")");
                }
                catch (Exception er) {
                    log.error(requestContext, "cannot handle fake offers", (Throwable)er);
                }
                ++n2;
            }
        }
        if (errorCode != 0) {
            this.om.setErrCode(errorCode);
            log.info(requestContext, "Adding error offer, code: " + errorCode);
            DecisionOutput errorDecisionOutput = new DecisionOutput();
            errorDecisionOutput.setId(errorCode);
            errorDecisionOutput.setCategoryId(-101);
            soL.add(errorDecisionOutput);
        }
        if (e == null) {
            return "success";
        }
        Collections.sort(soL, new OutputSort());
        HashSet<Integer> uniqueOfferIds = new HashSet<Integer>();
        for (DecisionOutput o : soL) {
            if (uniqueOfferIds.contains(o.getId())) continue;
            uniqueOfferIds.add(o.getId());
            this.om.startState(WintellStats.RequestState.HISTORY_SEARCHING, requestContext);
            WintellOfferActivity oldOffer = this.check(o.getId(), e.getObjectType(), e.getObjectId(), requestContext);
            this.om.stopState(WintellStats.RequestState.HISTORY_SEARCHING, requestContext);
            this.addOffer(o, e, oldOffer, requestContext);
        }
        uniqueOfferIds.clear();
        if (e.getOffers().isEmpty()) {
            log.info(requestContext, "No offers and warnings found, add no offer error");
            DecisionOutput errorDecisionOutput = new DecisionOutput();
            errorDecisionOutput.setId(-105);
            errorDecisionOutput.setCategoryId(-101);
            this.addOffer(errorDecisionOutput, e, null, requestContext);
        }
        return "success";
    }

    private void addOffer(DecisionOutput o, AgsEvent e, WintellOfferActivity oldOffer, WintellActionContext requestContext) {
        WintellOfferActivity act = new WintellOfferActivity();
        WintellOffer of = (WintellOffer)this.em.find(WintellOffer.class, (Object)o.getId());
        if (of == null) {
            log.fatal(requestContext, "offer not found, id=" + o.getId());
            return;
        }
        WintellOfferCategory ofC = (WintellOfferCategory)this.em.find(WintellOfferCategory.class, (Object)o.getCategoryId());
        if (ofC == null) {
            log.fatal(requestContext, "offerCategory not found, id=" + o.getCategoryId() + ", offerId: " + o.getId());
            return;
        }
        if (oldOffer != null) {
            if (log.isDebugEnabled()) {
                log.debug(requestContext, "oldOfferActivity for the same offerId=" + o.getId() + " and object id=" + e.getObjectId() + " type=" + e.getObjectType() + " found:" + oldOffer.getOfferActivityId());
            }
            if (oldOffer.isAccepted()) {
                if (this.handler.isConfValueTrueDefaultTrue("ags.skippAcceptedOrDeclined")) {
                    log.info(requestContext, "oldOfferActivity for the same offerId=" + o.getId() + " and object id=" + e.getObjectId() + " type=" + e.getObjectType() + " found:" + oldOffer.getOfferActivityId() + " isAccepted, so SKIPPING");
                    return;
                }
                act.setAccepted(true);
            }
            if (oldOffer.isDeclined()) {
                if (this.handler.isConfValueTrueDefaultTrue("ags.skippAcceptedOrDeclined")) {
                    log.info(requestContext, "oldOfferActivity for the same offerId=" + o.getId() + " and object id=" + e.getObjectId() + " type=" + e.getObjectType() + " found:" + oldOffer.getOfferActivityId() + " isDeclined, so SKIPPING");
                    return;
                }
                act.setDeclined(true);
            }
            if (oldOffer.isOffered()) {
                act.setOffered(true);
            }
        }
        act.setSomeButtonPressed(false);
        act.setEvent((GeneralEvent)e);
        act.setOffer(of);
        act.setOfferCategory(ofC);
        act.setObjectId(e.getObjectId());
        act.setObjectType(e.getObjectType());
        act.setPriority(Integer.valueOf(o.getListPriority()));
        if (o.getCssClasses() != null) {
            act.setCssClasses(o.getCssClasses());
        } else if (of != null && of.getDefaultCssClasses() != null) {
            act.setCssClasses(of.getDefaultCssClasses());
        } else {
            act.setCssClasses("default");
        }
        this.em.persist((Object)act);
        e.addOffer(act, requestContext);
        if (log.isInfoEnabled()) {
            log.info(requestContext, "add offerActivity(id=" + act.getOfferActivityId() + ",offerId=" + act.getOffer().getOfferId() + ",offerCategoryId=" + act.getOfferCategory().getOfferCategoryId() + ",prio=" + act.getPriority() + ",cssClasses=" + act.getCssClasses() + ")");
        }
        if (log.isDebugEnabled()) {
            log.debug(requestContext, "offerActivity[id=" + act.getOfferActivityId() + "]: " + act.getOfferCategory().getName() + " / " + act.getOffer().getDescription());
        }
    }

    private String hash4params(String s_in, String algN, String encoding) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        String sharedSecret = this.handler.getConfValue("ags.sharedKey");
        MessageDigest alg = MessageDigest.getInstance(algN);
        String QueryWithSecret = String.valueOf(s_in) + "&s=" + sharedSecret;
        sharedSecret = null;
        alg.update(QueryWithSecret.getBytes(encoding));
        QueryWithSecret = null;
        byte[] digest = alg.digest();
        alg = null;
        String ret = RequestBean.asciiArmor(digest);
        digest = null;
        return ret;
    }

    static String asciiArmor(byte[] digest) {
        StringBuilder hexString = new StringBuilder(digest.length * 2);
        int i = 0;
        while (i < digest.length) {
            String plainText = Integer.toHexString(0xFF & digest[i]);
            if (plainText.length() < 2) {
                plainText = "0" + plainText;
            }
            hexString.append(plainText);
            ++i;
        }
        String ret = hexString.toString();
        hexString = null;
        return ret;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=30L)
    public String getWintellEvent() {
        try {
            return this.getWintellEvent2();
        }
        catch (Exception e) {
            log.error((WintellActionContext)this.httpSessionContext, "ERROR in getWintellEvent" + e.getMessage(), (Throwable)e);
            return this.failRequest(-1, "Neo\u0161et\u0159en\u00e1 vyj\u00edmka (" + e.getClass().getName() + "): " + e.getMessage());
        }
    }

    public String getWintellEvent2() {
        String ret;
        TreeMap<String, String> mo;
        block47: {
            block48: {
                block45: {
                    String string;
                    block46: {
                        block43: {
                            String string2;
                            block44: {
                                FacesContext facesContext;
                                Map m;
                                block41: {
                                    block42: {
                                        block39: {
                                            String string3;
                                            block40: {
                                                m = null;
                                                mo = null;
                                                ret = null;
                                                if (log.isDebugEnabled()) {
                                                    log.debug((WintellActionContext)this.httpSessionContext, "entry getWintellEvent()");
                                                }
                                                if (!this.handler.isConfValueTrue("ags.skippALL0")) break block39;
                                                this.wTabs.logIn("NO-USER");
                                                string3 = this.failRequest(-9, "Vynech\u00e1v\u00e1m - ags.skippALL0=true");
                                                if (mo != null) {
                                                    mo = null;
                                                }
                                                if (ret != null && "success".equals(ret)) break block40;
                                                log.error((WintellActionContext)this.httpSessionContext, "request returned error: " + ret + " : " + this.wTabs.getLastError());
                                                if ("session-expired".equals(ret)) {
                                                    return this.failRequest(-11, ret);
                                                }
                                                if (ret == null) {
                                                    return this.failRequest(-1, "Do\u0161lo k nezn\u00e1m\u00e9 chyb\u011b");
                                                }
                                                return ret;
                                            }
                                            return string3;
                                        }
                                        this.newRequest = false;
                                        facesContext = FacesContext.getCurrentInstance();
                                        if (facesContext != null) break block41;
                                        log.info((WintellActionContext)this.httpSessionContext, "facesContext == null");
                                        if (mo != null) {
                                            mo = null;
                                        }
                                        if (ret != null && "success".equals(ret)) break block42;
                                        log.error((WintellActionContext)this.httpSessionContext, "request returned error: " + ret + " : " + this.wTabs.getLastError());
                                        if ("session-expired".equals(ret)) {
                                            return this.failRequest(-11, ret);
                                        }
                                        if (ret == null) {
                                            return this.failRequest(-1, "Do\u0161lo k nezn\u00e1m\u00e9 chyb\u011b");
                                        }
                                        return ret;
                                    }
                                    return "noauth";
                                }
                                m = facesContext.getExternalContext().getRequestParameterMap();
                                mo = new TreeMap<String, String>(m);
                                ret = this.getWintellEventTest(m, mo);
                                this.trimLru();
                                if (!"success".equals(ret) || this.newRequest) break block43;
                                string2 = this.om.setErrcodeOK(ret);
                                if (mo != null) {
                                    mo = null;
                                }
                                if (ret != null && "success".equals(ret)) break block44;
                                log.error((WintellActionContext)this.httpSessionContext, "request returned error: " + ret + " : " + this.wTabs.getLastError());
                                if ("session-expired".equals(ret)) {
                                    return this.failRequest(-11, ret);
                                }
                                if (ret == null) {
                                    return this.failRequest(-1, "Do\u0161lo k nezn\u00e1m\u00e9 chyb\u011b");
                                }
                                return ret;
                            }
                            return string2;
                        }
                        if ("success".equals(ret)) break block45;
                        string = ret;
                        if (mo != null) {
                            mo = null;
                        }
                        if (ret != null && "success".equals(ret)) break block46;
                        log.error((WintellActionContext)this.httpSessionContext, "request returned error: " + ret + " : " + this.wTabs.getLastError());
                        if ("session-expired".equals(ret)) {
                            return this.failRequest(-11, ret);
                        }
                        if (ret == null) {
                            return this.failRequest(-1, "Do\u0161lo k nezn\u00e1m\u00e9 chyb\u011b");
                        }
                        return ret;
                    }
                    return string;
                }
                try {
                    if (this.wTabs.isLogged()) break block47;
                    if (mo != null) {
                        mo = null;
                    }
                    if (ret != null && "success".equals(ret)) break block48;
                }
                catch (Exception er) {
                    String string;
                    block51: {
                        block49: {
                            String string4;
                            block50: {
                                try {
                                    if (er.getMessage() == null || !er.getMessage().endsWith(": Cannot open connection")) break block49;
                                    log.fatal((WintellActionContext)this.httpSessionContext, "System overloaded - " + er.getMessage(), (Throwable)er);
                                    string4 = ret = this.failRequest(-10, "Syst\u00e9m je moment\u00e1ln\u011b p\u0159et\u00ed\u017een - " + er.getMessage());
                                    if (mo != null) {
                                        mo = null;
                                    }
                                    if (ret != null && "success".equals(ret)) break block50;
                                }
                                catch (Throwable throwable) {
                                    if (mo != null) {
                                        mo = null;
                                    }
                                    if (ret == null || !"success".equals(ret)) {
                                        log.error((WintellActionContext)this.httpSessionContext, "request returned error: " + ret + " : " + this.wTabs.getLastError());
                                        if ("session-expired".equals(ret)) {
                                            return this.failRequest(-11, ret);
                                        }
                                        if (ret == null) {
                                            return this.failRequest(-1, "Do\u0161lo k nezn\u00e1m\u00e9 chyb\u011b");
                                        }
                                        return ret;
                                    }
                                    throw throwable;
                                }
                                log.error((WintellActionContext)this.httpSessionContext, "request returned error: " + ret + " : " + this.wTabs.getLastError());
                                if ("session-expired".equals(ret)) {
                                    return this.failRequest(-11, ret);
                                }
                                if (ret == null) {
                                    return this.failRequest(-1, "Do\u0161lo k nezn\u00e1m\u00e9 chyb\u011b");
                                }
                                return ret;
                            }
                            return string4;
                        }
                        log.fatal((WintellActionContext)this.httpSessionContext, "unhandled exeption: " + er.getMessage(), (Throwable)er);
                        string = ret = this.failRequest(-1, "Neo\u0161et\u0159en\u00e1 vyj\u00edmka (" + er.getClass().getName() + "): " + er.getMessage());
                        if (mo != null) {
                            mo = null;
                        }
                        if (ret != null && "success".equals(ret)) break block51;
                        log.error((WintellActionContext)this.httpSessionContext, "request returned error: " + ret + " : " + this.wTabs.getLastError());
                        if ("session-expired".equals(ret)) {
                            return this.failRequest(-11, ret);
                        }
                        if (ret == null) {
                            return this.failRequest(-1, "Do\u0161lo k nezn\u00e1m\u00e9 chyb\u011b");
                        }
                        return ret;
                    }
                    return string;
                }
                log.error((WintellActionContext)this.httpSessionContext, "request returned error: " + ret + " : " + this.wTabs.getLastError());
                if ("session-expired".equals(ret)) {
                    return this.failRequest(-11, ret);
                }
                if (ret == null) {
                    return this.failRequest(-1, "Do\u0161lo k nezn\u00e1m\u00e9 chyb\u011b");
                }
                return ret;
            }
            return "session-expired";
        }
        if (mo != null) {
            mo = null;
        }
        if (ret == null || !"success".equals(ret)) {
            log.error((WintellActionContext)this.httpSessionContext, "request returned error: " + ret + " : " + this.wTabs.getLastError());
            if ("session-expired".equals(ret)) {
                return this.failRequest(-11, ret);
            }
            if (ret == null) {
                return this.failRequest(-1, "Do\u0161lo k nezn\u00e1m\u00e9 chyb\u011b");
            }
            return ret;
        }
        return this.om.setErrcodeOK("success");
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=30L)
    public void prepareOM() throws WintellException {
        boolean showErrorTab = this.wTabs.isShowErrorTab();
        String lastError = this.wTabs.getLastError();
        boolean debugEvent = this.om.isDebugEvent();
        String activeTabId = this.wTabs.getActiveTabId();
        LinkedHashMap<String, WintellTabRequestCache> tabsCache = new LinkedHashMap<String, WintellTabRequestCache>();
        for (String objIdStr : this.wTabs.getTabIdsList()) {
            long sessionId = this.wTabs.getSessionId(objIdStr);
            String tabTitle = this.wTabs.getTabTitle(objIdStr);
            boolean hideMoreInfo = this.wTabs.isHideMoreInfo(objIdStr);
            DefaultWintellActionContext actionContext = this.httpSessionContext.getMoreSpecificContext(LogIdFactory.createWintellSessionId((long)sessionId));
            WintellTabRequestCache rc = new WintellTabRequestCache(sessionId, tabTitle, hideMoreInfo, (WintellActionContext)actionContext);
            tabsCache.put(objIdStr, rc);
        }
        this.om.prepare(tabsCache, showErrorTab, lastError, debugEvent, activeTabId);
        if (activeTabId != null && !activeTabId.equals("errorTab") && !activeTabId.equals("???")) {
            if (log.isDebugEnabled()) {
                log.debug((WintellActionContext)this.httpSessionContext, "prepareOM(activeTabid=" + activeTabId + ",lastError=" + lastError + ")");
            }
            this.om.setButtons(activeTabId, this.wTabs.getButtons(activeTabId, this.om.getAllOffers(activeTabId)));
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=30L)
    public void startRendering() {
        try {
            if (this.handler.isConfValueTrue("ags.skippStoreTabs")) {
                log.info((WintellActionContext)this.httpSessionContext, "clean all tabs (startRendering)");
                this.dbFlush();
                this.wTabs.closeAll();
            }
            this.wTabs.finishRequest();
            this.prepareOM();
            this.om.startRendering();
        }
        catch (Exception e) {
            log.error((WintellActionContext)this.httpSessionContext, "unhandled exception in startRendering()", (Throwable)e);
        }
    }

    private boolean checkTimeout(AgsEvent e) {
        Long diff;
        Long tsTimeoutSeconds;
        block4: {
            String tsTimeoutString;
            block5: {
                tsTimeoutString = this.handler.getConfValue("ags.tsTimeout");
                tsTimeoutSeconds = 60L;
                if (tsTimeoutString == null) break block4;
                if (!tsTimeoutString.equals("ANY")) break block5;
                return true;
            }
            try {
                tsTimeoutSeconds = Long.parseLong(tsTimeoutString);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (Math.abs(diff = Long.valueOf(new Date().getTime() - e.getTs().getTime())) <= tsTimeoutSeconds * 1000L) {
            diff = null;
            return true;
        }
        log.error((WintellActionContext)this.httpSessionContext, "timeout: |now(" + new Date() + ") - event.TS(" + e.getTs() + ") = " + diff + "ms| > " + tsTimeoutSeconds * 1000L);
        diff = null;
        return false;
    }

    private long getTab(String tabObjectId, String tabTitle, String defaultClfyUser, AgsEvent e, boolean useMSISDN, boolean hideMoreInfo, WintellActionContext requestContext) throws WintellAppException {
        try {
            Long wintellSessionId = null;
            WintellSession wintellSession = null;
            int i = 0;
            while (i < 2) {
                wintellSessionId = this.wTabs.getTab(tabObjectId, tabTitle, defaultClfyUser, e.getUsr(), e.getObjectId(), e.getObjectType(), useMSISDN, e.getMsisdn(), e.getPin(), e.getInterid(), hideMoreInfo, requestContext);
                wintellSession = (WintellSession)this.em.find(WintellSession.class, (Object)wintellSessionId);
                if (wintellSession != null) break;
                WintellAppException er = new WintellAppException("cannot find session(id=" + wintellSessionId + ") in database");
                if (i > 0) {
                    throw er;
                }
                log.fatal((WintellActionContext)this.httpSessionContext, er.getMessage());
                this.wTabs.closeTab(tabObjectId);
                ++i;
            }
            e.setSession(wintellSession);
            wintellSession.addEvent(e);
            this.wTabs.activate(tabObjectId);
            this.dbFlush();
            return wintellSessionId;
        }
        catch (Exception er) {
            if (er instanceof WintellAppException) {
                throw (WintellAppException)er;
            }
            throw new WintellAppException(er);
        }
    }

    public String getDefaultClfyUser() {
        String ret = this.handler.getConfValue("ags.defaultClfyUser");
        if (ret != null && !ret.equals("")) {
            return ret;
        }
        return "SY_WINTELL_USER";
    }

    public WintellOfferActivity check(int offerId, int objectType, String objectId, WintellActionContext requestContext) throws WintellAppException {
        Query q = this.em.createNamedQuery("offerActivityByOfferForPressed");
        q.setParameter("offerId", (Object)offerId);
        q.setParameter("objectId", (Object)objectId);
        q.setParameter("objectType", (Object)objectType);
        q.setMaxResults(1);
        WintellOfferActivity oldOffer = null;
        try {
            List l = q.getResultList();
            if (!l.isEmpty()) {
                log.debug(requestContext, "oldOfferActivity for the same offerId=" + offerId + " and object id=" + objectId + " type=" + objectType);
                oldOffer = (WintellOfferActivity)l.get(0);
            } else {
                log.debug(requestContext, "oldOfferActivity for the same offerId=" + offerId + " and object id=" + objectId + " type=" + objectType + " not found");
            }
        }
        catch (Exception er) {
            throw new WintellAppException(er);
        }
        return oldOffer;
    }

    private void dbFlush() throws WintellAppException {
        try {
            this.om.startState(WintellStats.RequestState.DB_FLUSH, (WintellActionContext)this.httpSessionContext);
            try {
                this.em.flush();
            }
            finally {
                this.om.stopState(WintellStats.RequestState.DB_FLUSH, (WintellActionContext)this.httpSessionContext);
            }
        }
        catch (Exception er) {
            if (er instanceof WintellAppException) {
                throw (WintellAppException)er;
            }
            throw new WintellAppException(er);
        }
    }

    private IWintellJmsSender newStatsSender() throws NamingException {
        InitialContext c = new InitialContext();
        return (IWintellJmsSender)c.lookup("java:app/wintell.jar/wintellJmsSender");
    }

    private void sendMessage(WintellActionContext ctx, Serializable m, String jmsCorrelationID) throws Exception {
        int retryCount = 5;
        while (retryCount > 0) {
            if (log.isDebugEnabled()) {
                log.debug(ctx, "sendMessage(jmsCorrelationID=" + jmsCorrelationID + ",before retryCount=" + retryCount + "x)");
            }
            try {
                IWintellJmsSender sender = this.newStatsSender();
                sender.sendMessage("statsQueue", m, jmsCorrelationID);
                return;
            }
            catch (Exception e) {
                log.warn(ctx, "sendMessage(statsQueue,jmsCorrelationID=" + jmsCorrelationID + ",try to retry " + retryCount + "x) " + e);
                --retryCount;
            }
        }
        log.error(ctx, "sendMessage(jmsCorrelationID=" + jmsCorrelationID + "): " + m.toString());
    }

    private void sendStats(Long requestId, String msisdn, Set<Integer> visitedCategories, WintellActionContext requestContext) {
        if (visitedCategories == null || visitedCategories.isEmpty()) {
            log.warn(requestContext, "STATS|" + msisdn + ": No categories visited in this request");
            return;
        }
        if (log.isDebugEnabled()) {
            String ll = "";
            for (Integer i : visitedCategories) {
                if (!ll.equals("")) {
                    ll = String.valueOf(ll) + ", ";
                }
                ll = String.valueOf(ll) + i;
            }
            log.debug(requestContext, "STATS|" + msisdn + ":" + ll);
        }
        if (this.handler.isConfValueTrue("ags.skippBlazeStats")) {
            return;
        }
        this.om.startState(WintellStats.RequestState.JMS_SEND_STATS, (WintellActionContext)this.httpSessionContext);
        BlazeStatsMessage m = new BlazeStatsMessage(requestId, msisdn, visitedCategories);
        try {
            this.sendMessage(requestContext, m, "AGS:R:" + requestId);
            m = null;
        }
        catch (Exception e) {
            log.error(requestContext, "Caught exception while sending MSISDN stats", (Throwable)e);
        }
        this.om.stopState(WintellStats.RequestState.JMS_SEND_STATS, (WintellActionContext)this.httpSessionContext);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=30L)
    public void stopRequest() {
        try {
            this.om.stopRequest();
        }
        catch (Exception e) {
            log.error((WintellActionContext)this.httpSessionContext, "unhandled exception in stopRequest()", (Throwable)e);
            this.om = null;
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=30L)
    public String getActiveTabId() {
        return this.wTabs.getActiveTabId();
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=30L)
    public void setActiveTabId(String tabId) {
        log.info((WintellActionContext)this.httpSessionContext, "setActiveTabId(" + tabId + ") was called");
        try {
            this.om.addFlag("SW", tabId);
            if (this.tabIdtoClose != null && !"null".equals(this.tabIdtoClose)) {
                this.closeTab();
                return;
            }
            this.wTabs.activate(tabId);
            this.trimLru();
        }
        catch (Exception e) {
            this.failRequest(e);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=30L)
    public String closeAllTabs() {
        log.info((WintellActionContext)this.httpSessionContext, "closeAllTabs() was called");
        try {
            this.om.addFlag("CL", "ALL:" + this.httpSessionContext.getLogIdChain().getTopId().getIdentity());
            this.dbFlush();
            this.wTabs.closeAll();
        }
        catch (Exception e) {
            this.failRequest(e);
        }
        return "wintell-tabs";
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=30L)
    public String closeTab() {
        block3: {
            log.info((WintellActionContext)this.httpSessionContext, "closeTab(" + this.tabIdtoClose + ") was called");
            this.om.addFlag("CL", this.tabIdtoClose);
            if (!this.wTabs.closeTab(this.tabIdtoClose)) break block3;
            return "wintell-tabs";
        }
        try {
            this.trimLru();
        }
        catch (Exception e) {
            this.failRequest(e);
        }
        return "wintell-tabs";
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=30L)
    public String submitWeb(WintellOfferActivity woa, int buttonId) {
        log.info((WintellActionContext)this.httpSessionContext, "submitWeb(" + woa + ", buttonId=" + buttonId + ") was called");
        try {
            this.om.addFlag("SUBW", this.wTabs.getActiveTabId());
            this.shallOpenWeb = false;
            WintellStats stats = new WintellStats();
            IvccWintellHandler ivccHandler = this.wTabs.submitWeb(woa, buttonId, this.handler, stats);
            this.om.addStats(stats);
            this.webUrl = ivccHandler.getUrl();
            if (this.webUrl != null) {
                this.shallOpenWeb = true;
                this.webAttributes = ivccHandler.getAttributes();
                this.webWindowName = ivccHandler.getWindowName();
            }
            if (this.shallOpenWeb.booleanValue()) {
                log.info((WintellActionContext)this.httpSessionContext, "WEB: windowName=" + this.webWindowName + ",url=" + this.webUrl + ", attributes: " + this.webAttributes);
            }
            this.trimLru();
        }
        catch (WintellDGException e) {
            return this.failDGRequest(e);
        }
        catch (Exception e) {
            this.failRequest(e);
        }
        return "OK";
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=30L)
    public String submit() {
        try {
            log.info((WintellActionContext)this.httpSessionContext, "submit(activaTabId=" + this.wTabs.getActiveTabId() + ")");
            this.om.addFlag("SUB", this.wTabs.getActiveTabId());
            WintellStats stats = new WintellStats();
            this.wTabs.submit(this.handler, stats);
            this.om.addStats(stats);
            this.trimLru();
        }
        catch (WintellDGException e) {
            return this.failDGRequest(e);
        }
        catch (Exception e) {
            this.failRequest(e);
        }
        return "OK";
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=30L)
    public Boolean adviseNodeOpened(String key, Object rowData) {
        return this.wTabs.adviseNodeOpened(key, rowData, this.om.getFolderCategories());
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=30L)
    public void toggleListener(TreeToggleEvent event) {
        boolean isCollapsed = event.isCollapsed();
        log.info((WintellActionContext)this.httpSessionContext, "toggleListener() was called: collapsed=" + isCollapsed);
        this.om.addFlag("EXP", "NODE");
        String key = event.getComponent().getClientId();
        this.wTabs.toggleListener(key);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=30L)
    public String toggleDebug() {
        try {
            boolean debugEvent = this.wTabs.togleDebug();
            this.om.addFlag("TOGLE", "DEBUG=" + debugEvent + ":" + this.httpSessionContext.getLogIdChain().getTopId().getIdentity());
            this.om.setDebugEvent(debugEvent);
            this.trimLru();
            this.logAllRequests();
            log.info((WintellActionContext)this.httpSessionContext, "toggleDebug() was called => " + debugEvent);
        }
        catch (Exception e) {
            log.info((WintellActionContext)this.httpSessionContext, "toggleDebug() was called => EXEPTION: " + e.getMessage());
            this.failRequest(e);
        }
        return "success";
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=30L)
    public void logAllRequests() throws WintellAppException {
        try {
            if (!this.om.isDebugEvent() || this.om.isLogSend() || !this.wTabs.isLogged()) {
                return;
            }
            String activeTabId = this.wTabs.getActiveTabId();
            if ("???".equals(activeTabId)) {
                return;
            }
            this.prepareOM();
            for (AgsEvent e : this.om.getSessionEvents(activeTabId)) {
                List rls = (e = (AgsEvent)this.em.find(AgsEvent.class, (Object)e.getRequestId())).getLogReq();
                if (!rls.isEmpty()) continue;
                RequestClass rc = new RequestClass(this.httpSessionContext, this.em);
                DefaultWintellActionContext ctx = new DefaultWintellActionContext(WintellSubprojectEnum.AGS, LogIdFactory.createRequestId((long)e.getRequestId()));
                log.info((WintellActionContext)ctx, "logging debug into LOG_REQUEST");
                Request baRequest = null;
                try {
                    if (this.wTabs.getRvaResponse(activeTabId) != null && this.wTabs.getRvaResponse(activeTabId).getResponseData() != null && this.wTabs.getMiResp(activeTabId) != null && !this.handler.isConfValueTrue("ags.skippInitRequest")) {
                        baRequest = rc.initRequest(e, this.wTabs.getRvaResponse(activeTabId).getResponseData(), this.wTabs.getMiResp(activeTabId), (WintellActionContext)ctx);
                    }
                }
                catch (Exception er) {
                    log.fatal((WintellActionContext)ctx, "cannot create query for blaze to log", (Throwable)er);
                    baRequest = null;
                }
                if (this.wTabs.getRvaResponse(activeTabId) != null) {
                    this.logDebug(new RequestLog((GeneralEvent)e, (Object)this.wTabs.getRvaResponse(activeTabId), "DG.debug", "RESP", (WintellActionContext)ctx));
                }
                if (this.wTabs.getMiResp(activeTabId) != null) {
                    this.logDebug(new RequestLog((GeneralEvent)e, (Object)this.wTabs.getMiResp(activeTabId), "DGM.debug", "RESP", (WintellActionContext)ctx));
                }
                if (baRequest == null) continue;
                String reqType = "BA-" + e.getClass().getSimpleName() + ".debug";
                this.logDebug(new RequestLog((GeneralEvent)e, (Object)baRequest, reqType, "REQ", (WintellActionContext)ctx));
            }
        }
        catch (Exception e) {
            throw new WintellAppException(e);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=30L)
    public String translateMessage(String text, String tabId) throws WintellAppException {
        try {
            return this.translateMessage2(text, tabId);
        }
        catch (WintellAppException e) {
            log.error((WintellActionContext)this.httpSessionContext, "error in translateMessage(" + text + "): " + e.getMessage());
            return String.valueOf(text) + ":<br><font color=red><b>ERROR:</b>" + e.getMessage() + "</font>";
        }
        catch (Exception e) {
            throw new WintellAppException(e);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=30L)
    public String translateMessage(String text) throws WintellAppException {
        try {
            return this.translateMessage(text, this.wTabs.getActiveTabId());
        }
        catch (WintellAppException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WintellAppException(e);
        }
    }

    private String translateMessage2(String text, String tabId) throws WintellAppException {
        String origText = text;
        try {
            WintellActionHandle wah = null;
            Pattern mSubst = Pattern.compile("(.*?)#\\{([^}]+)\\}(.*)", 40);
            String retText = "";
            while (true) {
                String val;
                Matcher mamSubst;
                if (!(mamSubst = mSubst.matcher(text)).matches()) break;
                retText = String.valueOf(retText) + mamSubst.group(1);
                if (wah == null) {
                    WintellTabData tabData = this.wTabs.getTabData(tabId, false, (WintellActionContext)this.httpSessionContext);
                    if (!tabData.isDG() && tabData.getException() == null) {
                        tabData = this.wTabs.getTabData(tabId, false, (WintellActionContext)this.httpSessionContext);
                    }
                    wah = new WintellActionHandleAgs(tabData, this.em, this.handler, (WintellActionContext)this.httpSessionContext);
                }
                if ((val = wah.getAttrValue(mamSubst.group(2))) != null) {
                    retText = String.valueOf(retText) + val;
                }
                text = mamSubst.group(3);
            }
            retText = String.valueOf(retText) + text;
            if (log.isDebugEnabled()) {
                log.debug((WintellActionContext)this.httpSessionContext, "translateMessage(" + origText + ") => " + retText);
            }
            return retText;
        }
        catch (Exception e) {
            log.error((WintellActionContext)this.httpSessionContext, "error in translateMessage(" + origText + "): " + e.getMessage());
            return text;
        }
    }

    private void logDebug(RequestLog requestLog) {
        requestLog.setDelta(null);
        this.em.persist((Object)requestLog);
    }

    public void trimLru() throws WintellAppException {
        int maxTabs;
        try {
            maxTabs = Integer.parseInt(this.handler.getConfValue("ags.maxTabs"));
        }
        catch (Exception e) {
            maxTabs = 3;
        }
        this.dbFlush();
        if (this.wTabs.isLogged()) {
            this.wTabs.trimLru(maxTabs);
        }
    }

    public String failRequest(String message) {
        this.wTabs.failRequest(message);
        return "known-error";
    }

    private String failRequest(Exception e) {
        log.error((WintellActionContext)this.httpSessionContext, "request failed: " + e.getMessage(), (Throwable)e);
        this.om.setErrCode(-1);
        return this.failRequest(e.getMessage());
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=30L)
    public String failRequest(int errorCode, String string) {
        this.om.setErrCode(errorCode);
        return this.failRequest(string);
    }

    private String failDGRequest(Exception e) {
        log.error((WintellActionContext)this.httpSessionContext, "data gathering error", (Throwable)e);
        return this.failRequest("Chyba p\u0159i z\u00edsk\u00e1v\u00e1n\u00ed dat: " + e.getClass().getName());
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=30L)
    public void failStatsAndLogs() {
        this.om.failStatsAndLogs();
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=30L)
    public void startRequest(String url, WintellActionContext ctx) {
        this.om.startRequest(url);
        try {
            this.prepareOM();
        }
        catch (WintellException e1) {
            log.error(ctx, "error in prepareOM()  : " + e1.getMessage());
        }
        if (log.isDebugEnabled()) {
            log.debug(ctx, "AFTER prepareOM()");
        }
    }

    private void initOM(HttpServletRequest req, boolean fromRequest) {
        try {
            this.om = fromRequest ? (IWintellObjectManager)req.getAttribute("wintellObjectManager") : null;
            if (this.om == null) {
                InitialContext c = new InitialContext();
                this.om = (IWintellObjectManager)c.lookup("java:app/wintell.jar/wintellObjectManager");
                log.info((WintellActionContext)this.httpSessionContext, "om==null, allocating new one(url=" + req.getRequestURI() + ")");
                req.setAttribute("wintellObjectManager", (Object)this.om);
            }
        }
        catch (NamingException e1) {
            log.error((WintellActionContext)this.httpSessionContext, "cannot find wintellObjectManager", (Throwable)e1);
            this.om = null;
        }
    }

    @AroundInvoke
    public Object aroundInvoke(InvocationContext ctx) throws Exception {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null) {
            HttpServletRequest req = (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
            this.shallOpenWeb = (Boolean)Component.getInstance((String)"shallOpenWeb", (ScopeType)ScopeType.EVENT, (boolean)false);
            this.webUrl = (String)Component.getInstance((String)"webUrl", (ScopeType)ScopeType.EVENT, (boolean)false);
            this.webAttributes = (String)Component.getInstance((String)"webAttributes", (ScopeType)ScopeType.EVENT, (boolean)false);
            this.webWindowName = (String)Component.getInstance((String)"webWindowName", (ScopeType)ScopeType.EVENT, (boolean)false);
            this.tabIdtoClose = req.getParameter("tabsForm:objectIdtoClose");
            this.om = (IWintellObjectManager)Component.getInstance((String)"wintellObjectManager", (ScopeType)ScopeType.EVENT, (boolean)true);
            this.wTabs = (IWintellTabs)Component.getInstance((String)"wintellTabs", (boolean)true);
        }
        this.httpSessionContext = new HttpSessionContext();
        if (log.isDebugEnabled()) {
            log.debug((WintellActionContext)this.httpSessionContext, "aroundInvoke:" + ctx.getMethod() + ", this=" + this);
        }
        try {
            if (facesContext != null) {
                if (this.wTabs != null) {
                    try {
                        this.wTabs.isLogged();
                    }
                    catch (Exception e1) {
                        log.error((WintellActionContext)this.httpSessionContext, "reset wintellTabs=null, because [" + e1.getClass().getName() + "]: " + e1.getMessage(), (Throwable)e1);
                        this.wTabs = null;
                    }
                }
                if (this.wTabs == null) {
                    this.wTabs = (IWintellTabs)Component.getInstance((String)"wintellTabs", (ScopeType)ScopeType.SESSION, (boolean)true);
                    log.info((WintellActionContext)this.httpSessionContext, "wTabs==null, allocating new one");
                }
            }
            return ctx.proceed();
        }
        catch (Exception e2) {
            log.error((WintellActionContext)this.httpSessionContext, "uncatched exeption[class=" + e2.getClass().getSimpleName() + "]:" + e2.getMessage(), (Throwable)e2);
            throw e2;
        }
    }

    @Remove
    void remove() {
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=30L)
    public String getWintellCss() {
        Query q = this.em.createNamedQuery("allCssClasses");
        List csList = q.getResultList();
        String ret = "";
        ret = String.valueOf(ret) + "/* ------------ requestBean.getWintellCss() - start ------------*/\n";
        for (WintellCssClass cs : csList) {
            CSSOMParser parser = new CSSOMParser();
            InputSource source = new InputSource((Reader)new StringReader(cs.getCssClassDef()));
            CSSStyleSheet stylesheet = null;
            try {
                stylesheet = parser.parseStyleSheet(source, null, null);
            }
            catch (IOException e) {
                log.error((WintellActionContext)this.httpSessionContext, String.format("cssparsing error(for css_class_id=%s): %s", cs.getCssClassId(), e.getMessage()));
                continue;
            }
            CSSRuleList ruleList = stylesheet.getCssRules();
            int i = 0;
            while (i < ruleList.getLength()) {
                CSSRule r = ruleList.item(i);
                ret = String.valueOf(ret) + "*." + cs.getCssClassId() + " " + r.getCssText();
                ++i;
            }
        }
        ret = String.valueOf(ret) + "/* ------------ requestBean.getWintellCss() - end ------------*/\n";
        return ret;
    }

    static class OutputSort<T>
    implements Comparator<T> {
        OutputSort() {
        }

        @Override
        public int compare(Object obj1, Object obj2) {
            Integer i1 = ((DecisionOutput)obj1).getListPriority();
            Integer i2 = ((DecisionOutput)obj2).getListPriority();
            int ret = i1.compareTo(i2);
            return ret;
        }
    }
}

