/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell;

import cz.nextiraone.tmobile.wintell.RegistryTariffCode;
import cz.nextiraone.tmobile.wintell.RegistryTeamType;
import cz.nextiraone.tmobile.wintell.ags.model.ArdwTariffsType;
import cz.nextiraone.tmobile.wintell.ags.model.BillingArrangement;
import cz.nextiraone.tmobile.wintell.ags.model.Case;
import cz.nextiraone.tmobile.wintell.ags.model.CaseStat;
import cz.nextiraone.tmobile.wintell.ags.model.Customer;
import cz.nextiraone.tmobile.wintell.ags.model.HintsType;
import cz.nextiraone.tmobile.wintell.ags.model.Request;
import cz.nextiraone.tmobile.wintell.ags.model.Skill;
import cz.nextiraone.tmobile.wintell.ags.model.Subscriber;
import cz.nextiraone.tmobile.wintell.ags.model.Team;
import cz.nextiraone.tmobile.wintell.ags.model.User;
import cz.nextiraone.tmobile.wintell.context.WintellActionContext;
import cz.nextiraone.tmobile.wintell.events.AgsEvent;
import cz.nextiraone.tmobile.wintell.events.FindCaller;
import cz.nextiraone.tmobile.wintell.events.NotifyAcceptCaseEvent;
import cz.nextiraone.tmobile.wintell.events.NotifySaveCaseEvent;
import cz.nextiraone.tmobile.wintell.exceptions.WintellAppException;
import cz.nextiraone.tmobile.wintell.logger.WintellLogger;
import cz.nextiraone.tmobile.wintell.request.Map2Bom;
import cz.nextiraone.tmobile.wintell.utils.HttpSessionContext;
import cz.tmobile.ei.wintell.datatypes.CalcValuesRecord;
import cz.tmobile.ei.wintell.datatypes.CallCentre;
import cz.tmobile.ei.wintell.datatypes.CaseSummary;
import cz.tmobile.ei.wintell.datatypes.MoreInfoResp;
import cz.tmobile.ei.wintell.datatypes.Pac;
import cz.tmobile.ei.wintell.datatypes.Tariff;
import cz.tmobile.ei.wintell.datatypes.TeamMember;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.xml.bind.JAXBElement;

public class RequestClass {
    private static final WintellLogger log = WintellLogger.getLogger(RequestClass.class);
    private HttpSessionContext httpSessionContext;
    private EntityManager em;

    public RequestClass(HttpSessionContext httpSessionContext, EntityManager em) {
        this.httpSessionContext = httpSessionContext;
        this.em = em;
    }

    public ArrayList<CaseStat> caseStats(MoreInfoResp mi, WintellActionContext requestContext) {
        CaseStats c = new CaseStats();
        if (mi.getBillingArrangement() != null) {
            CaseSummary ba = mi.getBillingArrangement().getCaseSummary();
            c.add("CMBAOPALL", (JAXBElement<Double>)ba.getCmplOpenCnt());
            c.add("CMBADSALL", (JAXBElement<Double>)ba.getCmplDispCnt());
            c.add("CMBACSALL", (JAXBElement<Double>)ba.getCmplCloseCnt());
            c.add("CMBASVALL", (JAXBElement<Double>)ba.getCmplSolveCnt());
            c.add("FRBAALLALL", (JAXBElement<Double>)ba.getFraudCnt());
            c.add("CLBAOPDSALL", (JAXBElement<Double>)ba.getCollOpenCnt());
            c.add("TMBAOPALL", (JAXBElement<Double>)ba.getTermOpenCnt());
            c.add("RTBAALL12M", (JAXBElement<Double>)ba.getReteAllCnt());
            c.add("RTBAOP12M", (JAXBElement<Double>)ba.getReteOpenCnt());
            c.add("RTBADS12M", (JAXBElement<Double>)ba.getReteDispCnt());
            c.add("CLCUOPDSALL", "CLBAOPDSALL");
        }
        if (mi.getCustomer() != null) {
            CaseSummary cu = mi.getCustomer().getCaseSummary();
            c.add("CMCUOPALL", (JAXBElement<Double>)cu.getCmplOpenCnt());
            c.add("CMCUDSALL", (JAXBElement<Double>)cu.getCmplDispCnt());
            c.add("CMCUCSALL", (JAXBElement<Double>)cu.getCmplCloseCnt());
            c.add("CMCUSVALL", (JAXBElement<Double>)cu.getCmplSolveCnt());
            c.add("FRCUALLALL", (JAXBElement<Double>)cu.getFraudCnt());
            c.add("TMCUOPALL", (JAXBElement<Double>)cu.getTermOpenCnt());
            c.add("RTCUALL12M", (JAXBElement<Double>)cu.getReteAllCnt());
            c.add("RTCUOPALL", (JAXBElement<Double>)cu.getReteOpenCnt());
            c.add("RTCUDSALL", (JAXBElement<Double>)cu.getReteDispCnt());
            c.add("RTCUOP12M", "RTCUOPALL");
            c.add("RTCUDS12M", "RTCUDSALL");
        }
        if (mi.getSubscriber() != null) {
            CaseSummary su = mi.getSubscriber().getCaseSummary();
            c.add("CMSUOPALL", (JAXBElement<Double>)su.getCmplOpenCnt());
            c.add("CMSUDSALL", (JAXBElement<Double>)su.getCmplDispCnt());
            c.add("CMSUCSALL", (JAXBElement<Double>)su.getCmplCloseCnt());
            c.add("CMSUSVALL", (JAXBElement<Double>)su.getCmplSolveCnt());
            c.add("FLSUOPALL", (JAXBElement<Double>)su.getFailOpenCnt());
            c.add("FLSUDSALL", (JAXBElement<Double>)su.getFailDispCnt());
            c.add("FLSUCSALL", (JAXBElement<Double>)su.getFailCloseCnt());
            c.add("FRSUALLALL", (JAXBElement<Double>)su.getFraudCnt());
            c.add("TMSUOPALL", (JAXBElement<Double>)su.getTermOpenCnt());
            c.add("RTSUALLALL", (JAXBElement<Double>)su.getReteAllCnt());
            c.add("RTSUOPALL", (JAXBElement<Double>)su.getReteOpenCnt());
            c.add("RTSUDSALL", (JAXBElement<Double>)su.getReteDispCnt());
            c.add("RTSUCSALL", (JAXBElement<Double>)su.getReteCloseCnt());
            c.add("RTSUCS14D", (JAXBElement<Double>)su.getReteAll14Cnt());
            c.add("RTSUOP14D", (JAXBElement<Double>)su.getReteOpen14Cnt());
            c.add("RTSUCS14DSR", (JAXBElement<Double>)su.getReteClose14Cnt());
            c.add("PRSUCS12M", (JAXBElement<Double>)su.getSalesCloseCnt());
            c.add("WLCULECLALL", (JAXBElement<Double>)su.getOutboundCallsCnt());
            c.add("RTCUCS12M", "RTSUCSALL");
        }
        c.add("CMALLCS3C", "CMBACSALL+CMCUCSALL+CMSUCSALL");
        c.add("CMALLDP3C", "CMBADSALL+CMCUDSALL+CMSUDSALL");
        c.add("CMALLOPDP3C", "CMBAOPALL+CMBADSALL+CMCUOPALL+CMCUDSALL+CMSUOPALL+CMSUDSALL");
        c.add("CMALLSV3C", "CMBASVALL+CMCUSVALL+CMSUSVALL");
        c.add("FLALLALLALL", "FLSUCSALL+FLSUDSALL+FLSUOPALL");
        c.add("FLALLCS3C", "FLSUCSALL");
        c.add("FLALLOP3C", "FLSUOPALL+FLSUDSALL");
        c.add("FLSUCS3C", "FLSUCSALL");
        c.add("FLSUOP3C", "FLSUOPALL");
        c.add("FRALLOPDS12M", "FRBAALLALL+FRCUALLALL+FRSUALLALL");
        c.add("FRBAOPDS12M", "FRBAALLALL");
        c.add("FRSUOPDS12M", "FRSUALLALL");
        c.add("RTALLALL12M", "RTBAALL12M+RTCUALL12M+RTSUALLALL");
        c.add("RTALLALLALL", "RTBAALL12M+RTCUALL12M+RTSUALLALL");
        c.add("RTALLDSALL", "RTBADS12M+RTCUDS12M+RTSUDSALL");
        c.add("RTALLOPALL", "RTBAOP12M+RTCUOP12M+RTSUOPALL");
        c.add("RTSUCS12M", "RTSUCSALL");
        c.add("TMCLOPDSALL", "TMBAOPALL+TMCUOPALL+TMSUOPALL");
        c.add("CMALLOP3C", "CMCUOPALL+CMSUOPALL+CMBAOPALL");
        ArrayList<CaseStat> ret = c.getResult();
        c = null;
        if (mi.getCalcValues() != null) {
            for (CalcValuesRecord cv : mi.getCalcValues()) {
                int numOfCases = 0;
                try {
                    numOfCases = Integer.parseInt(cv.getValue());
                }
                catch (Exception e) {
                    log.error(requestContext, "CaseStat: cannot parse value='" + cv.getValue() + "' -> for key='" + cv.getCode() + "'");
                }
                CaseStat cs = new CaseStat();
                cs.setCode(cv.getCode());
                cs.setNumOfCases(numOfCases);
                ret.add(cs);
            }
        }
        return ret;
    }

    public Request initRequest(AgsEvent a, cz.tmobile.ei.wintell.datatypes.Customer cus, MoreInfoResp mi, WintellActionContext requestContext) {
        NotifySaveCaseEvent ce;
        Request request = new Request();
        CallCentre callCentre = new CallCentre();
        callCentre.setServiceLevel(new BigInteger("0"));
        cus.setCallCentre(callCentre);
        Tariff t = ((cz.tmobile.ei.wintell.datatypes.Subscriber)((cz.tmobile.ei.wintell.datatypes.BillingArrangement)cus.getBillingArrangementList().get(0)).getSubscriberList().get(0)).getTariff();
        RegistryTariffCode tc = (RegistryTariffCode)this.em.find(RegistryTariffCode.class, (Object)t.getId().intValue());
        if (tc == null) {
            log.fatal(requestContext, "cannot set SU.Tariff, tariff not found, id: " + t.getId());
        } else {
            t.setCode(tc.getTarTargCode());
            t.setDescription(tc.getTarCzDes());
            if (tc.getTarTartCode() != null) {
                t.setType(tc.getTarTartCode().getTartCode());
            }
        }
        try {
            List pl = ((cz.tmobile.ei.wintell.datatypes.Subscriber)((cz.tmobile.ei.wintell.datatypes.BillingArrangement)cus.getBillingArrangementList().get(0)).getSubscriberList().get(0)).getPacList();
            for (Pac p : mi.getPacList().getPac()) {
                pl.add(p);
            }
        }
        catch (Exception er) {
            log.info(requestContext, "cannot set SU.Paclist: " + er.getMessage());
        }
        try {
            ((cz.tmobile.ei.wintell.datatypes.Subscriber)((cz.tmobile.ei.wintell.datatypes.BillingArrangement)cus.getBillingArrangementList().get(0)).getSubscriberList().get(0)).setChurnScore(mi.getSubscriber().getChurnScore());
        }
        catch (Exception er) {
            log.info(requestContext, "cannot set SU.ChurnScore: " + er.getMessage());
        }
        Customer custAgs = new Customer();
        Map2Bom.mapStructure((Object)cus, (Object)custAgs, (WintellActionContext)requestContext);
        try {
            Double invoicedAmountM3 = (Double)mi.getBillingArrangement().getInvoiceInfo().getInvoicedAmountM3().getValue() / 3.0;
            ((BillingArrangement)custAgs.getBillingArrangementList().get(0)).setAvgInvoiceAmount(invoicedAmountM3.doubleValue());
        }
        catch (Exception invoicedAmountM3) {
            // empty catch block
        }
        Case requestCase = new Case();
        if (a instanceof NotifySaveCaseEvent) {
            ce = (NotifySaveCaseEvent)a;
            requestCase.setCloseDate(null);
            requestCase.setCreationDate(ce.getCrtime());
            requestCase.setId(ce.getCaseid());
            requestCase.setMedium(ce.getMedia());
            requestCase.setMff(null);
            requestCase.setQueue(null);
            if (ce.getPsss1() != null) {
                requestCase.setProcess(ce.getPsss1().toString());
            }
            if (ce.getPsss2() != null) {
                requestCase.setSubject(ce.getPsss2().toString());
            }
            if (ce.getPsss3() != null) {
                requestCase.setSubSubject(ce.getPsss3().toString());
            }
            if (ce.getPsss4() != null) {
                requestCase.setStep(ce.getPsss4().toString());
            }
            requestCase.setTitle(ce.getProcid());
            requestCase.setUpdateDate(null);
            requestCase.setUserId(-1);
        } else if (a instanceof NotifyAcceptCaseEvent) {
            ce = (NotifyAcceptCaseEvent)a;
            requestCase.setCloseDate(null);
            requestCase.setCreationDate(null);
            requestCase.setId(ce.getCaseid());
            requestCase.setMedium(null);
            requestCase.setMff(null);
            if (ce.getQueue() != null) {
                requestCase.setQueue(ce.getQueue().toString());
            }
            if (ce.getPsss1() != null) {
                requestCase.setProcess(ce.getPsss1().toString());
            }
            if (ce.getPsss2() != null) {
                requestCase.setSubject(ce.getPsss2().toString());
            }
            if (ce.getPsss3() != null) {
                requestCase.setSubSubject(ce.getPsss3().toString());
            }
            if (ce.getPsss4() != null) {
                requestCase.setStep(ce.getPsss4().toString());
            }
            requestCase.setTitle(ce.getProcid());
            requestCase.setUpdateDate(null);
            requestCase.setUserId(-1);
        }
        ArrayList<Team> teamList = new ArrayList<Team>();
        try {
            Team team = new Team();
            try {
                team.setId(((Integer)Map2Bom.getField((Object)a, (String)"Team")).intValue());
                team.setName((String)Map2Bom.getField((Object)a, (String)"Teamname"));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if ((team.getId() == 0 || team.getName() != null && team.getName().equals("")) && mi.getClfyTeam() != null && !mi.getClfyTeam().isNil()) {
                team.setId(((Double)mi.getClfyTeam().getValue()).intValue());
                RegistryTeamType tt = (RegistryTeamType)this.em.find(RegistryTeamType.class, (Object)team.getId());
                if (tt == null) {
                    throw new WintellAppException("cannot find team[id=" + team.getId() + "]");
                }
                team.setName(tt.getDescription());
            }
            if (log.isDebugEnabled()) {
                log.debug(requestContext, "add ClfyTeam: [" + team.getId() + "]" + team.getName());
            }
            if (team.getId() != 0 && team.getName() != null && !team.getName().equals("")) {
                teamList.add(team);
            } else {
                log.info(requestContext, "cannot add ClfyTeam: no-team available");
            }
        }
        catch (Exception e) {
            log.info(requestContext, "cannot add ClfyTeam:" + e.getMessage(), (Throwable)e);
        }
        try {
            for (TeamMember tm : mi.getCustomer().getTeamMemberList().getTeamMember()) {
                try {
                    Team team = new Team();
                    RegistryTeamType tt = (RegistryTeamType)this.em.find(RegistryTeamType.class, (Object)tm.getMemeberId().intValue());
                    team.setId(tm.getMemeberId().intValue());
                    team.setName(tt.getDescription());
                    if (log.isDebugEnabled()) {
                        log.debug(requestContext, "add TeamMember: [" + team.getId() + "]" + team.getName());
                    }
                    teamList.add(team);
                }
                catch (Exception e) {
                    log.info(requestContext, "cannot add teamMember:" + e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (Exception tm) {
            // empty catch block
        }
        ArrayList<Skill> skillList = new ArrayList<Skill>();
        if (mi.getSkillList() != null) {
            for (cz.tmobile.ei.wintell.datatypes.Skill sk : mi.getSkillList().getSkill()) {
                Skill skill = new Skill();
                skill.setId(sk.getId().intValue());
                skill.setName(sk.getName());
                skillList.add(skill);
            }
        }
        User user = new User();
        user.setId(-1);
        user.setSkillsList(skillList);
        user.setTeamList(teamList);
        user.setName(a.getUsr());
        boolean salesCoord = false;
        user.setSalesCoord(salesCoord);
        boolean salesRep = false;
        user.setSalesRep(salesRep);
        request.setCaseStatList(this.caseStats(mi, requestContext));
        if (a instanceof FindCaller) {
            FindCaller fc = (FindCaller)a;
            request.setCuiHook(fc.getHook());
        } else {
            request.setCuiHook("");
        }
        request.setCustomer(custAgs);
        request.setId(a.getRequestId().longValue());
        request.setRequestDatetime(a.getTs());
        request.setRequestCase(requestCase);
        request.setUser(user);
        try {
            cz.tmobile.ei.wintell.datatypes.HintsType srcHints = mi.getSubscriber().getHints();
            if (srcHints != null) {
                HintsType dstHints = new HintsType();
                Map2Bom.mapStructure((Object)srcHints, (Object)dstHints, (WintellActionContext)requestContext);
                ((Subscriber)((BillingArrangement)custAgs.getBillingArrangementList().get(0)).getSubscriberList().get(0)).setHints(dstHints);
            }
        }
        catch (Exception er) {
            log.info(requestContext, "cannot set SU.hints: " + er.getMessage());
        }
        try {
            cz.tmobile.ei.wintell.datatypes.ArdwTariffsType src = mi.getSubscriber().getArdwTariffs();
            if (src != null) {
                ArdwTariffsType dst = new ArdwTariffsType();
                Map2Bom.mapStructure((Object)src, (Object)dst, (WintellActionContext)requestContext);
                ((Subscriber)((BillingArrangement)custAgs.getBillingArrangementList().get(0)).getSubscriberList().get(0)).setArdwTariffs(dst);
            }
        }
        catch (Exception er) {
            log.info(requestContext, "cannot set SU.ardwTariffs: " + er.getMessage());
        }
        return request;
    }

    public class CaseStats {
        private ArrayList<CaseStat> caseStatList = new ArrayList();
        private HashMap<String, Long> caseStatsMap = new HashMap();

        public void add(String code, String codesList) {
            Long n = 0L;
            String[] stringArray = codesList.split("\\+");
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String c = stringArray[n3];
                if (this.caseStatsMap.containsKey(c)) {
                    n = n + this.caseStatsMap.get(c);
                }
                ++n3;
            }
            CaseStat cs = new CaseStat();
            cs.setCode(code);
            cs.setNumOfCases(n.intValue());
            this.caseStatList.add(cs);
            this.caseStatsMap.put(code, n);
        }

        public void add(String code, JAXBElement<Double> nn) {
            if (nn == null) {
                log.info((WintellActionContext)RequestClass.this.httpSessionContext, "caseStat[" + code + "] nn := null");
                return;
            }
            Long n = 0L;
            if (!nn.isNil()) {
                n = ((Double)nn.getValue()).longValue();
            }
            this.caseStatsMap.put(code, n);
            CaseStat cs = new CaseStat();
            cs.setCode(code);
            cs.setNumOfCases(n.intValue());
            this.caseStatList.add(cs);
        }

        public ArrayList<CaseStat> getResult() {
            return this.caseStatList;
        }
    }
}

