/*
 * Decompiled with CFR 0.152.
 */
package cz.nextiraone.tmobile.wintell;

import cz.nextiraone.tmobile.tibco.WintellServiceHandlerRemote;
import cz.nextiraone.tmobile.wintell.WintellActionClass;
import cz.nextiraone.tmobile.wintell.WintellActionLog;
import cz.nextiraone.tmobile.wintell.WintellHandler;
import cz.nextiraone.tmobile.wintell.context.WintellActionContext;
import cz.nextiraone.tmobile.wintell.logger.WintellLogger;
import cz.nextiraone.tmobile.wintell.logger.identifiers.LogIdFactory;
import cz.nextiraone.tmobile.wintell.tibor.TibOrException;
import java.io.Serializable;
import java.util.Map;
import javax.persistence.EntityManager;

public class TiborOutWintellHandler
extends WintellHandler
implements Serializable {
    private static final long serialVersionUID = 2231301286103411404L;
    private static final WintellLogger log = WintellLogger.getLogger(TiborOutWintellHandler.class);
    WintellServiceHandlerRemote wintellServices;
    private WintellActionContext actionContext;

    public TiborOutWintellHandler(WintellServiceHandlerRemote wintellServices, WintellActionContext actionContext) {
        this.wintellServices = wintellServices;
        this.actionContext = actionContext;
    }

    @Override
    public boolean handle(EntityManager em, WintellActionLog al) {
        WintellActionClass ac = al.getAction().getActionClass();
        if (!"TIBCO_MESSAGE".equals(ac.getClassType())) {
            return false;
        }
        al.setStatus(false);
        Long processId = al.getTibProcessId();
        log.info(this.actionContext, "sending message[" + al.getAction().getActionid() + ", actionLogId=" + al.getActionLogId() + "], TIB_PROCESS_ID=" + processId);
        Map<String, String> body = this.getBody(al, this.actionContext);
        if (body.get("TIB_PROCESS_ID") != null) {
            try {
                processId = Long.parseLong(body.get("TIB_PROCESS_ID"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (processId == null) {
            String err = "error when sendig message [actionId:" + al.getAction().getActionid() + "]: no TIB_PROCESS_ID can be counted";
            log.fatal(this.actionContext, err);
            return true;
        }
        WintellActionContext tibProcessIdCtx = this.actionContext.getMoreSpecificContext(LogIdFactory.createTibProcessId((long)processId));
        String msgName = ac.getSubType();
        try {
            this.wintellServices.sendMessageRaw(msgName, body, processId, tibProcessIdCtx);
            al.setStatus(true);
        }
        catch (TibOrException er) {
            String err = "error when sendig message[actionId:" + al.getAction().getActionid() + "]:" + er.getMessage();
            log.fatal(tibProcessIdCtx, err, (Throwable)er);
        }
        catch (Exception e) {
            log.fatal(tibProcessIdCtx, "Tibor is not ready: " + e.getMessage(), (Throwable)e);
        }
        return true;
    }
}

